/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowHDRFormatFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowHDRFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.contains((CharSequence)s2));
        this.buildHdrArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildHdrArray();
        this.tvShowList.addPropertyChangeListener("hdrFormat", propertyChangeListener);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.hdrformat"));
    }

    @Override
    public String getId() {
        return "hdrFormatFilter";
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            for (String sel : selectedItems) {
                if (!(invert ^ episode.getVideoHDRFormat().contains(sel))) continue;
                return true;
            }
        }
        return false;
    }

    public void buildHdrArray() {
        ArrayList<String> hdrformats = new ArrayList<String>(this.tvShowList.getHdrFormatInEpisodes());
        Collections.sort(hdrformats);
        this.setValues(hdrformats);
    }
}

