/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoContainerFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowVideoContainerFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallContainerArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallContainerArray();
        this.tvShowList.addPropertyChangeListener("videoContainer", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "tvShowVideoContainer";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            String container = episode.getMediaInfoContainerFormat();
            for (String value : selectedValues) {
                if (!(invert ^ value.equalsIgnoreCase(container))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.container"));
    }

    private void buildAndInstallContainerArray() {
        ArrayList<String> containers = new ArrayList<String>(this.tvShowList.getVideoContainersInEpisodes());
        Collections.sort(containers);
        this.setValues(containers);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

