/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.panels.ImagePanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowArtworkPanel
extends JPanel {
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private ImagePanel imagePanel;

    public TvShowArtworkPanel(TvShowSelectionModel selectionModel) {
        this.initComponents();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSelectionModel.class) {
                return;
            }
            if ("selectedTvShow".equals(property) || "mediaFiles".equals(property)) {
                List<MediaFile> list = this.mediaFiles;
                synchronized (list) {
                    this.mediaFiles.clear();
                    this.mediaFiles.addAll(selectionModel.getSelectedTvShow().getMediaFiles().stream().filter(MediaFile::isGraphic).toList());
                    for (TvShowSeason season : selectionModel.getSelectedTvShow().getSeasons()) {
                        this.mediaFiles.addAll(season.getMediaFiles().stream().filter(MediaFile::isGraphic).toList());
                    }
                    this.mediaFiles.sort(Comparator.comparing(MediaFile::getType));
                    this.imagePanel.rebuildPanel();
                }
            }
        };
        selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        this.imagePanel = new ImagePanel(this.mediaFiles);
        this.imagePanel.setMaxWidth(500);
        this.imagePanel.setMaxHeight(200);
        this.add((Component)this.imagePanel, "cell 0 0,grow");
    }
}

