/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.tvshows.panels.TvShowScraperMetadataPanel;

class TvShowScraperOptionsSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JComboBox<CountryItem> cbReleaseCountry;
    private JCheckBox chckbxCapitalizeWords;
    private JCheckBox chckbxDoNotOverwrite;
    private JCheckBox chckbxFetchAllRatings;

    TvShowScraperOptionsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        for (String country : Locale.getISOCountries()) {
            CountryItem item = new CountryItem(new Locale("", country));
            this.cbReleaseCountry.addItem(item);
            if (!item.locale.getCountry().equalsIgnoreCase(this.settings.getReleaseDateCountry())) continue;
            this.cbReleaseCountry.setSelectedItem(item);
        }
        this.cbReleaseCountry.addItemListener(l -> this.settings.setReleaseDateCountry(((CountryItem)this.cbReleaseCountry.getSelectedItem()).locale.getCountry()));
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][]15lp![][15lp!][][15lp!][]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][]"));
        TmmLabel lblOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0 2 1");
        JLabel lblCountry = new JLabel(TmmResourceBundle.getString("Settings.certificationCountry"));
        panelOptions.add((Component)lblCountry, "cell 1 1 2 1");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelOptions.add(this.cbCertificationCountry, "cell 1 1 2 1");
        JLabel label = new JLabel(TmmResourceBundle.getString("Settings.releaseDateCountry"));
        panelOptions.add((Component)label, "flowx,cell 1 2 2 1");
        this.cbReleaseCountry = new JComboBox();
        panelOptions.add(this.cbReleaseCountry, "cell 1 2 2 1");
        this.chckbxFetchAllRatings = new JHintCheckBox(TmmResourceBundle.getString("Settings.fetchallratings"));
        this.chckbxFetchAllRatings.setToolTipText(TmmResourceBundle.getString("Settings.fetchallratings.desc"));
        panelOptions.add((Component)this.chckbxFetchAllRatings, "cell 1 3 2 1");
        this.chckbxCapitalizeWords = new JCheckBox(TmmResourceBundle.getString("Settings.scraper.capitalizeWords"));
        panelOptions.add((Component)this.chckbxCapitalizeWords, "cell 1 4");
        JPanel panelDefaults = new JPanel();
        panelDefaults.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][]"));
        TmmLabel lblDefaultsT = new TmmLabel(TmmResourceBundle.getString("scraper.metadata.defaults"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelDefaults, lblDefaultsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#metadata-scrape-defaults"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        TvShowScraperMetadataPanel scraperMetadataPanel = new TvShowScraperMetadataPanel();
        panelDefaults.add((Component)scraperMetadataPanel, "cell 1 0 2 1");
        this.chckbxDoNotOverwrite = new JCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        panelDefaults.add((Component)this.chckbxDoNotOverwrite, "cell 1 1 2 1");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"capitalWordsInTitles");
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.chckbxCapitalizeWords, (Property)jCheckBoxBeanProperty_1);
        autoBinding_9.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"doNotOverwriteExistingData");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxDoNotOverwrite, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"fetchAllRatings");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
    }

    private static class CountryItem {
        private final Locale locale;

        public CountryItem(Locale locale) {
            this.locale = locale;
        }

        public String toString() {
            return this.locale.getCountry() + " - " + this.locale.getDisplayCountry();
        }
    }
}

