/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileIdentifierDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ICBTag;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

public class ExtendedFileEntryDescriptor
extends FileEntryDescriptor {
    public BigInteger objectSize;
    public Timestamp creatiDT;
    public LongAD streamDirICB;
    public final int MINIMUM_LENGTH = 512;

    public ExtendedFileEntryDescriptor() {
    }

    public ExtendedFileEntryDescriptor(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
        this.verifyTagIdentifier();
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 266;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("File entry descriptor too short");
        }
        this.deserializeTag(bytes);
        this.icbTag = new ICBTag(this.getBytes(bytes, 20));
        this.uid = this.getUInt32(bytes);
        this.gid = this.getUInt32(bytes);
        this.permissions = this.getUInt32(bytes);
        this.fileLinks = this.getUInt16(bytes);
        this.recordFormat = this.getUInt8(bytes);
        this.recordDisplayAttrs = this.getUInt8(bytes);
        this.recordLength = this.getUInt32(bytes);
        this.infoLength = this.getUInt64(bytes);
        this.objectSize = this.getUInt64(bytes);
        this.lbRecorded = this.getUInt64(bytes);
        this.accessDT = new Timestamp(this.getBytes(bytes, 12));
        this.modifiDT = new Timestamp(this.getBytes(bytes, 12));
        this.creatiDT = new Timestamp(this.getBytes(bytes, 12));
        this.attributeDT = new Timestamp(this.getBytes(bytes, 12));
        this.checkpoint = this.getUInt32(bytes);
        this.getUInt32(bytes);
        this.extAttrICB = new LongAD(this.getBytes(bytes, 16));
        this.streamDirICB = new LongAD(this.getBytes(bytes, 16));
        this.implIdentifier = new RegId(this.getBytes(bytes, 32));
        this.uniqueId = this.getUInt64(bytes);
        this.extAttrLength = this.getUInt32(bytes);
        this.allocDescriptorLength = this.getUInt32(bytes);
        Integer maxExtAttrLen = 2048 - this.currentPos;
        if (this.extAttrLength > (long)maxExtAttrLen.intValue()) {
            throw new InvalidDescriptor("Extended attributes too long");
        }
        this.extendedAttributes = this.getBytes(bytes, this.extAttrLength.intValue());
        Integer maxAllocLen = 2048 - this.currentPos;
        if (this.allocDescriptorLength > (long)maxAllocLen.intValue()) {
            throw new InvalidDescriptor("Allocation descriptors too long");
        }
        int len = 0;
        this.allocDescriptors = new ArrayList();
        while ((long)len < this.allocDescriptorLength) {
            ExtentAD extend = new ExtentAD(this.getBytes(bytes, 8));
            len += 8;
            if (extend.length <= 0L) continue;
            this.allocDescriptors.add(extend);
        }
    }

    @Override
    public void loadChildren(UDFFileSystem fs) throws IOException {
        int bs = 2048;
        block2: for (ExtentAD ead : this.allocDescriptors) {
            int bufferLength = ead.length.intValue();
            if (bufferLength == 0) continue;
            byte[] buffer = new byte[bufferLength];
            long absStartPos = fs.getFSDloc() + ead.location;
            int bytesRead = fs.readBytes(absStartPos * (long)bs, buffer, 0, bufferLength);
            if ((long)bytesRead != ead.length) {
                throw new IOException("Failed to read " + ead.length + " bytes at the beginning of sector " + absStartPos + ". Actually read " + bytesRead + " bytes.");
            }
            int offset = 0;
            byte[] nextFragment = buffer;
            boolean first = true;
            boolean noMoreData = false;
            while (true) {
                FileIdentifierDescriptor fid;
                try {
                    fid = new FileIdentifierDescriptor(nextFragment);
                }
                catch (InvalidDescriptor ex) {
                    throw new IOException(ex.getMessage());
                }
                if ((offset += fid.getConsumption().intValue()) >= bufferLength) {
                    noMoreData = true;
                } else {
                    nextFragment = UDFUtil.getRemainingBytes(buffer, offset);
                }
                if (first) {
                    first = false;
                    continue;
                }
                this.fids.add(fid);
                if (noMoreData || nextFragment.length <= 40 || UDFUtil.getUInt16(nextFragment, 0) != 257) continue block2;
            }
        }
    }
}

