/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class SpaceBitmapDescriptor
extends UDFDescriptor {
    public Long numberOfBits;
    public Long numberOfBytes;
    public byte[] bitmap;
    public final int MINIMUM_LENGTH = 24;

    public SpaceBitmapDescriptor() {
    }

    public SpaceBitmapDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 264;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 24) {
            throw new InvalidDescriptor("Space Bitmap descriptor too short");
        }
        this.deserializeTag(bytes);
        this.numberOfBits = this.getUInt32(bytes);
        this.numberOfBytes = this.getUInt32(bytes);
        this.bitmap = this.getBytes(bytes, this.numberOfBytes.intValue());
    }
}

