/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.ArrayList;
import java.util.List;

public class UnallocatedSpaceDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSequenceNumber;
    public Long numberofAllocationDescriptors;
    public List<ExtentAD> allocationDescriptors;
    public final int MINIMUM_LENGTH = 512;

    public UnallocatedSpaceDescriptor() {
    }

    public UnallocatedSpaceDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 7;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("unallocated space descriptor too short");
        }
        this.deserializeTag(bytes);
        this.volumeDescriptorSequenceNumber = this.getUInt32(bytes);
        this.numberofAllocationDescriptors = this.getUInt32(bytes);
        this.allocationDescriptors = new ArrayList<ExtentAD>();
        for (int allocCnt = this.numberofAllocationDescriptors.intValue(); allocCnt > 0; --allocCnt) {
            ExtentAD extend = new ExtentAD(this.getBytes(bytes, 8));
            if (extend.length <= 0L) continue;
            this.allocationDescriptors.add(extend);
        }
    }
}

