/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.nio.charset.StandardCharsets;

public class CharSpec {
    public int characterSetType;
    public byte[] characterSetInfo;
    public static final int LENGTH = 64;

    public CharSpec(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
    }

    private void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 64) {
            throw new InvalidDescriptor("CharSpec allocation descriptor too short");
        }
        this.characterSetType = UDFUtil.getUInt8(bytes, 0);
        this.characterSetInfo = UDFUtil.getBytes(bytes, 1, 63);
    }

    public String toString() {
        return "CharSpec [characterSetType=" + this.characterSetType + ", characterSetInfo=" + new String(this.characterSetInfo, StandardCharsets.UTF_8).trim() + "]";
    }
}

