/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.EntryInputStream;
import com.github.stephenc.javaisotools.loopfs.iso9660.EntryIterator;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldSP;
import com.github.stephenc.javaisotools.loopfs.spi.AbstractBlockFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInputFile;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class Iso9660FileSystem
extends AbstractBlockFileSystem<Iso9660FileEntry> {
    private boolean enableSUSPScan;
    private Boolean suspUsedCache = null;

    public Iso9660FileSystem(File file, boolean readOnly) throws IOException {
        this((SeekableInput)new SeekableInputFile(file), readOnly, false);
    }

    public Iso9660FileSystem(File file, boolean readOnly, boolean enableSUSPScan) throws IOException {
        this((SeekableInput)new SeekableInputFile(file), readOnly, enableSUSPScan);
    }

    public Iso9660FileSystem(SeekableInput seekable, boolean readOnly) throws IOException {
        this(seekable, readOnly, false);
    }

    public Iso9660FileSystem(SeekableInput seekable, boolean readOnly, boolean enableSUSPScan) throws IOException {
        super(seekable, readOnly, 2048, 16);
        this.enableSUSPScan = enableSUSPScan;
    }

    public String getEncoding() {
        return ((Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet()).getEncoding();
    }

    public InputStream getInputStream(Iso9660FileEntry entry) {
        this.ensureOpen();
        return new EntryInputStream(entry, this);
    }

    byte[] getBytes(Iso9660FileEntry entry) throws IOException {
        int size = (int)entry.getSize();
        byte[] buf = new byte[size];
        this.readBytes(entry, 0L, buf, 0, size);
        return buf;
    }

    public int readBytes(Iso9660FileEntry entry, long entryOffset, byte[] buffer, int bufferOffset, int len) throws IOException {
        long startPos = entry.getStartBlock() * 2048L + entryOffset;
        return this.readData(startPos, buffer, bufferOffset, len);
    }

    protected Iterator<Iso9660FileEntry> iterator(Iso9660FileEntry _) {
        Iso9660VolumeDescriptorSet descSet = (Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet();
        Iso9660FileEntry rootEntry = descSet.getPrimaryRootEntry();
        if (this.suspUsed().booleanValue()) {
            return new EntryIterator(this, rootEntry);
        }
        if (descSet.hasSupplementary()) {
            Iso9660FileEntry supRootEntry = descSet.getSupRootEntry();
            return new EntryIterator(this, supRootEntry);
        }
        return new EntryIterator(this, rootEntry);
    }

    public Iso9660VolumeDescriptorSet getIso9660DescriptorSet() {
        if (null == this.volumeDescriptorSet) {
            try {
                this.loadVolumeDescriptors();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return (Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet();
    }

    protected VolumeDescriptorSet<Iso9660FileEntry> createVolumeDescriptorSet() {
        return new Iso9660VolumeDescriptorSet(this);
    }

    private boolean suspEnabled() {
        Iso9660VolumeDescriptorSet descSet = (Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet();
        Iso9660FileEntry root = descSet.getPrimaryRootEntry();
        if (root == null) {
            throw new RuntimeException("Root entry has not been loaded yet");
        }
        List<SuspField> suspFields = root.getSuspFields();
        if (suspFields.toArray().length < 1) {
            return false;
        }
        SuspField firstField = suspFields.get(0);
        if (firstField.getId() != 21328) {
            return false;
        }
        SuspFieldSP spField = (SuspFieldSP)firstField;
        return spField.suspEnabled();
    }

    public Boolean suspUsed() {
        if (!this.enableSUSPScan) {
            return false;
        }
        if (this.suspUsedCache != null) {
            return this.suspUsedCache;
        }
        this.suspUsedCache = this.suspEnabled();
        return this.suspUsedCache;
    }
}

