/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part15.AvcConfigurationBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.WrappingTrack;
import org.mp4parser.tools.ByteBufferByteChannel;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeWriterVariable;

public class Avc1ToAvc3TrackImpl
extends WrappingTrack {
    List<Sample> samples;
    private Map<SampleEntry, SampleEntry> avc1toavc3 = new LinkedHashMap<SampleEntry, SampleEntry>();

    public Avc1ToAvc3TrackImpl(Track parent) throws IOException {
        super(parent);
        for (SampleEntry sampleEntry : parent.getSampleEntries()) {
            if (sampleEntry.getType().equals("avc1")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    sampleEntry.getBox(Channels.newChannel(baos));
                    VisualSampleEntry avc3SampleEntry = (VisualSampleEntry)new IsoFile((ReadableByteChannel)new ByteBufferByteChannel(ByteBuffer.wrap(baos.toByteArray()))).getBoxes().get(0);
                    avc3SampleEntry.setType("avc3");
                    this.avc1toavc3.put(sampleEntry, (SampleEntry)avc3SampleEntry);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Dumping sample entry to memory failed");
                }
            }
            this.avc1toavc3.put(sampleEntry, sampleEntry);
        }
        this.samples = new ReplaceSyncSamplesList(parent.getSamples());
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return new ArrayList<SampleEntry>(this.avc1toavc3.values());
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    private class ReplaceSyncSamplesList
    extends AbstractList<Sample> {
        List<Sample> parentSamples;

        public ReplaceSyncSamplesList(List<Sample> parentSamples) {
            this.parentSamples = parentSamples;
        }

        @Override
        public Sample get(int index) {
            final Sample orignalSample = this.parentSamples.get(index);
            if (orignalSample.getSampleEntry().getType().equals("avc1") && Arrays.binarySearch(Avc1ToAvc3TrackImpl.this.getSyncSamples(), (long)(index + 1)) >= 0) {
                final AvcConfigurationBox avcC = (AvcConfigurationBox)orignalSample.getSampleEntry().getBoxes(AvcConfigurationBox.class).get(0);
                final int len = avcC.getLengthSizeMinusOne() + 1;
                final ByteBuffer buf = ByteBuffer.allocate(len);
                final SampleEntry se = (SampleEntry)Avc1ToAvc3TrackImpl.this.avc1toavc3.get(orignalSample.getSampleEntry());
                return new Sample(){

                    @Override
                    public SampleEntry getSampleEntry() {
                        return se;
                    }

                    @Override
                    public void writeTo(WritableByteChannel channel) throws IOException {
                        for (ByteBuffer bytes : avcC.getSequenceParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)((ByteBuffer)((Buffer)buf).rewind()), (int)len);
                            channel.write((ByteBuffer)((Buffer)buf).rewind());
                            channel.write(bytes);
                        }
                        for (ByteBuffer bytes : avcC.getSequenceParameterSetExts()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)((ByteBuffer)((Buffer)buf).rewind()), (int)len);
                            channel.write((ByteBuffer)((Buffer)buf).rewind());
                            channel.write(bytes);
                        }
                        for (ByteBuffer bytes : avcC.getPictureParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)((ByteBuffer)((Buffer)buf).rewind()), (int)len);
                            channel.write((ByteBuffer)((Buffer)buf).rewind());
                            channel.write(bytes);
                        }
                        orignalSample.writeTo(channel);
                    }

                    @Override
                    public long getSize() {
                        int spsPpsSize = 0;
                        for (ByteBuffer bytes : avcC.getSequenceParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : avcC.getSequenceParameterSetExts()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : avcC.getPictureParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        return orignalSample.getSize() + (long)spsPpsSize;
                    }

                    @Override
                    public ByteBuffer asByteBuffer() {
                        int spsPpsSize = 0;
                        for (ByteBuffer bytes : avcC.getSequenceParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : avcC.getSequenceParameterSetExts()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        for (ByteBuffer bytes : avcC.getPictureParameterSets()) {
                            spsPpsSize += len + bytes.limit();
                        }
                        ByteBuffer data = ByteBuffer.allocate(CastUtils.l2i((long)orignalSample.getSize()) + spsPpsSize);
                        for (ByteBuffer bytes : avcC.getSequenceParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)data, (int)len);
                            data.put(bytes);
                        }
                        for (ByteBuffer bytes : avcC.getSequenceParameterSetExts()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)data, (int)len);
                            data.put(bytes);
                        }
                        for (ByteBuffer bytes : avcC.getPictureParameterSets()) {
                            IsoTypeWriterVariable.write((long)bytes.limit(), (ByteBuffer)data, (int)len);
                            data.put(bytes);
                        }
                        data.put(orignalSample.asByteBuffer());
                        return (ByteBuffer)((Buffer)data).rewind();
                    }
                };
            }
            return orignalSample;
        }

        @Override
        public int size() {
            return this.parentSamples.size();
        }
    }
}

