/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.videos.formats;

import com.github.kiulian.downloader.jackson.JSONObject;
import com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import com.github.kiulian.downloader.model.videos.quality.AudioQuality;

public class VideoWithAudioFormat
extends VideoFormat {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;

    public VideoWithAudioFormat(JSONObject jSONObject, boolean bl, String string) {
        super(jSONObject, bl, string);
        this.audioSampleRate = jSONObject.getIntValue("audioSampleRate");
        this.averageBitrate = jSONObject.getIntValue("averageBitrate");
        AudioQuality audioQuality = null;
        if (jSONObject.containsKey("audioQuality")) {
            String[] stringArray = jSONObject.getString("audioQuality").split("_");
            String string2 = stringArray[stringArray.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio/video";
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

