/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;

public class MoviePostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoviePostProcessExecutor.class);

    public MoviePostProcessExecutor(PostProcess postProcess, List<Movie> movies) {
        super(postProcess, movies);
    }

    @Override
    protected void execute() {
        for (MediaEntity entity : this.entities) {
            if (!(entity instanceof Movie)) continue;
            Movie movie = (Movie)entity;
            LOGGER.info("Executing post process '{}' for movie '{}'", (Object)this.postProcess.getName(), (Object)movie.getTitle());
            String[] command = this.substituteMovieTokens(movie);
            try {
                this.executeCommand(command, movie);
                LOGGER.info("Successfully executed post process '{}' for movie '{}'", (Object)this.postProcess.getName(), (Object)movie.getTitle());
            }
            catch (Exception exception) {}
        }
    }

    protected String[] substituteMovieTokens(Movie movie) {
        Engine engine = MovieRenamer.createEngine();
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        HashMap<String, Movie> root = new HashMap<String, Movie>();
        root.put("movie", movie);
        if (this.postProcess.getPath() == null || this.postProcess.getPath().isEmpty()) {
            String transformed = engine.transform(JmteUtils.morphTemplate(this.postProcess.getCommand(), MovieRenamer.getTokenMap()), root);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(JmteUtils.morphTemplate(splitted[i], MovieRenamer.getTokenMap()), root);
        }
        return splitted;
    }
}

