/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.dvd;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.dvd.DvdAudio;
import org.tinymediamanager.library.dvd.DvdSubtitle;
import org.tinymediamanager.library.dvd.DvdTitle;
import org.tinymediamanager.library.dvd.DvdTitleSet;
import org.tinymediamanager.library.dvd.IfoException;
import org.tinymediamanager.library.dvd.IfoObjectReader;
import org.tinymediamanager.library.dvd.IfoRandomAccessFile;

public class IfoReader {
    private static Logger LOGGER = LoggerFactory.getLogger(IfoReader.class);
    private final List<DvdTitle> titles = new ArrayList<DvdTitle>();
    private int titleSets = -1;

    public IfoReader(Path path) throws IOException {
        this.read(path);
        this.titles.forEach(dvdTitle -> LOGGER.debug("{}", dvdTitle));
    }

    public IfoReader() {
    }

    public List<DvdTitle> getTitles() {
        return this.titles;
    }

    public DvdTitle getTitle(int n) {
        return this.getTitles().get(n);
    }

    private void read(Path path) throws IOException {
        this.titles.clear();
        try {
            LOGGER.debug("Reading IFO from mount {}", (Object)path);
            this.readVmgFile(path, "VIDEO_TS.IFO");
        }
        catch (IOException iOException) {
            LOGGER.warn("Failed to read VIDEO_TS.IFO file: {}", (Object)iOException.getMessage());
            LOGGER.debug("Reading BUP from mount {}", (Object)path);
            this.readVmgFile(path, "VIDEO_TS.BUP");
        }
        LOGGER.debug("Reading VIDEO_TS completed successfully");
    }

    public void readVideoTsIfo(DataInputStream dataInputStream) throws IOException {
        IfoObjectReader ifoObjectReader = new IfoObjectReader(dataInputStream.readAllBytes());
        if (!"DVDVIDEO-VMG".equals(ifoObjectReader.readFixedString(12))) {
            throw new IfoException("No VMG file");
        }
        long l = ifoObjectReader.at(196L).readOffset();
        LOGGER.trace("tt_srpt: {}", (Object)l);
        ifoObjectReader.at(l);
        int n = ifoObjectReader.readu16();
        LOGGER.trace("titlesCount: {}", (Object)n);
        long l2 = ifoObjectReader.skip(2).readu32();
        long l3 = l2 / 12L;
        LOGGER.trace("computedTitles: {}", (Object)l3);
        if (l3 != (long)n) {
            LOGGER.warn("Different number of titles: {} != {}, using the latter one", (Object)n, (Object)l3);
            n = (int)l3;
        }
        for (int i = 0; i < n; ++i) {
            DvdTitle dvdTitle = new DvdTitle();
            dvdTitle.setTitle(i + 1);
            dvdTitle.setAngles(ifoObjectReader.skip(1).readu8());
            dvdTitle.setChapters(ifoObjectReader.readu16());
            dvdTitle.setVtsn(ifoObjectReader.skip(2).readu8());
            dvdTitle.setVts(ifoObjectReader.readu8());
            ifoObjectReader.skip(4);
            this.titles.add(dvdTitle);
            LOGGER.debug("Title {}: vtsn={}, vts={}", new Object[]{dvdTitle.getTitle(), dvdTitle.getVtsn(), dvdTitle.getVts()});
        }
    }

    public void readVtsIfo(DataInputStream dataInputStream, int n) throws IOException {
        IfoObjectReader ifoObjectReader = new IfoObjectReader(dataInputStream.readAllBytes());
        if (!"DVDVIDEO-VTS".equals(ifoObjectReader.readFixedString(12))) {
            throw new IfoException("No VTS file");
        }
        Map<Integer, Long> map = ifoObjectReader.readPgcOffsets();
        DvdTitleSet dvdTitleSet = ifoObjectReader.readTitleSet();
        List list = this.titles.stream().filter(dvdTitle -> dvdTitle.getVtsn() == n).collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            DvdTitle dvdTitle2 = (DvdTitle)list.get(i);
            dvdTitle2.setTitleSet(dvdTitleSet);
            this.readVtsPgc(ifoObjectReader, dvdTitle2, dvdTitleSet, (long)map.get(dvdTitle2.getVts()));
        }
    }

    private void readVmgFile(Path path, String string) throws IOException {
        LOGGER.debug("Reading VMG file {}", (Object)string);
        try (IfoRandomAccessFile ifoRandomAccessFile = new IfoRandomAccessFile(path.toAbsolutePath().toFile(), string);){
            if (!"DVDVIDEO-VMG".equals(ifoRandomAccessFile.readFixedString(12))) {
                throw new IfoException("No VMG file");
            }
            long l = ifoRandomAccessFile.at(196L).readOffset();
            LOGGER.trace("tt_srpt: {}", (Object)l);
            ifoRandomAccessFile.at(l);
            int n = ifoRandomAccessFile.readu16();
            LOGGER.trace("titlesCount: {}", (Object)n);
            long l2 = ifoRandomAccessFile.skip(2).readu32();
            long l3 = l2 / 12L;
            LOGGER.trace("computedTitles: {}", (Object)l3);
            if (l3 != (long)n) {
                LOGGER.warn("Different number of titles: {} != {}, using the latter one", (Object)n, (Object)l3);
                n = (int)l3;
            }
            int n2 = -1;
            ArrayList<DvdTitle> arrayList = new ArrayList<DvdTitle>();
            for (int i = 0; i < n; ++i) {
                DvdTitle dvdTitle = new DvdTitle();
                dvdTitle.setTitle(i + 1);
                dvdTitle.setAngles(ifoRandomAccessFile.skip(1).readu8());
                dvdTitle.setChapters(ifoRandomAccessFile.readu16());
                dvdTitle.setVtsn(ifoRandomAccessFile.skip(2).readu8());
                dvdTitle.setVts(ifoRandomAccessFile.readu8());
                ifoRandomAccessFile.skip(4);
                this.titles.add(dvdTitle);
                LOGGER.debug("Title {}: vtsn={}, vts={}", new Object[]{dvdTitle.getTitle(), dvdTitle.getVtsn(), dvdTitle.getVts()});
                if (dvdTitle.getVtsn() != n2) {
                    if (!arrayList.isEmpty()) {
                        this.completeTitles(path, n2, arrayList);
                    }
                    arrayList.clear();
                    n2 = dvdTitle.getVtsn();
                }
                arrayList.add(dvdTitle);
            }
            if (!arrayList.isEmpty()) {
                this.completeTitles(path, n2, arrayList);
            }
        }
    }

    private void completeTitles(Path path, int n, List<DvdTitle> list) throws IOException {
        try {
            try {
                LOGGER.debug("Reading VTS_{}_0.IFO", (Object)n);
                this.readVtsFile(list, path, String.format("VTS_%02d_0.IFO", n));
            }
            catch (IOException iOException) {
                try {
                    LOGGER.warn("Failed to read VTS IFO file: %s", (Object)iOException.getMessage());
                    LOGGER.debug("Reading VTS_{}_0.BUP", (Object)n);
                    this.readVtsFile(list, path, String.format("VTS_%02d_0.BUP", n));
                }
                catch (EOFException | IfoException iOException2) {
                    LOGGER.warn("VTS file for vtsn {} is invalid: {}", (Object)n, (Object)iOException.getMessage());
                }
            }
            LOGGER.debug("Reading VTS_{}_0 completed successfully...", (Object)n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.warn("Found no VTS file for vtsn {}, ignoring!", (Object)n);
        }
    }

    private void readVtsFile(List<DvdTitle> list, Path path, String string) throws IOException {
        try (IfoRandomAccessFile ifoRandomAccessFile = new IfoRandomAccessFile(path.toAbsolutePath().toFile(), string);){
            if (!"DVDVIDEO-VTS".equals(ifoRandomAccessFile.readFixedString(12))) {
                throw new IfoException("No VTS file");
            }
            Map<Integer, Long> map = ifoRandomAccessFile.readPgcOffsets();
            DvdTitleSet dvdTitleSet = ifoRandomAccessFile.readTitleSet();
            for (int i = 0; i < list.size(); ++i) {
                DvdTitle dvdTitle = list.get(i);
                dvdTitle.setTitleSet(dvdTitleSet);
                this.readVtsPgc(ifoRandomAccessFile, dvdTitle, dvdTitleSet, (long)map.get(dvdTitle.getVts()));
            }
        }
    }

    private void readVtsPgc(IfoRandomAccessFile ifoRandomAccessFile, DvdTitle dvdTitle, DvdTitleSet dvdTitleSet, long l) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        ifoRandomAccessFile.at(l).skip(2);
        int n5 = ifoRandomAccessFile.readu8();
        int n6 = ifoRandomAccessFile.readu8();
        LOGGER.debug("  chapters: {}, cells: {}", (Object)n5, (Object)n6);
        dvdTitle.setTotalTimeMs(ifoRandomAccessFile.readBcdTimeMs());
        ifoRandomAccessFile.skip(4);
        for (n4 = 0; n4 < 8; ++n4) {
            n3 = ifoRandomAccessFile.readu8();
            if ((n3 & 0x80) != 0) {
                DvdAudio dvdAudio = new DvdAudio(dvdTitleSet.getAudioAttributes().get(n4));
                n2 = n3 & 7;
                if (n2 == 0) {
                    n2 = n4;
                }
                dvdAudio.setStreamId(n2 += dvdAudio.getMode().getBaseStreamId());
                dvdTitle.getAudios().add(dvdAudio);
            }
            ifoRandomAccessFile.skip(1);
        }
        for (n4 = 0; n4 < 32; ++n4) {
            n3 = ifoRandomAccessFile.readu8();
            int n7 = ifoRandomAccessFile.readu8();
            n2 = ifoRandomAccessFile.readu8();
            n = ifoRandomAccessFile.readu8();
            if ((n3 & 0x80) == 0) continue;
            n3 &= 0x1F;
            n7 &= 0x1F;
            n2 &= 0x1F;
            n &= 0x1F;
            DvdSubtitle dvdSubtitle = new DvdSubtitle(dvdTitleSet.getSubAttributes().get(n4));
            if (dvdTitleSet.getAspect() == DvdTitleSet.Aspect.ASPECT_16_9) {
                dvdSubtitle.setStreamWideId((n7 > 0 ? n7 : n4) + 32);
            } else {
                dvdSubtitle.setStream43Id((n3 > 0 ? n3 : n4) + 32);
            }
            if (dvdTitleSet.isLetterboxEnabled()) {
                dvdSubtitle.setStreamLetterboxId((n2 > 0 ? n2 : n4) + 32);
            }
            if (dvdTitleSet.isPanScanEnabled()) {
                dvdSubtitle.setStreamPanScanId((n > 0 ? n : n4) + 32);
            }
            dvdTitle.getSubs().add(dvdSubtitle);
        }
        ifoRandomAccessFile.skip(8);
        for (n4 = 0; n4 < 16; ++n4) {
            dvdTitle.getColors()[n4] = (int)ifoRandomAccessFile.readu32();
        }
        ifoRandomAccessFile.skip(2);
        n4 = ifoRandomAccessFile.readu16();
        n3 = ifoRandomAccessFile.readu16();
        int[] nArray = new int[n5];
        ifoRandomAccessFile.at(l + (long)n4);
        for (n2 = 0; n2 < n5; ++n2) {
            nArray[n2] = ifoRandomAccessFile.readu8();
        }
        for (n2 = 0; n2 < n5; ++n2) {
            int n8 = n2 + 1 < n5 ? nArray[n2 + 1] : n6;
            long l2 = 0L;
            for (n = nArray[n2]; n < n8; ++n) {
                ifoRandomAccessFile.at(l + (long)n3 + (long)((n - 1) * 24) + 4L);
                l2 += ifoRandomAccessFile.readBcdTimeMs();
            }
            if (l2 <= 0L && n8 == n6) continue;
            dvdTitle.getChapterTimeMs().add(l2);
        }
    }

    private void readVtsPgc(IfoObjectReader ifoObjectReader, DvdTitle dvdTitle, DvdTitleSet dvdTitleSet, long l) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        ifoObjectReader.at(l).skip(2);
        int n5 = ifoObjectReader.readu8();
        int n6 = ifoObjectReader.readu8();
        LOGGER.debug("  chapters: {}, cells: {}", (Object)n5, (Object)n6);
        dvdTitle.setTotalTimeMs(ifoObjectReader.readBcdTimeMs());
        ifoObjectReader.skip(4);
        for (n4 = 0; n4 < 8; ++n4) {
            n3 = ifoObjectReader.readu8();
            if ((n3 & 0x80) != 0) {
                DvdAudio dvdAudio = new DvdAudio(dvdTitleSet.getAudioAttributes().get(n4));
                n2 = n3 & 7;
                if (n2 == 0) {
                    n2 = n4;
                }
                dvdAudio.setStreamId(n2 += dvdAudio.getMode().getBaseStreamId());
                dvdTitle.getAudios().add(dvdAudio);
            }
            ifoObjectReader.skip(1);
        }
        for (n4 = 0; n4 < 32; ++n4) {
            n3 = ifoObjectReader.readu8();
            int n7 = ifoObjectReader.readu8();
            n2 = ifoObjectReader.readu8();
            n = ifoObjectReader.readu8();
            if ((n3 & 0x80) == 0) continue;
            n3 &= 0x1F;
            n7 &= 0x1F;
            n2 &= 0x1F;
            n &= 0x1F;
            DvdSubtitle dvdSubtitle = new DvdSubtitle(dvdTitleSet.getSubAttributes().get(n4));
            if (dvdTitleSet.getAspect() == DvdTitleSet.Aspect.ASPECT_16_9) {
                dvdSubtitle.setStreamWideId((n7 > 0 ? n7 : n4) + 32);
            } else {
                dvdSubtitle.setStream43Id((n3 > 0 ? n3 : n4) + 32);
            }
            if (dvdTitleSet.isLetterboxEnabled()) {
                dvdSubtitle.setStreamLetterboxId((n2 > 0 ? n2 : n4) + 32);
            }
            if (dvdTitleSet.isPanScanEnabled()) {
                dvdSubtitle.setStreamPanScanId((n > 0 ? n : n4) + 32);
            }
            dvdTitle.getSubs().add(dvdSubtitle);
        }
        ifoObjectReader.skip(8);
        for (n4 = 0; n4 < 16; ++n4) {
            dvdTitle.getColors()[n4] = (int)ifoObjectReader.readu32();
        }
        ifoObjectReader.skip(2);
        n4 = ifoObjectReader.readu16();
        n3 = ifoObjectReader.readu16();
        int[] nArray = new int[n5];
        ifoObjectReader.at(l + (long)n4);
        for (n2 = 0; n2 < n5; ++n2) {
            nArray[n2] = ifoObjectReader.readu8();
        }
        for (n2 = 0; n2 < n5; ++n2) {
            int n8 = n2 + 1 < n5 ? nArray[n2 + 1] : n6;
            long l2 = 0L;
            for (n = nArray[n2]; n < n8; ++n) {
                ifoObjectReader.at(l + (long)n3 + (long)((n - 1) * 24) + 4L);
                l2 += ifoObjectReader.readBcdTimeMs();
            }
            if (l2 <= 0L && n8 == n6) continue;
            dvdTitle.getChapterTimeMs().add(l2);
        }
    }
}

