/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

public class ProcessInfo {
    private static final Runtime runtime = Runtime.getRuntime();
    private final long pid;
    private final long parentPid;
    private final String owner;

    public ProcessInfo() {
        ProcessHandle process = ProcessHandle.current();
        this.pid = process.pid();
        this.parentPid = process.parent().map(ProcessHandle::pid).orElse(-1L);
        this.owner = process.info().user().orElse(null);
    }

    public int getCpus() {
        return runtime.availableProcessors();
    }

    public long getPid() {
        return this.pid;
    }

    public long getParentPid() {
        return this.parentPid;
    }

    public String getOwner() {
        return this.owner;
    }
}

