/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.tomcat;

import ch.qos.logback.access.common.spi.ServerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class TomcatServerAdapter
implements ServerAdapter {
    Request request;
    Response response;

    public TomcatServerAdapter(Request tomcatRequest, Response tomcatResponse) {
        this.request = tomcatRequest;
        this.response = tomcatResponse;
    }

    public long getContentLength() {
        return this.response.getContentLength();
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public long getRequestTimestamp() {
        return this.request.getCoyoteRequest().getStartTime();
    }

    public Map<String, String> buildResponseHeaderMap() {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        for (String key : this.response.getHeaderNames()) {
            String value = this.response.getHeader(key);
            responseHeaderMap.put(key, value);
        }
        return responseHeaderMap;
    }
}

