/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.ospf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.class.F;
import com.ubnt.model.api.ospf.ImmutableOspfInterfaceDto;
import com.ubnt.model.api.ospf.OspfAuthenticationType;
import com.ubnt.model.api.ospf.OspfMd5AuthKeyDto;
import com.ubnt.service.ospf.OspfInterfaceDocumentPart;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Schema(name="OSPF Interface")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableOspfInterfaceDto.class)
@Value.Immutable
@F
public interface OspfInterfaceDto {
    @JsonProperty(value="network_id")
    @NotEmpty
    public String networkId();

    @JsonProperty(value="cost")
    @Min(value=1L)
    @Max(value=65535L)
    public @Min(value=1L) @Max(value=65535L) int cost();

    @JsonProperty(value="authentication_type")
    @NotNull
    public OspfAuthenticationType authenticationType();

    @JsonProperty(value="plain_text_authentication_key")
    public Optional<String> plainTextAuthenticationKey();

    @JsonProperty(value="md5_authentication_keys")
    public Optional<List<OspfMd5AuthKeyDto>> md5AuthenticationKeys();

    @JsonProperty(value="passive_interface")
    public boolean passiveInterface();

    @JsonProperty(value="priority")
    @Min(value=1L)
    public @Min(value=1L) int priority();

    @JsonProperty(value="hello_interval")
    public Optional<@Min(value=1L) @Max(value=65535L) Integer> helloInterval();

    @JsonProperty(value="dead_interval")
    public Optional<@Min(value=1L) @Max(value=65535L) Integer> deadInterval();

    default public OspfInterfaceDocumentPart toDocument() {
        return OspfInterfaceDocumentPart.builder().OO0000(this.networkId()).\u00d500000(this.cost()).return(this.priority()).new(this.authenticationType()).\u00d400000(this.plainTextAuthenticationKey().orElse(null)).if(this.md5AuthenticationKeys().map(list -> list.stream().map(OspfMd5AuthKeyDto::toDocument).toList()).orElse(List.of())).\u00f800000(this.passiveInterface()).return(this.priority()).\u00f500000(this.helloInterval().orElse(null)).o00000(this.deadInterval().orElse(null)).oO0000();
    }

    public static ImmutableOspfInterfaceDto.Builder builder() {
        return ImmutableOspfInterfaceDto.builder();
    }

    public static OspfInterfaceDto ofDocument(OspfInterfaceDocumentPart ospfInterfaceDocumentPart) {
        OspfAuthenticationType ospfAuthenticationType = ospfInterfaceDocumentPart.getAuthenticationType();
        return OspfInterfaceDto.builder().networkId(ospfInterfaceDocumentPart.getNetworkId()).cost(Optional.ofNullable(ospfInterfaceDocumentPart.getCost()).orElse(1)).priority(ospfInterfaceDocumentPart.optionalPriority().orElse(1)).authenticationType(ospfAuthenticationType).plainTextAuthenticationKey(ospfAuthenticationType == OspfAuthenticationType.PLAIN_TEXT ? Optional.ofNullable(ospfInterfaceDocumentPart.getPlainTextAuthenticationKey()) : Optional.empty()).md5AuthenticationKeys(ospfAuthenticationType == OspfAuthenticationType.MD5 ? Optional.of(ospfInterfaceDocumentPart.getMd5AuthenticationKeys().stream().map(OspfMd5AuthKeyDto::ofDocument).toList()) : Optional.empty()).passiveInterface(ospfInterfaceDocumentPart.isPassiveInterface()).priority(ospfInterfaceDocumentPart.getPriority()).helloInterval(ospfInterfaceDocumentPart.getHelloInterval()).deadInterval(ospfInterfaceDocumentPart.getDeadInterval()).build();
    }
}

