/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.radius;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.ace.P;
import com.ubnt.class.F;
import com.ubnt.data.RadiusProfile;
import com.ubnt.model.api.radius.ImmutableRadiusProfileDto;
import com.ubnt.model.api.radius.RadiusServerDto;
import com.ubnt.model.api.radius.VlanWlanMode;
import com.ubnt.service.config.OO0O;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableRadiusProfileDto.class)
@JsonDeserialize(builder=ImmutableRadiusProfileDto.Builder.class)
@Value.Immutable
@F
public abstract class RadiusProfileDto
implements OO0O {
    @JsonProperty(value="_id")
    @Nullable
    public abstract String id();

    @JsonProperty(value="attr_hidden_id")
    public abstract Optional<String> hiddenId();

    @JsonIgnore
    public abstract String siteId();

    @JsonProperty(value="attr_no_delete")
    public abstract boolean nonDeletable();

    @JsonProperty(value="attr_no_edit")
    public abstract boolean nonEditable();

    @JsonProperty(value="name")
    @NotEmpty
    public abstract String name();

    @JsonProperty(value="vlan_enabled")
    public abstract boolean vlanEnabled();

    @JsonProperty(value="vlan_wlan_mode")
    public abstract Optional<VlanWlanMode> vlanWlanMode();

    @JsonProperty(value="auth_servers")
    @NotEmpty
    @Valid
    public abstract List<RadiusServerDto> authenticationServers();

    @JsonProperty(value="accounting_enabled")
    public abstract boolean accountingEnabled();

    @JsonProperty(value="acct_servers")
    @Valid
    public abstract List<RadiusServerDto> accountingServers();

    @JsonProperty(value="interim_update_enabled")
    public abstract boolean interimUpdateEnabled();

    @JsonProperty(value="interim_update_interval")
    public abstract Optional<@Min(value=1L) Integer> interimUpdateInterval();

    public RadiusProfile toLegacy(String string) {
        return new RadiusProfile().setIdIfPresent(this.id()).setSiteId(string).setHiddenId(this.hiddenId().orElse(null)).setName(this.name()).setNonDeletable(this.nonDeletable()).setNonEditable(this.nonEditable()).setVlanEnabled(this.vlanEnabled()).setVlanWlanMode(this.vlanWlanMode().map(VlanWlanMode::toString).orElse(null)).setInterimUpdateEnabled(this.interimUpdateEnabled()).setInterimUpdateInterval(this.interimUpdateInterval().orElse(null)).setAuthenticationServers(this.authenticationServers().stream().map(RadiusServerDto::toLegacy).collect(Collectors.toList())).setAccountingEnabled(this.accountingEnabled()).setAccountingServers(this.accountingServers().stream().map(RadiusServerDto::toLegacy).collect(Collectors.toList()));
    }

    public static RadiusProfileDto fromLegacy(RadiusProfile radiusProfile) {
        List list = radiusProfile.getAuthenticationServers().stream().map(RadiusServerDto::fromX).collect(Collectors.toList());
        List list2 = radiusProfile.getAccountingServers().stream().map(RadiusServerDto::fromX).collect(Collectors.toList());
        return RadiusProfileDto.builder().id(radiusProfile.getId()).hiddenId(radiusProfile.getHiddenId()).nonDeletable(radiusProfile.isNonDeletable()).nonEditable(radiusProfile.isNonEditable()).siteId(radiusProfile.getSiteId()).name(radiusProfile.getName()).vlanEnabled(radiusProfile.isVlanEnabled()).vlanWlanMode(P.\u00d500000(VlanWlanMode.class, radiusProfile.getVlanWlanMode())).authenticationServers(list).accountingEnabled(radiusProfile.isAccountingEnabled()).accountingServers(list2).interimUpdateEnabled(radiusProfile.isInterimUpdateEnabled()).interimUpdateInterval(radiusProfile.getInterimUpdateInterval()).build();
    }

    public static ImmutableRadiusProfileDto.Builder builder() {
        return ImmutableRadiusProfileDto.builder();
    }
}

