/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.radius;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.class.F;
import com.ubnt.data.X;
import com.ubnt.model.api.radius.ImmutableRadiusServerDto;
import com.ubnt.net.v2.config.security.View;
import com.ubnt.net.v2.validation.constraints.Ip;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableRadiusServerDto.class)
@JsonDeserialize(builder=ImmutableRadiusServerDto.Builder.class)
@Value.Immutable
@F
public abstract class RadiusServerDto {
    @JsonProperty(value="ip")
    @NotEmpty
    @Ip
    public abstract String ip();

    @JsonProperty(value="port")
    @Min(value=1L)
    @Max(value=65535L)
    public abstract @Min(value=1L) @Max(value=65535L) int port();

    @JsonProperty(value="x_secret")
    @JsonView(value={View.SiteAdmin.class})
    @NotEmpty
    public abstract String secret();

    public static RadiusServerDto fromX(X x2) {
        return RadiusServerDto.builder().ip(x2.getString("ip")).port(x2.getInt("port")).secret(x2.getString("x_secret")).build();
    }

    public X toLegacy() {
        return new X().append("ip", this.ip()).append("port", this.port()).append("x_secret", this.secret());
    }

    public static ImmutableRadiusServerDto.Builder builder() {
        return ImmutableRadiusServerDto.builder();
    }
}

