/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.setting.netflow;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.class.F;
import com.ubnt.data.Setting;
import com.ubnt.model.api.setting.netflow.ImmutableNetflowSettingDto;
import org.immutables.value.Value;

@Value.Immutable
@F
public interface NetflowSettingDto {
    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="port")
    public int port();

    @JsonProperty(value="version")
    public int version();

    @JsonProperty(value="auto_engine_id_enabled")
    public boolean autoEngineIdEnabled();

    @JsonProperty(value="export_frequency")
    public int exportFrequency();

    @JsonProperty(value="refresh_rate")
    public int refreshRate();

    @JsonProperty(value="sampling_mode")
    public String samplingMode();

    @JsonProperty(value="sampling_rate")
    public int samplingRate();

    public static ImmutableNetflowSettingDto.Builder builder() {
        return ImmutableNetflowSettingDto.builder();
    }

    public static NetflowSettingDto of(Setting setting) {
        return ImmutableNetflowSettingDto.builder().enabled(setting.is("enabled", false)).port(setting.getInt("port")).version(setting.getInt("version")).autoEngineIdEnabled(setting.getBoolean("auto_engine_id_enabled")).exportFrequency(setting.getInt("export_frequency")).refreshRate(setting.getInt("refresh_rate")).samplingMode(setting.getString("sampling_mode", "hash")).samplingRate(setting.getInt("sampling_rate", 512)).build();
    }
}

