/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.staticdns;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.class.F;
import com.ubnt.model.api.staticdns.ImmutableStaticDnsDto;
import com.ubnt.service.staticdns.StaticDnsDocument;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import javax.annotation.Nullable;
import org.hibernate.validator.constraints.Length;
import org.immutables.value.Value;

@Schema(name="Static DNS")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableStaticDnsDto.class)
@Value.Immutable
@F
public interface StaticDnsDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="record_type")
    public StaticDnsDocument._Oo recordType();

    @JsonProperty(value="key")
    @NotEmpty
    @Length(min=1, max=127)
    public @NotEmpty @Length(min=1, max=127) String key();

    @JsonProperty(value="value")
    @NotEmpty
    @Length(min=1, max=1024)
    public @NotEmpty @Length(min=1, max=1024) String value();

    @JsonProperty(value="priority")
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int priority();

    @JsonProperty(value="ttl")
    @Min(value=0L)
    @Max(value=604800L)
    public @Min(value=0L) @Max(value=604800L) int ttl();

    @JsonProperty(value="weight")
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int weight();

    @JsonProperty(value="port")
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int port();

    public static ImmutableStaticDnsDto.Builder builder() {
        return ImmutableStaticDnsDto.builder();
    }

    public static StaticDnsDto ofDocument(StaticDnsDocument staticDnsDocument) {
        return StaticDnsDto.builder().id(staticDnsDocument.getId()).enabled(staticDnsDocument.isEnabled()).recordType(staticDnsDocument.getRecordType()).key(staticDnsDocument.getKey()).value(staticDnsDocument.getValue()).priority(staticDnsDocument.getPriority()).ttl(staticDnsDocument.getTtl()).weight(staticDnsDocument.getWeight()).port(staticDnsDocument.getPort()).build();
    }

    default public StaticDnsDocument toDocument(String string) {
        return StaticDnsDocument.builder().\u00d600000(string).\u00d500000(this.id()).void(this.enabled()).\u00d200000(this.recordType()).float(this.key()).\u00f400000(this.value()).\u00f500000(this.priority()).o00000(this.ttl()).Object(this.weight()).\u00f600000(this.port()).\u00d400000();
    }

    default public StaticDnsDocument toDocument(String string, String string2) {
        return StaticDnsDocument.builder().\u00d600000(string2).\u00d500000(string).void(this.enabled()).\u00d200000(this.recordType()).float(this.key()).\u00f400000(this.value()).\u00f500000(this.priority()).o00000(this.ttl()).Object(this.weight()).\u00f600000(this.port()).\u00d400000();
    }
}

