/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.traffic;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.class.F;
import com.ubnt.model.api.traffic.ImmutableTrafficTargetDeviceDto;
import com.ubnt.model.api.traffic.TrafficDeviceTargetType;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.traffic.TrafficTargetDeviceDocumentPart;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableTrafficTargetDeviceDto.class)
@JsonDeserialize(builder=ImmutableTrafficTargetDeviceDto.Builder.class)
@Value.Immutable
@F
public interface TrafficTargetDeviceDto {
    @JsonProperty(value="type")
    @NotNull
    public TrafficDeviceTargetType type();

    @JsonProperty(value="client_mac")
    public Optional<@MacAddress String> clientMac();

    @JsonProperty(value="network_id")
    public Optional<String> networkId();

    default public TrafficTargetDeviceDocumentPart toDocument() {
        return TrafficTargetDeviceDocumentPart.builder().\u00d300000(this.type()).\u00d200000(this.clientMac().orElse(null)).super(this.networkId().orElse(null)).\u00d400000();
    }

    public static ImmutableTrafficTargetDeviceDto.Builder builder() {
        return ImmutableTrafficTargetDeviceDto.builder();
    }

    public static TrafficTargetDeviceDto fromDocument(TrafficTargetDeviceDocumentPart trafficTargetDeviceDocumentPart) {
        return TrafficTargetDeviceDto.builder().type(trafficTargetDeviceDocumentPart.getType()).clientMac(trafficTargetDeviceDocumentPart.getClientMac()).networkId(trafficTargetDeviceDocumentPart.getNetworkId()).build();
    }
}

