/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.firewall;

import com.ubnt.data.Site;
import com.ubnt.model.api.firewall.CombinedTrafficFirewallRuleDto;
import com.ubnt.model.api.firewall.CombinedTrafficFirewallRuleOriginType;
import com.ubnt.model.api.firewall.FirewallRuleDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.firewall.thissuper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="Firewall Rules")
public class FirewallRuleController {
    private final thissuper o00000;

    public FirewallRuleController(thissuper thissuper2) {
        this.o00000 = thissuper2;
    }

    @Operation(summary="Get default Firewall Rule settings", description="Since 6.6.41")
    @GetMapping(value={"/api/site/{siteName}/firewall-rules/defaults"})
    public List<FirewallRuleDto> getDefaults(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d3\u00f5\u00d6000().stream().map(FirewallRuleDto::fromLegacy).collect(Collectors.toList());
    }

    @Operation(summary="Get combined traffic and firewall rules", description="Since 8.1.86")
    @GetMapping(value={"/api/site/{siteName}/firewall-rules/combined-traffic-firewall-rules"})
    public List<CombinedTrafficFirewallRuleDto> getCombinedTrafficFirewallRules(@PathVariable(value="siteName") Site site, @RequestParam(value="originType", required=false) CombinedTrafficFirewallRuleOriginType combinedTrafficFirewallRuleOriginType) {
        return this.o00000.\u00d5\u00f4\u00d6000(site, Optional.ofNullable(combinedTrafficFirewallRuleOriginType).orElse(CombinedTrafficFirewallRuleOriginType.ALL));
    }

    @PostMapping(value={"/api/site/{siteName}/firewall-rules/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Batch remove Firewall rules")
    public void batchDeleteFirewallRules(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        this.o00000.o\u00f6\u00d6000(site.getId(), list);
    }
}

