/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.microsegmentation;

import com.ubnt.data.Site;
import com.ubnt.model.api.microsegmentation.ImmutableMicroSegmentGroupDto;
import com.ubnt.model.api.microsegmentation.ImmutableMicroSegmentMemberDto;
import com.ubnt.model.api.microsegmentation.MicroSegmentGroupDto;
import com.ubnt.model.api.microsegmentation.MicroSegmentMemberDto;
import com.ubnt.model.api.microsegmentation.MicroSegmentMemberType;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.exception.MicroSegmentGroupNotFound;
import com.ubnt.net.v2.exception.RequestValidationException;
import com.ubnt.service.microsegmentation.MicroSegmentGroupDocument;
import com.ubnt.service.microsegmentation.MicroSegmentMemberDocument;
import com.ubnt.service.microsegmentation.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.service.system.kA;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Validated
@V2RestController
@Tag(name="MicroSegmentation")
public class MicroSegmentationController {
    private static final Logger o00000 = kA.\u00f4o0000;
    private final oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO \u00d200000;

    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create a new microsegment")
    @PostMapping(value={"/api/site/{siteName}/micro-segment-group"}, consumes={"application/json"})
    public MicroSegmentGroupDto createMicroSegmentGroup(@PathVariable(value="siteName") Site site, @RequestBody @Valid MicroSegmentGroupDto microSegmentGroupDto) {
        MicroSegmentGroupDocument microSegmentGroupDocument = this.\u00d200000.\u00d400000(this.\u00d400000(site.getId(), microSegmentGroupDto));
        return this.\u00d300000(microSegmentGroupDocument);
    }

    @Operation(summary="Update the existing microsegment")
    @PutMapping(value={"/api/site/{siteName}/micro-segment-group/{id}"}, consumes={"application/json"})
    public MicroSegmentGroupDto updateMicroSegmentGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid MicroSegmentGroupDto microSegmentGroupDto) {
        if (!Objects.equals(microSegmentGroupDto.id(), string)) {
            throw new RequestValidationException("Unexpected 'id' field");
        }
        MicroSegmentGroupDocument microSegmentGroupDocument = this.\u00d200000.\u00d300000(this.\u00d400000(site.getId(), microSegmentGroupDto));
        return this.\u00d300000(microSegmentGroupDocument);
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete the microsegment")
    @DeleteMapping(value={"/api/site/{siteName}/micro-segment-group/{id}"})
    public void deleteMicroSegmentGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        MicroSegmentGroupDocument microSegmentGroupDocument = this.\u00d200000.return(site.getId(), string).orElseThrow(() -> new MicroSegmentGroupNotFound(string));
        this.\u00d200000.\u00d500000(microSegmentGroupDocument);
    }

    @Operation(summary="Get all micro segment groups")
    @GetMapping(value={"/api/site/{siteName}/micro-segment-groups"})
    public List<MicroSegmentGroupDto> getMicroSegmentGroups(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.o00000(site.getId()).stream().map(this::\u00d300000).toList();
    }

    @Operation(summary="Get a microsegment by the id")
    @GetMapping(value={"/api/site/{siteName}/micro-segment-group/{id}"})
    public MicroSegmentGroupDto getMicroSegmentGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return this.\u00d200000.return(site.getId(), string).map(this::\u00d300000).orElseThrow(() -> new MicroSegmentGroupNotFound(string));
    }

    private MicroSegmentGroupDocument \u00d400000(String string, MicroSegmentGroupDto microSegmentGroupDto) {
        List<MicroSegmentMemberDocument> list = microSegmentGroupDto.members().stream().map(this::super).toList();
        return MicroSegmentGroupDocument.builder().\u00d200000(microSegmentGroupDto.id()).super(string).\u00d400000(microSegmentGroupDto.name()).\u00d300000(list).class(Boolean.TRUE.equals(microSegmentGroupDto.blockInternet())).\u00d600000();
    }

    private MicroSegmentGroupDto \u00d300000(MicroSegmentGroupDocument microSegmentGroupDocument) {
        List<MicroSegmentMemberDto> list = microSegmentGroupDocument.members().stream().map(this::\u00d200000).filter(Objects::nonNull).toList();
        return ImmutableMicroSegmentGroupDto.builder().id(microSegmentGroupDocument.id()).name(microSegmentGroupDocument.name()).members(list).blockInternet(microSegmentGroupDocument.blockInternet()).build();
    }

    private MicroSegmentMemberDocument super(MicroSegmentMemberDto microSegmentMemberDto) {
        return MicroSegmentMemberDocument.builder().o00000(microSegmentMemberDto.type()).Object(microSegmentMemberDto.id()).\u00d200000();
    }

    private MicroSegmentMemberDto \u00d200000(MicroSegmentMemberDocument microSegmentMemberDocument) {
        MicroSegmentMemberType microSegmentMemberType = microSegmentMemberDocument.type();
        if (microSegmentMemberType == null) {
            o00000.warn("Found micro-segment member:{} with unknown type id:{}", (Object)microSegmentMemberDocument.id(), (Object)microSegmentMemberDocument.type());
            return null;
        }
        return ImmutableMicroSegmentMemberDto.builder().id(microSegmentMemberDocument.id()).type(microSegmentMemberType).build();
    }

    @ConstructorProperties(value={"microSegmentationService"})
    @Generated
    public MicroSegmentationController(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2) {
        this.\u00d200000 = oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2;
    }
}

