/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.radius;

import com.ubnt.data.Site;
import com.ubnt.model.api.radius.RadiusProfileDto;
import com.ubnt.model.api.radius.RadiusUserDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.service.radius.new;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="RADIUS")
public class RadiusController {
    private final new o00000;

    public RadiusController(new new_) {
        this.o00000 = new_;
    }

    @GetMapping(value={"/api/site/{siteName}/radius/users"})
    @AllowUCoreLocal
    @Operation(summary="List RADIUS users")
    public List<RadiusUserDto> listRadiusUsers(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d2O0000(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/radius/users/batch_add"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Batch add RADIUS users")
    public List<RadiusUserDto> batchAddUsers(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<RadiusUserDto> list) {
        return this.o00000.\u00d500000(site.getId(), list);
    }

    @PostMapping(value={"/api/site/{siteName}/radius/users/batch_update"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Batch update RADIUS users")
    public List<RadiusUserDto> batchUpdateUsers(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<RadiusUserDto> list) {
        return this.o00000.OO0000(site.getId(), list);
    }

    @PostMapping(value={"/api/site/{siteName}/radius/users/batch_delete"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Batch remove RADIUS users")
    public void batchDeleteUsers(@PathVariable(value="siteName") Site site, @RequestBody List<String> list) {
        this.o00000.o00000(site.getId(), list);
    }

    @GetMapping(value={"/api/site/{siteName}/radius/profiles"})
    @AllowUCoreLocal
    @Operation(summary="List RADIUS profiles")
    public List<RadiusProfileDto> listRadiusProfiles(@PathVariable(value="siteName") Site site) {
        return this.o00000.void(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/radius/profiles"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create RADIUS profile")
    public RadiusProfileDto createRadiusProfile(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull RadiusProfileDto radiusProfileDto) {
        return this.o00000.\u00d400000(site.getId(), radiusProfileDto);
    }

    @PutMapping(value={"/api/site/{siteName}/radius/profiles/{profileId}"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update RADIUS profile")
    public RadiusProfileDto updateRadiusProfile(@PathVariable(value="siteName") Site site, @PathVariable(value="profileId") String string, @RequestBody @Valid @NotNull RadiusProfileDto radiusProfileDto) {
        return this.o00000.\u00f600000(site.getId(), string, radiusProfileDto);
    }

    @DeleteMapping(value={"/api/site/{siteName}/radius/profiles/{profileId}"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete RADIUS profile")
    public void deleteRadiusProfile(@PathVariable(value="siteName") Site site, @PathVariable(value="profileId") String string) {
        this.o00000.Object(site.getId(), string);
    }
}

