/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.switchacl;

import com.ubnt.data.Device;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.switchacl.AclEntryCount;
import com.ubnt.model.api.switchacl.AclRuleDto;
import com.ubnt.model.api.switchacl.BatchAclRuleUpdatePartDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.devmgr.supervoid;
import com.ubnt.service.setting.N.OoOO;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.M;
import com.ubnt.service.switchacl.Object;
import com.ubnt.service.switchacl.oOOo;
import com.ubnt.service.system.setting.H;
import com.ubnt.service.system.setting.oO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Switch ACL Rules")
public class AclRuleController {
    private final M super;
    private final oOOo \u00d200000;
    private final supervoid class;
    private final OoOO \u00d300000;
    private final oO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO \u00d400000;

    public AclRuleController(M m2, oOOo oOOo2, supervoid supervoid2, OoOO ooOO2, oO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO oO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2) {
        this.super = m2;
        this.\u00d200000 = oOOo2;
        this.class = supervoid2;
        this.\u00d300000 = ooOO2;
        this.\u00d400000 = oO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2;
    }

    @GetMapping(value={"/api/site/{siteName}/{mac}/acl-entry-count"})
    @Operation(summary="ACL Entry Count")
    public AclEntryCount getAclEntryCount(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        if (!this.class.\u00f5\u00d4OO00(string2, string, Device::supportsSwitchAccessControlList)) {
            return AclEntryCount.empty();
        }
        Setting setting = this.\u00d400000.\u00d300000(H.\u00f6O0000, string2);
        int n2 = this.\u00d300000.Object(string2, setting);
        int n3 = this.\u00d200000.class(string2, string);
        return AclEntryCount.builder().globalAclEntryCount(n2).customIpAclEntryCount(n3).customMacAclEntryCount(0).build();
    }

    @GetMapping(value={"/api/site/{siteName}/acl-rules"})
    @Operation(summary="List ACL Rules")
    public List<AclRuleDto> listAclRules(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d500000(site.getId()).stream().map(AclRuleDto::fromDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Create a new ACL Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public AclRuleDto createAclRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDocument aclRuleDocument = this.super.void(aclRuleDto.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"}, consumes={"application/json"})
    @Operation(summary="Update ACL Rule")
    public AclRuleDto updateAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDto aclRuleDto2 = AclRuleDto.withId(aclRuleDto, string);
        AclRuleDocument aclRuleDocument = this.super.o00000(aclRuleDto2.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Update Selected Properties of ACL Rules in Batch")
    public List<AclRuleDto> batchUpdateAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<BatchAclRuleUpdatePartDto> list) {
        List<Object> list2 = list.stream().map(BatchAclRuleUpdatePartDto::toBatchUpdatePart).toList();
        return this.super.\u00d600000(site.getId(), list2).stream().map(AclRuleDto::fromDocument).toList();
    }

    @DeleteMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"})
    @Operation(summary="Delete ACL Rule")
    public void deleteAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.super.\u00d400000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules/batch-delete"}, consumes={"application/json"})
    @Operation(summary="Delete ACL Rules in Batch")
    public void deleteAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<String> list) {
        this.super.Object(site.getId(), list);
    }
}

