/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trafficflow.mq.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.ubnt.net.Dto;
import com.ubnt.service.systemlog.trigger.Y;
import com.ubnt.service.trafficflow.V;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;

public enum TrafficFlowMessageType implements Dto
{
    AD_BLOCKING("dnsAdBlock"),
    DNS_BLOCK("dnsBlock"),
    CONTENT_FILTERING_BLOCK("contentFilteringBlock"),
    FLOW_POLICY("FLOW_POLICY"),
    FIREWALL_POLICY("FIREWALL_POLICY"),
    GEO_POLICY("GEO_POLICY"),
    HONEYPOT("HoneypotEvent"),
    IPS("SuricataEvent"),
    SIMPLE_APP_BLOCK("SIMPLE_APP_BLOCK"),
    FIREWALL_RULE("FIREWALL_RULE"),
    TRAFFIC_RULE("TRAFFIC_RULE"),
    TRAFFIC_ROUTE("TRAFFIC_ROUTE"),
    UNKNOWN("");

    private final String firmwareValue;

    public V toTrafficFlowType(boolean bl) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AD_BLOCKING -> {
                if (bl) {
                    yield V.\u00d30O000;
                }
                yield V.returnvoid;
            }
            case DNS_BLOCK -> V.\u00d80O000;
            case CONTENT_FILTERING_BLOCK -> V.\u00f5\u00f80000;
            case GEO_POLICY -> V.\u00d5\u00f60000;
            case HONEYPOT -> V.\u00d50O000;
            case FIREWALL_POLICY -> V.\u00d8\u00f80000;
            case FIREWALL_RULE -> V.\u00d6\u00f80000;
            case SIMPLE_APP_BLOCK -> V.\u00f8\u00f50000;
            case TRAFFIC_RULE -> V.\u00f6\u00f80000;
            case TRAFFIC_ROUTE -> V.\u00d3\u00f80000;
            case FLOW_POLICY -> V.\u00d3\u00f60000;
            case IPS -> V.ifvoid;
            case UNKNOWN -> V.\u00d60O000;
        };
    }

    public Optional<Y> toTriggerType() {
        return Optional.ofNullable(switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FIREWALL_POLICY -> Y.\u00d200000;
            case FIREWALL_RULE -> Y.o00000;
            case SIMPLE_APP_BLOCK -> Y.\u00d400000;
            case TRAFFIC_RULE -> Y.\u00f500000;
            case TRAFFIC_ROUTE -> Y.\u00f400000;
            case AD_BLOCKING, DNS_BLOCK, CONTENT_FILTERING_BLOCK, GEO_POLICY, HONEYPOT, FLOW_POLICY, IPS, UNKNOWN -> null;
        });
    }

    public boolean isTriggerType() {
        return this.toTriggerType().isPresent();
    }

    public boolean isFirewallMessage() {
        return this == FIREWALL_POLICY || this == TRAFFIC_RULE || this == FIREWALL_RULE || this == SIMPLE_APP_BLOCK;
    }

    @JsonCreator
    public static TrafficFlowMessageType fromFirmwareValue(String string) {
        for (TrafficFlowMessageType trafficFlowMessageType : TrafficFlowMessageType.values()) {
            if (!trafficFlowMessageType.firmwareValue.equals(string)) continue;
            return trafficFlowMessageType;
        }
        return UNKNOWN;
    }

    @ConstructorProperties(value={"firmwareValue"})
    @Generated
    private TrafficFlowMessageType(String string2) {
        this.firmwareValue = string2;
    }

    static class _o {
        static final String \u00d300000 = "HoneypotEvent";
        static final String \u00d200000 = "SuricataEvent";
        static final String o00000 = "contentFilteringBlock";

        private _o() {
        }
    }
}

