/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.InteractiveFormFieldFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class InteractiveFormFieldFeaturesObject
extends FeaturesObject {
    private static final String INTERACTIVE_FORM_FIELD = "interactiveFormField";
    private static final String NAME = "fullyQualifiedName";
    private static final String VALUE = "value";
    private static final String CHILDREN = "children";

    public InteractiveFormFieldFeaturesObject(InteractiveFormFieldFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.INTERACTIVE_FORM_FIELDS;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        InteractiveFormFieldFeaturesObjectAdapter formFieldAdapter = (InteractiveFormFieldFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(INTERACTIVE_FORM_FIELD);
        this.createItem(root, formFieldAdapter);
        return root;
    }

    private void createItem(FeatureTreeNode root, InteractiveFormFieldFeaturesObjectAdapter formFieldAdapter) throws FeatureParsingException {
        CreateNodeHelper.addNotEmptyNode(NAME, formFieldAdapter.getFullyQualifiedName(), root);
        CreateNodeHelper.addNotEmptyNode(VALUE, formFieldAdapter.getValue(), root);
        List<InteractiveFormFieldFeaturesObjectAdapter> children = formFieldAdapter.getChildren();
        if (children != null && !children.isEmpty()) {
            FeatureTreeNode childrenRoot = root.addChild(CHILDREN);
            for (InteractiveFormFieldFeaturesObjectAdapter child : children) {
                FeatureTreeNode childRoot = childrenRoot.addChild(INTERACTIVE_FORM_FIELD);
                this.createItem(childRoot, child);
            }
        }
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Error IDs", InteractiveFormFieldFeaturesObject.generateAttributeXPath(INTERACTIVE_FORM_FIELD, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

