/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.pdlayer.PDStructTreeNode;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.TaggedPDFHelper;

public abstract class GFPDStructTreeNode
extends GFPDObject
implements PDStructTreeNode {
    public static final String CHILDREN = "K";
    private List<GFPDStructElem> children;

    protected GFPDStructTreeNode(org.verapdf.pd.structure.PDStructTreeNode structTreeNodeDictionary, String type) {
        super(structTreeNodeDictionary, type);
    }

    @Override
    public String getkidsStandardTypes() {
        if (PDFFlavours.isWCAGFlavour(StaticContainers.getFlavour())) {
            return this.getChildrenStandardTypes().stream().filter(type -> type != null && !"Artifact".equals(type)).collect(Collectors.joining("&"));
        }
        return this.getChildrenStandardTypes().stream().filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    @Override
    public Boolean gethasContentItems() {
        return GFPDStructTreeNode.gethasContentItems(this);
    }

    private static Boolean gethasContentItems(GFPDStructTreeNode structElem) {
        COSObject children = structElem.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem(children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)children.getDirectBase()) {
                if (!TaggedPDFHelper.isContentItem(elem)) continue;
                return true;
            }
        }
        for (GFPDStructElem child : structElem.getChildren()) {
            if (!PDStructElem.isPassThroughTag(child.getstandardType()) || !GFPDStructTreeNode.gethasContentItems(child).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<String> getChildrenStandardTypes() {
        return GFPDStructTreeNode.getChildrenStandardTypes(this);
    }

    private static List<String> getChildrenStandardTypes(GFPDStructTreeNode element) {
        ArrayList<String> res = new ArrayList<String>();
        for (GFPDStructElem child : element.getChildren()) {
            String elementStandardType = child.getstandardType();
            if (PDStructElem.isPassThroughTag(elementStandardType)) {
                res.addAll(GFPDStructTreeNode.getChildrenStandardTypes(child));
                continue;
            }
            res.add(elementStandardType);
        }
        return Collections.unmodifiableList(res);
    }

    private List<GFPDStructElem> getChildren() {
        if (this.children == null) {
            List<PDStructElem> elements = ((org.verapdf.pd.structure.PDStructTreeNode)this.simplePDObject).getStructChildren();
            if (!elements.isEmpty()) {
                ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
                for (PDStructElem element : elements) {
                    res.add(GFSEFactory.createTypedStructElem(element));
                }
                this.children = Collections.unmodifiableList(res);
            } else {
                this.children = Collections.emptyList();
            }
        }
        return this.children;
    }

    public List<GFPDStructElem> getStructuralSignificanceChildren() {
        List<GFPDStructElem> children = this.getChildren();
        LinkedList<GFPDStructElem> result = new LinkedList<GFPDStructElem>();
        for (GFPDStructElem child : children) {
            if (PDStructElem.isPassThroughTag(child.getstandardType())) {
                result.addAll(child.getStructuralSignificanceChildren());
                continue;
            }
            result.add(child);
        }
        return result;
    }
}

