/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.xmp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFExtensionSchemaDefinition;
import org.verapdf.xmp.impl.VeraPDFExtensionSchemaProperty;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class VeraPDFExtensionSchemasContainer {
    public static final String PDFA_SCHEMA_PREFIX = "pdfaSchema";
    public static final String PDFA_PROPERTY_PREFIX = "pdfaProperty";
    public static final String NAMESPACE_URI = "namespaceURI";
    private final VeraPDFXMPNode veraPDFXMPNode;

    public VeraPDFExtensionSchemasContainer(VeraPDFXMPNode veraPDFXMPNode) {
        this.veraPDFXMPNode = veraPDFXMPNode;
    }

    public void addExtensionSchemaDefinition(VeraPDFExtensionSchemaDefinition veraPDFExtensionSchemaDefinition) throws XMPException {
        this.veraPDFXMPNode.getOriginalNode().addChild(veraPDFExtensionSchemaDefinition.getXmpNode());
    }

    public VeraPDFExtensionSchemaProperty getPropertyDefinition(String namespaceURI, String prefix, String name) {
        VeraPDFExtensionSchemaDefinition definition = this.getExtensionSchemaDefinitionXMPNode(namespaceURI, prefix);
        if (definition != null) {
            for (VeraPDFExtensionSchemaProperty propertyDefinitionXMPNode : definition.getExtensionSchemaProperties()) {
                if (!Objects.equals(propertyDefinitionXMPNode.getName(), name)) continue;
                return propertyDefinitionXMPNode;
            }
        }
        return null;
    }

    public VeraPDFExtensionSchemaDefinition getExtensionSchemaDefinitionXMPNode(String namespaceURI, String prefix) {
        for (VeraPDFExtensionSchemaDefinition definition : this.getExtensionSchemaDefinitions()) {
            if (!Objects.equals(definition.getNamespaceURI(), namespaceURI) || !Objects.equals(definition.getPrefix(), prefix)) continue;
            return definition;
        }
        return null;
    }

    private List<VeraPDFExtensionSchemaDefinition> getExtensionSchemaDefinitions() {
        if (this.veraPDFXMPNode != null && this.veraPDFXMPNode.getOptions().isArray()) {
            ArrayList<VeraPDFExtensionSchemaDefinition> res = new ArrayList<VeraPDFExtensionSchemaDefinition>();
            for (VeraPDFXMPNode node : this.veraPDFXMPNode.getChildren()) {
                res.add(new VeraPDFExtensionSchemaDefinition(node));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }
}

