# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._role_assignment_schedule_requests_operations import (
    build_cancel_request,
    build_create_request,
    build_get_request,
    build_list_for_scope_request,
    build_validate_request,
)
from .._configuration import AuthorizationManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class RoleAssignmentScheduleRequestsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.authorization.aio.AuthorizationManagementClient`'s
        :attr:`role_assignment_schedule_requests` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AuthorizationManagementClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create(
        self,
        scope: str,
        role_assignment_schedule_request_name: str,
        parameters: _models.RoleAssignmentScheduleRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Creates a role assignment schedule request.

        :param scope: The scope of the role assignment schedule request to create. The scope can be any
         REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a
         subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a
         resource group, and
         '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
         for a resource. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: A GUID for the role assignment to create. The
         name must be unique and different for each role assignment. Required.
        :type role_assignment_schedule_request_name: str
        :param parameters: Parameters for the role assignment schedule request. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        scope: str,
        role_assignment_schedule_request_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Creates a role assignment schedule request.

        :param scope: The scope of the role assignment schedule request to create. The scope can be any
         REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a
         subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a
         resource group, and
         '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
         for a resource. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: A GUID for the role assignment to create. The
         name must be unique and different for each role assignment. Required.
        :type role_assignment_schedule_request_name: str
        :param parameters: Parameters for the role assignment schedule request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        scope: str,
        role_assignment_schedule_request_name: str,
        parameters: Union[_models.RoleAssignmentScheduleRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Creates a role assignment schedule request.

        :param scope: The scope of the role assignment schedule request to create. The scope can be any
         REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a
         subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a
         resource group, and
         '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
         for a resource. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: A GUID for the role assignment to create. The
         name must be unique and different for each role assignment. Required.
        :type role_assignment_schedule_request_name: str
        :param parameters: Parameters for the role assignment schedule request. Is either a
         RoleAssignmentScheduleRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest or IO[bytes]
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RoleAssignmentScheduleRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RoleAssignmentScheduleRequest")

        _request = build_create_request(
            scope=scope,
            role_assignment_schedule_request_name=role_assignment_schedule_request_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RoleAssignmentScheduleRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, scope: str, role_assignment_schedule_request_name: str, **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Get the specified role assignment schedule request.

        :param scope: The scope of the role assignment schedule request. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: The name (guid) of the role assignment schedule
         request to get. Required.
        :type role_assignment_schedule_request_name: str
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        cls: ClsType[_models.RoleAssignmentScheduleRequest] = kwargs.pop("cls", None)

        _request = build_get_request(
            scope=scope,
            role_assignment_schedule_request_name=role_assignment_schedule_request_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RoleAssignmentScheduleRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_for_scope(
        self, scope: str, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.RoleAssignmentScheduleRequest"]:
        """Gets role assignment schedule requests for a scope.

        :param scope: The scope of the role assignments schedule requests. Required.
        :type scope: str
        :param filter: The filter to apply on the operation. Use $filter=atScope() to return all role
         assignment schedule requests at or above the scope. Use $filter=principalId eq {id} to return
         all role assignment schedule requests at, above or below the scope for the specified principal.
         Use $filter=asRequestor() to return all role assignment schedule requests requested by the
         current user. Use $filter=asTarget() to return all role assignment schedule requests created
         for the current user. Use $filter=asApprover() to return all role assignment schedule requests
         where the current user is an approver. Default value is None.
        :type filter: str
        :return: An iterator like instance of either RoleAssignmentScheduleRequest or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        cls: ClsType[_models.RoleAssignmentScheduleRequestListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_for_scope_request(
                    scope=scope,
                    filter=filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RoleAssignmentScheduleRequestListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def cancel(self, scope: str, role_assignment_schedule_request_name: str, **kwargs: Any) -> None:
        """Cancels a pending role assignment schedule request.

        :param scope: The scope of the role assignment request to cancel. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: The name of the role assignment request to
         cancel. Required.
        :type role_assignment_schedule_request_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_cancel_request(
            scope=scope,
            role_assignment_schedule_request_name=role_assignment_schedule_request_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def validate(
        self,
        scope: str,
        role_assignment_schedule_request_name: str,
        parameters: _models.RoleAssignmentScheduleRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Validates a new role assignment schedule request.

        :param scope: The scope of the role assignment request to validate. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: The name of the role assignment request to
         validate. Required.
        :type role_assignment_schedule_request_name: str
        :param parameters: Parameters for the role assignment schedule request. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate(
        self,
        scope: str,
        role_assignment_schedule_request_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Validates a new role assignment schedule request.

        :param scope: The scope of the role assignment request to validate. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: The name of the role assignment request to
         validate. Required.
        :type role_assignment_schedule_request_name: str
        :param parameters: Parameters for the role assignment schedule request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate(
        self,
        scope: str,
        role_assignment_schedule_request_name: str,
        parameters: Union[_models.RoleAssignmentScheduleRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.RoleAssignmentScheduleRequest:
        """Validates a new role assignment schedule request.

        :param scope: The scope of the role assignment request to validate. Required.
        :type scope: str
        :param role_assignment_schedule_request_name: The name of the role assignment request to
         validate. Required.
        :type role_assignment_schedule_request_name: str
        :param parameters: Parameters for the role assignment schedule request. Is either a
         RoleAssignmentScheduleRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest or IO[bytes]
        :return: RoleAssignmentScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RoleAssignmentScheduleRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RoleAssignmentScheduleRequest")

        _request = build_validate_request(
            scope=scope,
            role_assignment_schedule_request_name=role_assignment_schedule_request_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RoleAssignmentScheduleRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
