/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class ResponsiveFlowLayout
extends FlowLayout {
    public ResponsiveFlowLayout() {
    }

    public ResponsiveFlowLayout(int align) {
        super(align);
    }

    public ResponsiveFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        int parentWidth = target.getParent().getWidth();
        if (parentWidth == 0) {
            return super.preferredLayoutSize(target);
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            int maxWidth = parentWidth;
            int x = 0;
            int rowHeight = 0;
            boolean firstComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (firstComponent) {
                    firstComponent = false;
                } else {
                    x += this.getHgap();
                }
                if (x + d.width > maxWidth) {
                    dim.height += rowHeight + this.getVgap();
                    rowHeight = d.height;
                    x = d.width;
                } else {
                    x += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                dim.width = Math.max(dim.width, x);
            }
            dim.height += rowHeight + this.getVgap();
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.getHgap();
            dim.height += insets.top + insets.bottom + this.getVgap();
            return dim;
        }
    }
}

