/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_downloads;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import mediathek.daten.DownloadStartInfo;
import mediathek.gui.tabs.tab_downloads.DownloadStartInfoProperty;
import org.jetbrains.annotations.NotNull;

public class ActiveDownloadsInfoLabel
extends JLabel {
    public ActiveDownloadsInfoLabel(@NotNull DownloadStartInfoProperty startInfoProperty) {
        this.setToolTipText("Anzahl der aktiven Downloads");
        startInfoProperty.addStartInfoChangeListener(evt -> SwingUtilities.invokeLater(() -> this.process((DownloadStartInfo)evt.getNewValue())));
    }

    private void process(@NotNull DownloadStartInfo info) {
        if (info.hasValues()) {
            String numDownloads = info.running == 1 ? "1 l\u00e4uft" : info.running + " laufen";
            this.setText(numDownloads);
        } else {
            this.setText("0 laufen");
        }
    }
}

