/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

abstract class T4CMAREngine
implements Diagnosable {
    private static final String CLASS_NAME = T4CMAREngine.class.getName();
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = Short.MAX_VALUE;
    static final int TTCC_MXIN_OLD = 64;
    private int effectiveTTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short proSvrVer;
    static final byte[] NO_BYTES = new byte[0];
    boolean useCLRBigChunks = false;
    static final byte[] IGNORED = new byte[Short.MAX_VALUE];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final byte[] tmpBuffer10 = new byte[10];
    final int[] retLen = new int[1];
    AtomicReference<OracleConnection> connForException = new AtomicReference();
    static final byte[] NULL_PTR = new byte[]{0, 0, 0, 0};
    static final byte[] NOTNULL_PTR = new byte[]{127, 127, 127, 127};
    ArrayList<byte[]> refVector = null;
    private ArrayList<byte[]> clrList = null;

    T4CMAREngine() {
    }

    static String toHex(long value, int bytes) {
        String result;
        switch (bytes) {
            case 1: {
                result = "00" + Long.toString(value & 0xFFL, 16);
                break;
            }
            case 2: {
                result = "0000" + Long.toString(value & 0xFFFFL, 16);
                break;
            }
            case 3: {
                result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(value >> 32, 4) + T4CMAREngine.toHex(value, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + result.substring(result.length() - 2 * bytes);
    }

    static String toHex(byte value) {
        String result = "00" + Integer.toHexString(value & 0xFF);
        return "0x" + result.substring(result.length() - 2);
    }

    static String toHex(short value) {
        return T4CMAREngine.toHex(value, 2);
    }

    static String toHex(int value) {
        return T4CMAREngine.toHex(value, 4);
    }

    static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        Object result = "[";
        int len = Math.min(64, length);
        for (int i = 0; i < len; ++i) {
            result = (String)result + T4CMAREngine.toHex(value[i]) + " ";
        }
        if (len < length) {
            result = (String)result + "...";
        }
        return (String)result + "]";
    }

    static String toHex(byte[] value) {
        if (value == null) {
            return "null";
        }
        return T4CMAREngine.toHex(value, value.length);
    }

    abstract void marshalSB1(byte var1) throws IOException;

    abstract void marshalUB1(short var1) throws IOException;

    abstract void marshalSB2(short var1) throws IOException;

    abstract void marshalUB2(int var1) throws IOException;

    abstract void marshalNativeUB2(short var1, boolean var2) throws IOException;

    abstract void marshalSB4(int var1) throws IOException;

    abstract void marshalUB4(long var1) throws IOException;

    abstract void marshalUB8(long var1) throws IOException;

    abstract void marshalSB8(long var1) throws IOException;

    final void marshalSWORD(int value) throws IOException {
        this.marshalSB4(value);
    }

    final void marshalUWORD(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    abstract void marshalB1Array(byte[] var1) throws IOException;

    abstract void marshalB1Array(byte[] var1, int var2, int var3) throws IOException;

    final void marshalUB4Array(long[] value) throws IOException {
        for (int i = 0; i < value.length; ++i) {
            this.marshalSB4((int)(value[i] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    final void marshalO2U(boolean notnull) throws IOException {
        if (notnull) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    final void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    final void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    final void marshalCHR(byte[] value) throws IOException {
        this.marshalCHR(value, 0, value.length);
    }

    final void marshalCHR(byte[] value, int offset, int length) throws IOException {
        if (length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(value, offset, length);
            } else {
                this.marshalB1Array(value, offset, length);
            }
        }
    }

    final void marshalCLR(byte[] value, int valueLen) throws IOException {
        this.marshalCLR(value, 0, valueLen);
    }

    final void marshalCLR(byte[] value, int offset, int valueLen) throws IOException {
        if (valueLen > 252) {
            int len;
            int nbBytesWritten = 0;
            this.marshalUB1((short)-2);
            do {
                int bytesLeft;
                int n = len = (bytesLeft = valueLen - nbBytesWritten) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : bytesLeft;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(len);
                } else {
                    this.marshalUB1((byte)(len & 0xFF));
                }
                this.marshalB1Array(value, offset + nbBytesWritten, len);
            } while ((nbBytesWritten += len) < valueLen);
            this.marshalUB1((short)0);
        } else {
            this.marshalUB1((byte)(valueLen & 0xFF));
            if (value.length != 0) {
                this.marshalB1Array(value, offset, valueLen);
            }
        }
    }

    final void marshalCLR(DynamicByteArray value, long offset, int valueLen) throws IOException {
        if (valueLen > 252) {
            int chunkLen;
            int nbBytesWritten = 0;
            this.marshalUB1((short)-2);
            do {
                int bytesLeft;
                int n = chunkLen = (bytesLeft = valueLen - nbBytesWritten) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : bytesLeft;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(chunkLen);
                } else {
                    this.marshalUB1((byte)(chunkLen & 0xFF));
                }
                value.marshalB1Array(this, offset + (long)nbBytesWritten, chunkLen);
            } while ((nbBytesWritten += chunkLen) < valueLen);
            this.marshalUB1((short)0);
        } else {
            this.marshalUB1((byte)(valueLen & 0xFF));
            if (value.length != 0L) {
                value.marshalB1Array(this, offset, valueLen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalCLR(InputStream currentStream, int offset) throws IOException {
        int bufferLength = this.effectiveTTCC_MXIN;
        byte[] buffer = new byte[bufferLength];
        int bytesRead = 0;
        boolean endOfStream = false;
        this.marshalUB1((short)254);
        try {
            while (!endOfStream && !this.sentCancel()) {
                bytesRead = currentStream.read(buffer, 0, bufferLength);
                if (bytesRead == -1) {
                    endOfStream = true;
                }
                if (bytesRead <= 0) continue;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(bytesRead);
                } else {
                    this.marshalUB1((byte)(bytesRead & 0xFF));
                }
                this.marshalB1Array(buffer, 0, bytesRead);
            }
        }
        finally {
            this.marshalUB1((short)0);
        }
    }

    final void marshalKEYVAL(byte[][] keys, int[] keysSize, byte[][] values, int[] valuesSize, byte[] kvalflg, int nb) throws IOException {
        for (int i = 0; i < nb; ++i) {
            if (keys[i] != null && keysSize[i] > 0) {
                this.marshalUB4(keysSize[i]);
                this.marshalCLR(keys[i], 0, keysSize[i]);
            } else {
                this.marshalUB4(0L);
            }
            if (values[i] != null && valuesSize[i] > 0) {
                this.marshalUB4(valuesSize[i]);
                this.marshalCLR(values[i], 0, valuesSize[i]);
            } else {
                this.marshalUB4(0L);
            }
            if (kvalflg[i] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    final void marshalKEYVAL(byte[][] keys, byte[][] values, byte[] kvalflg, int nb) throws IOException {
        int[] keysSize = new int[nb];
        int[] valuesSize = new int[nb];
        for (int i = 0; i < nb; ++i) {
            if (keys[i] != null) {
                keysSize[i] = keys[i].length;
            }
            if (values[i] == null) continue;
            valuesSize[i] = values[i].length;
        }
        this.marshalKEYVAL(keys, keysSize, values, valuesSize, kvalflg, nb);
    }

    final void marshalDALC(byte[] buffer) throws IOException {
        if (buffer == null || buffer.length < 1) {
            this.marshalUB4(0L);
        } else {
            this.marshalUB4(buffer.length);
            this.marshalCLR(buffer, buffer.length);
        }
    }

    final void marshalKPDKV(byte[][] textValues, byte[][] binaryValues, int[] keywords) throws IOException {
        for (int i = 0; i < textValues.length; ++i) {
            if (textValues[i] != null) {
                this.marshalUB4(textValues[i].length);
                this.marshalCLR(textValues[i], 0, textValues[i].length);
            } else {
                this.marshalUB4(0L);
            }
            if (binaryValues[i] != null) {
                this.marshalUB4(binaryValues[i].length);
                this.marshalCLR(binaryValues[i], 0, binaryValues[i].length);
            } else {
                this.marshalUB4(0L);
            }
            this.marshalUB2(keywords[i]);
        }
    }

    final void unmarshalKPDKV(byte[][] textValues, int[] textValuesLength, byte[][] binaryValues, int[] keywords) throws IOException, SQLException {
        int tempLength = 0;
        int[] tempAr = new int[1];
        for (int i = 0; i < textValues.length; ++i) {
            tempLength = (int)this.unmarshalUB4();
            if (tempLength > 0) {
                textValues[i] = new byte[tempLength];
                this.unmarshalCLR(textValues[i], 0, tempAr, tempLength);
                textValuesLength[i] = tempAr[0];
            }
            if ((tempLength = (int)this.unmarshalUB4()) > 0) {
                binaryValues[i] = new byte[tempLength];
                this.unmarshalCLR(binaryValues[i], 0, tempAr, tempLength);
            }
            keywords[i] = this.unmarshalUB2();
        }
    }

    final void addPtr(byte value) throws IOException {
        if (this.types.rep[4] == 1) {
            this.marshalUB1(value);
        } else if (value == 0) {
            this.marshalB1Array(NULL_PTR);
        } else {
            this.marshalB1Array(NOTNULL_PTR);
        }
    }

    abstract byte unmarshalSB1() throws SQLException, IOException;

    abstract short unmarshalUB1() throws SQLException, IOException;

    abstract short unmarshalSB2() throws SQLException, IOException;

    int unmarshalNativeUB2(boolean isLsb) throws SQLException, IOException {
        int value = 0;
        this.unmarshalNBytes(this.tmpBuffer2, 0, 2);
        value = isLsb ? this.tmpBuffer2[1] << 8 & 0xFF00 | this.tmpBuffer2[0] & 0xFF : this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
        return value;
    }

    abstract int unmarshalUB2() throws SQLException, IOException;

    final int unmarshalUCS2(byte[] ucs2Char, long offset) throws SQLException, IOException {
        int value = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((value & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(value & 0xFF);
        if (offset + 1L < (long)ucs2Char.length) {
            ucs2Char[(int)offset] = this.tmpBuffer2[0];
            ucs2Char[(int)offset + 1] = this.tmpBuffer2[1];
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalUCS2", "ucs2Char buffer too small", null, null);
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    abstract int unmarshalSB4() throws SQLException, IOException;

    abstract long unmarshalUB4() throws SQLException, IOException;

    abstract int unmarshalSB4(byte[] var1) throws SQLException, IOException;

    abstract long unmarshalSB8() throws SQLException, IOException;

    final int unmarshalRefCursor(byte[] buffer) throws SQLException, IOException {
        int result = this.unmarshalSB4(buffer);
        return result;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long result = this.unmarshalUB4();
        return result;
    }

    abstract byte[] unmarshalNBytes(int var1) throws SQLException, IOException;

    abstract int unmarshalNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract int getNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract byte[] getNBytes(int var1) throws SQLException, IOException;

    abstract void skipNBytes(int var1) throws SQLException, IOException;

    abstract byte[] unmarshalTEXT(int var1) throws SQLException, IOException;

    byte[] unmarshalCHR(int retLength) throws SQLException, IOException {
        byte[] resBuffer = null;
        if (this.types.isConvNeeded()) {
            resBuffer = this.unmarshalCLR(retLength, this.retLen);
            if (resBuffer.length != this.retLen[0]) {
                byte[] tmpBuf = new byte[this.retLen[0]];
                System.arraycopy(resBuffer, 0, tmpBuf, 0, this.retLen[0]);
                resBuffer = tmpBuf;
            }
        } else {
            resBuffer = this.getNBytes(retLength);
        }
        return resBuffer;
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, maxSize, 0);
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize, int ignoreNBytes) throws SQLException, IOException {
        int len = 0;
        int locallen = 0;
        int offset = offsetRow;
        int nbBytesWritten = 0;
        int keepThem = 0;
        int nbOfBytesIgnored = 0;
        len = this.unmarshalUB1();
        if (len < 0) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalCLR", "length less than 0", null, null);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (len == 0) {
            intArray[0] = 0;
            return;
        }
        if (this.escapeSequenceNull(len)) {
            intArray[0] = 0;
            return;
        }
        if (len != 254) {
            if (ignoreNBytes - nbOfBytesIgnored >= len) {
                this.unmarshalBuffer(IGNORED, 0, len);
                nbOfBytesIgnored += len;
                len = 0;
            } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                this.unmarshalBuffer(IGNORED, 0, ignoreNBytes - nbOfBytesIgnored);
                len -= ignoreNBytes - nbOfBytesIgnored;
                nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
            }
            if (len > 0) {
                keepThem = Math.min(maxSize - nbBytesWritten, len);
                offset = this.unmarshalBuffer(bytes, offset, keepThem);
                nbBytesWritten += keepThem;
                int rest = len - keepThem;
                if (rest > 0) {
                    this.unmarshalBuffer(IGNORED, 0, rest);
                }
            }
        } else {
            while (true) {
                int n = len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1();
                if (len <= 0) break;
                if (offset == -1) {
                    this.unmarshalBuffer(IGNORED, 0, len);
                    continue;
                }
                locallen = len;
                if (ignoreNBytes - nbOfBytesIgnored >= locallen) {
                    this.unmarshalBuffer(IGNORED, 0, locallen);
                    nbOfBytesIgnored += locallen;
                    locallen = 0;
                } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                    this.unmarshalBuffer(IGNORED, 0, ignoreNBytes - nbOfBytesIgnored);
                    locallen -= ignoreNBytes - nbOfBytesIgnored;
                    nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                }
                if (locallen <= 0) continue;
                keepThem = Math.min(maxSize - nbBytesWritten, locallen);
                offset = this.unmarshalBuffer(bytes, offset, keepThem);
                nbBytesWritten += keepThem;
                int rest = locallen - keepThem;
                if (rest <= 0) continue;
                this.unmarshalBuffer(IGNORED, 0, rest);
            }
        }
        if (intArray != null) {
            if (offset != -1) {
                intArray[0] = nbBytesWritten;
            } else {
                intArray[0] = bytes.length - offsetRow;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalCLR", "exceeded the tmpBuffer length", null, null);
            }
        }
    }

    final byte[] unmarshalCLR(int buflen, int[] intArray) throws SQLException, IOException {
        byte[] tmpBuf = new byte[buflen * this.conv.c2sNlsRatio];
        this.unmarshalCLR(tmpBuf, 0, intArray, buflen);
        return tmpBuf;
    }

    final int[] unmarshalKEYVAL(byte[][] keys, byte[][] values, int nb) throws SQLException, IOException {
        byte[] buff = new byte[1000];
        int[] length = new int[1];
        int[] kvalflg = new int[nb];
        for (int i = 0; i < nb; ++i) {
            int len = this.unmarshalSB4();
            if (len > 0) {
                this.unmarshalCLR(buff, 0, length);
                keys[i] = new byte[length[0]];
                System.arraycopy(buff, 0, keys[i], 0, length[0]);
            }
            if ((len = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(buff, 0, length);
                values[i] = new byte[length[0]];
                System.arraycopy(buff, 0, values[i], 0, length[0]);
            }
            kvalflg[i] = this.unmarshalSB4();
        }
        buff = null;
        return kvalflg;
    }

    final int unmarshalBuffer(byte[] _byteValue, int offset, int len) throws SQLException, IOException {
        if (len <= 0) {
            return offset;
        }
        if (_byteValue.length < offset + len) {
            this.unmarshalNBytes(_byteValue, offset, _byteValue.length - offset);
            this.unmarshalNBytes(IGNORED, 0, offset + len - _byteValue.length);
            offset = -1;
        } else {
            this.unmarshalNBytes(_byteValue, offset, len);
            offset += len;
        }
        return offset;
    }

    final byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        int len = 0;
        short totalLen = 0;
        byte[] finalBuffer = null;
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalCLRforREFS", "bytes < 0", null, null);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (bytes == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(bytes)) {
            byte[] tmpBuf;
            if (this.refVector == null) {
                this.refVector = new ArrayList(10);
            } else {
                this.refVector.clear();
            }
            if (bytes == 254) {
                while ((len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                    if (len == 254 && !this.useCLRBigChunks && this.types.isServerConversion()) continue;
                    totalLen = (short)(totalLen + len);
                    tmpBuf = new byte[len];
                    this.unmarshalBuffer(tmpBuf, 0, len);
                    this.refVector.add(tmpBuf);
                }
            } else {
                totalLen = bytes;
                tmpBuf = new byte[bytes];
                this.unmarshalBuffer(tmpBuf, 0, bytes);
                this.refVector.add(tmpBuf);
            }
            finalBuffer = new byte[totalLen];
            int start = 0;
            while (this.refVector.size() > 0) {
                int arrayLen = this.refVector.get(0).length;
                System.arraycopy(this.refVector.get(0), 0, finalBuffer, start, arrayLen);
                start += arrayLen;
                this.refVector.remove(0);
            }
        } else {
            finalBuffer = null;
        }
        return finalBuffer;
    }

    final byte[] unmarshalCLR() throws SQLException, IOException {
        int len = 0;
        short totalLen = 0;
        byte[] finalBuffer = null;
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalCLR", "bytes < 0", null, null);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (bytes == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(bytes)) {
            byte[] tmpBuf;
            if (this.clrList == null) {
                this.clrList = new ArrayList(10);
            } else {
                this.clrList.clear();
            }
            if (bytes == 254) {
                while ((len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                    totalLen = (short)(totalLen + len);
                    tmpBuf = new byte[len];
                    this.unmarshalBuffer(tmpBuf, 0, len);
                    this.clrList.add(tmpBuf);
                }
            } else {
                totalLen = bytes;
                tmpBuf = new byte[bytes];
                this.unmarshalBuffer(tmpBuf, 0, bytes);
                this.clrList.add(tmpBuf);
            }
            finalBuffer = new byte[totalLen];
            int start = 0;
            while (this.clrList.size() > 0) {
                int arrayLen = this.clrList.get(0).length;
                System.arraycopy(this.clrList.get(0), 0, finalBuffer, start, arrayLen);
                start += arrayLen;
                this.clrList.remove(0);
            }
        } else {
            finalBuffer = null;
        }
        return finalBuffer;
    }

    final void unmarshalCLRAndIgnore() throws SQLException, IOException {
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalCLRAndIgnore", "bytes < 0", null, null);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (bytes == 0) {
            return;
        }
        if (!this.escapeSequenceNull(bytes)) {
            if (bytes == 254) {
                int len = 0;
                while ((len = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                    this.skipNBytes(len);
                }
            } else {
                this.skipNBytes(bytes);
            }
        }
    }

    final boolean escapeSequenceNull(int bytes) throws SQLException {
        boolean is_null = false;
        switch (bytes) {
            case 0: {
                is_null = true;
                break;
            }
            case 253: {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "escapeSequenceNull", "received an ESC", null, null);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
            case 255: {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "escapeSequenceNull", "received an ERROR", null, null);
                is_null = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return is_null;
    }

    final int processIndicator(boolean isNull, int dataSize) throws SQLException, IOException {
        short ind = this.unmarshalSB2();
        int res = 0;
        if (!isNull) {
            res = ind == 0 ? dataSize : (ind == -2 || ind > 0 ? (int)ind : 65536 + ind);
        }
        return res;
    }

    final int unmarshalDALC(byte[] buffer, int offset) throws SQLException, IOException {
        int len = (int)this.unmarshalUB4();
        if (len > 0) {
            this.unmarshalCLR(buffer, offset, this.retLen);
        }
        return len;
    }

    final byte[] unmarshalDALC() throws SQLException, IOException {
        byte[] buffer;
        int len = (int)this.unmarshalUB4();
        if (len > 0) {
            buffer = this.unmarshalCLR(len, this.retLen);
            if (buffer == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalDALC", "buffer == null", null, null);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
        } else {
            this.retLen[0] = 0;
            buffer = NO_BYTES;
        }
        return buffer;
    }

    final byte[] unmarshalDALC(int[] CLRRetLen) throws SQLException, IOException {
        byte[] buffer;
        int len = (int)this.unmarshalUB4();
        if (len > 0) {
            buffer = this.unmarshalCLR(len, CLRRetLen);
            if (buffer == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalDALC", "buffer == null", null, null);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
        } else {
            CLRRetLen[0] = 0;
            buffer = NO_BYTES;
        }
        return buffer;
    }

    abstract long buffer2Value(byte var1) throws SQLException, IOException;

    final long buffer2Value(byte repOffset, ByteArrayInputStream in) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            bufLength = in.read();
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                this.trace(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "buffer2Value", "bufLength < 0", null, null, new Object[0]);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                this.trace(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "buffer2Value", "incorrect number of bytes", null, null, new Object[0]);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 412).fillInStackTrace();
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        }
        if (in.read(tmpBuffer = new byte[bufLength]) < 0) {
            this.trace(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "buffer2Value", "end of buffer", null, null, new Object[0]);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
        }
        for (int i = 0; i < tmpBuffer.length; ++i) {
            short tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (short)(tmpBuffer[tmpBuffer.length - 1 - i] & 0xFF) : (short)(tmpBuffer[i] & 0xFF);
            value |= (long)(tmpByte << 8 * (tmpBuffer.length - 1 - i));
        }
        value &= 0xFFFFFFFFFFFFFFFFL;
        if (negative) {
            value = -value;
        }
        return value;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connForException.get();
    }

    protected void setConnectionDuringExceptionHandling(OracleConnection conn) {
        this.connForException.set(conn);
    }

    protected abstract void flush() throws IOException;

    abstract void setByteOrder(byte var1) throws IOException;

    abstract boolean sentCancel();

    abstract void writeZeroCopyIO(byte[] var1, int var2, int var3) throws IOException, NetException;

    void writeZeroCopyIO(DynamicByteArray dba, long offset, int length) throws IOException, NetException {
        dba.writeZeroCopyIO(this, offset, length);
    }

    abstract void writeZeroCopyIOHeader(boolean var1, int var2, boolean var3) throws IOException, NetException;

    abstract void writeZeroCopyIOData(byte[] var1, int var2, int var3) throws IOException, NetException;

    boolean readZeroCopyIO(byte[] userBuffer, int offset, int[] bytesRead) throws IOException, NetException {
        boolean isMarked = this.net.readZeroCopyIO(userBuffer, offset, bytesRead);
        return isMarked;
    }

    void setUseCLRBigChunks(boolean useCLRBigChunks) {
        this.useCLRBigChunks = useCLRBigChunks;
        if (useCLRBigChunks) {
            this.effectiveTTCC_MXIN = Short.MAX_VALUE;
        } else {
            assert (false);
            this.effectiveTTCC_MXIN = 64;
        }
    }

    abstract void clearWriteBuffer();

    void beginPipelineRequest() throws IOException {
        throw new UnsupportedOperationException();
    }

    boolean endPipelineRequest() throws IOException {
        throw new UnsupportedOperationException();
    }

    void beginPipelineResponse() {
        throw new UnsupportedOperationException();
    }

    void endPipelineResponse() throws IOException {
        throw new UnsupportedOperationException();
    }
}

