/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.ec2;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.util.LazyInitializable;
import org.opensearch.core.common.Strings;
import org.opensearch.discovery.ec2.AmazonEc2ClientReference;
import org.opensearch.discovery.ec2.AwsEc2Service;
import org.opensearch.discovery.ec2.Ec2ClientSettings;
import org.opensearch.secure_sm.AccessController;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;

class AwsEc2ServiceImpl
implements AwsEc2Service {
    private static final Logger logger = LogManager.getLogger(AwsEc2ServiceImpl.class);
    private final AtomicReference<LazyInitializable<AmazonEc2ClientReference, OpenSearchException>> lazyClientReference = new AtomicReference();

    AwsEc2ServiceImpl() {
    }

    private Ec2Client buildClient(Ec2ClientSettings clientSettings) {
        AccessController.doPrivileged(AwsEc2ServiceImpl::setDefaultAwsProfilePath);
        AwsCredentialsProvider awsCredentialsProvider = AwsEc2ServiceImpl.buildCredentials(logger, clientSettings);
        ClientOverrideConfiguration overrideConfiguration = AwsEc2ServiceImpl.buildOverrideConfiguration(logger, clientSettings);
        ProxyConfiguration proxyConfiguration = (ProxyConfiguration)AccessController.doPrivileged(() -> AwsEc2ServiceImpl.buildProxyConfiguration(logger, clientSettings));
        return this.buildClient(awsCredentialsProvider, proxyConfiguration, overrideConfiguration, clientSettings.endpoint, clientSettings.region, clientSettings.readTimeoutMillis);
    }

    protected Ec2Client buildClient(AwsCredentialsProvider awsCredentialsProvider, ProxyConfiguration proxyConfiguration, ClientOverrideConfiguration overrideConfiguration, String endpoint, String region, long readTimeoutMillis) {
        ApacheHttpClient.Builder clientBuilder = ApacheHttpClient.builder().proxyConfiguration(proxyConfiguration).socketTimeout(Duration.ofMillis(readTimeoutMillis));
        Ec2ClientBuilder builder = (Ec2ClientBuilder)((Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().overrideConfiguration(overrideConfiguration)).httpClientBuilder((SdkHttpClient.Builder)clientBuilder)).credentialsProvider(awsCredentialsProvider);
        if (Strings.hasText((String)endpoint)) {
            logger.debug("using explicit ec2 endpoint [{}]", (Object)endpoint);
            builder.endpointOverride(URI.create(this.getFullEndpoint(endpoint)));
        }
        if (Strings.hasText((String)region)) {
            logger.debug("using explicit ec2 region [{}]", (Object)region);
            builder.region(Region.of((String)region));
        }
        return (Ec2Client)AccessController.doPrivileged(() -> ((Ec2ClientBuilder)builder).build());
    }

    protected String getFullEndpoint(String endpoint) {
        if (!Strings.hasText((String)endpoint)) {
            return null;
        }
        if (endpoint.startsWith("http://") || endpoint.startsWith("https://")) {
            return endpoint;
        }
        logger.debug("no scheme found in endpoint [{}], defaulting to https", (Object)endpoint);
        return "https://" + endpoint;
    }

    static ProxyConfiguration buildProxyConfiguration(Logger logger, Ec2ClientSettings clientSettings) {
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            try {
                return (ProxyConfiguration)ProxyConfiguration.builder().endpoint(new URI(clientSettings.protocol.toString(), null, clientSettings.proxyHost, clientSettings.proxyPort, null, null, null)).username(clientSettings.proxyUsername).password(clientSettings.proxyPassword).build();
            }
            catch (URISyntaxException e) {
                throw SdkException.create((String)"Invalid proxy URL", (Throwable)e);
            }
        }
        return (ProxyConfiguration)ProxyConfiguration.builder().build();
    }

    static ClientOverrideConfiguration buildOverrideConfiguration(Logger logger, Ec2ClientSettings clientSettings) {
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(AwsEc2ServiceImpl.buildRetryPolicy(logger, clientSettings)).build();
    }

    static RetryPolicy buildRetryPolicy(Logger logger, Ec2ClientSettings clientSettings) {
        RetryPolicy.Builder retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(10));
        return retryPolicy.build();
    }

    static AwsCredentialsProvider buildCredentials(Logger logger, Ec2ClientSettings clientSettings) {
        AwsCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using default credentials provider");
            return DefaultCredentialsProvider.create();
        }
        logger.debug("Using basic key/secret credentials");
        return StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    @Override
    public AmazonEc2ClientReference client() {
        LazyInitializable<AmazonEc2ClientReference, OpenSearchException> clientReference = this.lazyClientReference.get();
        if (clientReference == null) {
            throw new IllegalStateException("Missing ec2 client configs");
        }
        return (AmazonEc2ClientReference)((Object)clientReference.getOrCompute());
    }

    @Override
    public void refreshAndClearCache(Ec2ClientSettings clientSettings) {
        LazyInitializable newClient = new LazyInitializable(() -> new AmazonEc2ClientReference(this.buildClient(clientSettings)), clientReference -> clientReference.incRef(), clientReference -> clientReference.decRef());
        LazyInitializable<AmazonEc2ClientReference, OpenSearchException> oldClient = this.lazyClientReference.getAndSet((LazyInitializable<AmazonEc2ClientReference, OpenSearchException>)newClient);
        if (oldClient != null) {
            oldClient.reset();
        }
    }

    @Override
    public void close() {
        LazyInitializable clientReference = this.lazyClientReference.getAndSet(null);
        if (clientReference != null) {
            clientReference.reset();
        }
    }

    @SuppressForbidden(reason="Prevent AWS SDK v2 from using ~/.aws/config and ~/.aws/credentials.")
    static void setDefaultAwsProfilePath() {
        if (ProfileFileSystemSetting.AWS_SHARED_CREDENTIALS_FILE.getStringValue().isEmpty()) {
            logger.info("setting aws.sharedCredentialsFile={}", (Object)System.getProperty("opensearch.path.conf"));
            System.setProperty(ProfileFileSystemSetting.AWS_SHARED_CREDENTIALS_FILE.property(), System.getProperty("opensearch.path.conf"));
        }
        if (ProfileFileSystemSetting.AWS_CONFIG_FILE.getStringValue().isEmpty()) {
            logger.info("setting aws.sharedCredentialsFile={}", (Object)System.getProperty("opensearch.path.conf"));
            System.setProperty(ProfileFileSystemSetting.AWS_CONFIG_FILE.property(), System.getProperty("opensearch.path.conf"));
        }
    }
}

