/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsResponse;
import software.amazon.awssdk.services.ec2.model.MacHost;

public class DescribeMacHostsIterable
implements SdkIterable<DescribeMacHostsResponse> {
    private final Ec2Client client;
    private final DescribeMacHostsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMacHostsIterable(Ec2Client client, DescribeMacHostsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMacHostsResponseFetcher();
    }

    public Iterator<DescribeMacHostsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MacHost> macHosts() {
        Function<DescribeMacHostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.macHosts() != null) {
                return response.macHosts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMacHostsResponseFetcher
    implements SyncPageFetcher<DescribeMacHostsResponse> {
        private DescribeMacHostsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMacHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMacHostsResponse nextPage(DescribeMacHostsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMacHostsIterable.this.client.describeMacHosts(DescribeMacHostsIterable.this.firstRequest);
            }
            return DescribeMacHostsIterable.this.client.describeMacHosts((DescribeMacHostsRequest)((Object)DescribeMacHostsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

