/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.monitor;

import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventChecker;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.view.JFRViewTabProvider;
import org.graalvm.visualvm.jfr.views.monitor.JFRSnapshotMonitorView;

public class JFRSnapshotMonitorViewProvider
extends JFRViewTabProvider {
    static final String EVENT_CPU_LOAD = "jdk.CPULoad";
    static final String EVENT_HEAP_SUMMARY = "jdk.GCHeapSummary";
    static final String EVENT_PERMGEN_SUMMARY = "http://www.oracle.com/hotspot/jvm/vm/gc/heap/perm_gen_summary";
    static final String EVENT_METASPACE_SUMMARY = "jdk.MetaspaceSummary";
    static final String EVENT_CLASS_LOADING = "jdk.ClassLoadingStatistics";
    static final String EVENT_JAVA_THREAD = "jdk.JavaThreadStatistics";

    @Override
    protected JFRViewTab createView(JFRSnapshot jfrSnapshot) {
        return new JFRSnapshotMonitorView(jfrSnapshot);
    }

    public static final class EventChecker
    extends JFREventChecker {
        public EventChecker() {
            super(EventChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotMonitorViewProvider.EVENT_CPU_LOAD, JFRSnapshotMonitorViewProvider.EVENT_HEAP_SUMMARY, JFRSnapshotMonitorViewProvider.EVENT_PERMGEN_SUMMARY, JFRSnapshotMonitorViewProvider.EVENT_METASPACE_SUMMARY, JFRSnapshotMonitorViewProvider.EVENT_CLASS_LOADING, JFRSnapshotMonitorViewProvider.EVENT_JAVA_THREAD};
        }
    }

    public static final class MetaspaceChecker
    extends JFREventChecker {
        public MetaspaceChecker() {
            super(MetaspaceChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotMonitorViewProvider.EVENT_METASPACE_SUMMARY};
        }
    }

    public static final class PermGenChecker
    extends JFREventChecker {
        public PermGenChecker() {
            super(PermGenChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotMonitorViewProvider.EVENT_PERMGEN_SUMMARY};
        }
    }
}

