/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldSelectionList
extends ObjectSelectionList<Entry> {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
    static final ResourceLocation ERROR_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/error_highlighted");
    static final ResourceLocation ERROR_SPRITE = ResourceLocation.withDefaultNamespace("world_list/error");
    static final ResourceLocation MARKED_JOIN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/marked_join_highlighted");
    static final ResourceLocation MARKED_JOIN_SPRITE = ResourceLocation.withDefaultNamespace("world_list/marked_join");
    static final ResourceLocation WARNING_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/warning_highlighted");
    static final ResourceLocation WARNING_SPRITE = ResourceLocation.withDefaultNamespace("world_list/warning");
    static final ResourceLocation JOIN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/join_highlighted");
    static final ResourceLocation JOIN_SPRITE = ResourceLocation.withDefaultNamespace("world_list/join");
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation FORGE_EXPERIMENTAL_WARNING_ICON = ResourceLocation.fromNamespaceAndPath("forge", "textures/gui/experimental_warning.png");
    static final Component FROM_NEWER_TOOLTIP_1 = Component.translatable("selectWorld.tooltip.fromNewerVersion1").withStyle(ChatFormatting.RED);
    static final Component FROM_NEWER_TOOLTIP_2 = Component.translatable("selectWorld.tooltip.fromNewerVersion2").withStyle(ChatFormatting.RED);
    static final Component SNAPSHOT_TOOLTIP_1 = Component.translatable("selectWorld.tooltip.snapshot1").withStyle(ChatFormatting.GOLD);
    static final Component SNAPSHOT_TOOLTIP_2 = Component.translatable("selectWorld.tooltip.snapshot2").withStyle(ChatFormatting.GOLD);
    static final Component WORLD_LOCKED_TOOLTIP = Component.translatable("selectWorld.locked").withStyle(ChatFormatting.RED);
    static final Component WORLD_REQUIRES_CONVERSION = Component.translatable("selectWorld.conversion.tooltip").withStyle(ChatFormatting.RED);
    static final Component INCOMPATIBLE_VERSION_TOOLTIP = Component.translatable("selectWorld.incompatible.tooltip").withStyle(ChatFormatting.RED);
    static final Component WORLD_EXPERIMENTAL = Component.translatable("selectWorld.experimental");
    private final SelectWorldScreen screen;
    private CompletableFuture<List<LevelSummary>> pendingLevels;
    @Nullable
    private List<LevelSummary> currentlyDisplayedLevels;
    private String filter;
    private final LoadingHeader loadingHeader;

    public WorldSelectionList(SelectWorldScreen p_239540_, Minecraft p_239541_, int p_239542_, int p_239543_, int p_239544_, int p_239545_, String p_239547_, @Nullable WorldSelectionList p_239548_) {
        super(p_239541_, p_239542_, p_239543_, p_239544_, p_239545_);
        this.screen = p_239540_;
        this.loadingHeader = new LoadingHeader(p_239541_);
        this.filter = p_239547_;
        this.pendingLevels = p_239548_ != null ? p_239548_.pendingLevels : this.loadLevels();
        this.handleNewLevels(this.pollLevelsIgnoreErrors());
    }

    protected void clearEntries() {
        this.children().forEach(Entry::close);
        super.clearEntries();
    }

    @Nullable
    private List<LevelSummary> pollLevelsIgnoreErrors() {
        try {
            return this.pendingLevels.getNow(null);
        }
        catch (CancellationException | CompletionException completionexception) {
            return null;
        }
    }

    void reloadWorldList() {
        this.pendingLevels = this.loadLevels();
    }

    public boolean keyPressed(int p_289017_, int p_288966_, int p_289020_) {
        Optional<WorldListEntry> optional;
        if (CommonInputs.selected((int)p_289017_) && (optional = this.getSelectedOpt()).isPresent()) {
            if (optional.get().canJoin()) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                optional.get().joinWorld();
            }
            return true;
        }
        return super.keyPressed(p_289017_, p_288966_, p_289020_);
    }

    public void renderWidget(GuiGraphics p_310403_, int p_312182_, int p_312151_, float p_311062_) {
        List<LevelSummary> list = this.pollLevelsIgnoreErrors();
        if (list != this.currentlyDisplayedLevels) {
            this.handleNewLevels(list);
        }
        super.renderWidget(p_310403_, p_312182_, p_312151_, p_311062_);
    }

    private void handleNewLevels(@Nullable List<LevelSummary> p_239665_) {
        if (p_239665_ == null) {
            this.fillLoadingLevels();
        } else {
            this.fillLevels(this.filter, p_239665_);
        }
        this.currentlyDisplayedLevels = p_239665_;
    }

    public void updateFilter(String p_239901_) {
        if (this.currentlyDisplayedLevels != null && !p_239901_.equals(this.filter)) {
            this.fillLevels(p_239901_, this.currentlyDisplayedLevels);
        }
        this.filter = p_239901_;
    }

    private CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates levelstoragesource$levelcandidates;
        try {
            levelstoragesource$levelcandidates = this.minecraft.getLevelSource().findLevelCandidates();
        }
        catch (LevelStorageException levelstorageexception) {
            LOGGER.error("Couldn't load level list", (Throwable)levelstorageexception);
            this.handleLevelLoadFailure(levelstorageexception.getMessageComponent());
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelstoragesource$levelcandidates.isEmpty()) {
            CreateWorldScreen.openFresh(this.minecraft, null);
            return CompletableFuture.completedFuture(List.of());
        }
        return this.minecraft.getLevelSource().loadLevelSummaries(levelstoragesource$levelcandidates).exceptionally(p_233202_ -> {
            this.minecraft.delayCrash(CrashReport.forThrowable(p_233202_, "Couldn't load level list"));
            return List.of();
        });
    }

    private void fillLevels(String p_233199_, List<LevelSummary> p_233200_) {
        this.clearEntries();
        p_233199_ = p_233199_.toLowerCase(Locale.ROOT);
        for (LevelSummary levelsummary : p_233200_) {
            if (!this.filterAccepts(p_233199_, levelsummary)) continue;
            this.addEntry((AbstractSelectionList.Entry)new WorldListEntry(this, levelsummary));
        }
        this.notifyListUpdated();
    }

    private boolean filterAccepts(String p_233196_, LevelSummary p_233197_) {
        return p_233197_.getLevelName().toLowerCase(Locale.ROOT).contains(p_233196_) || p_233197_.getLevelId().toLowerCase(Locale.ROOT).contains(p_233196_);
    }

    private void fillLoadingLevels() {
        this.clearEntries();
        this.addEntry((AbstractSelectionList.Entry)this.loadingHeader);
        this.notifyListUpdated();
    }

    private void notifyListUpdated() {
        this.refreshScrollAmount();
        this.screen.triggerImmediateNarration(true);
    }

    private void handleLevelLoadFailure(Component p_233212_) {
        this.minecraft.setScreen((Screen)new ErrorScreen((Component)Component.translatable("selectWorld.unable_to_load"), p_233212_));
    }

    public int getRowWidth() {
        return 270;
    }

    public void setSelected(@Nullable Entry p_233190_) {
        LevelSummary levelSummary;
        super.setSelected((AbstractSelectionList.Entry)p_233190_);
        if (p_233190_ instanceof WorldListEntry) {
            WorldListEntry worldselectionlist$worldlistentry = (WorldListEntry)p_233190_;
            levelSummary = worldselectionlist$worldlistentry.summary;
        } else {
            levelSummary = null;
        }
        this.screen.updateButtonStatus(levelSummary);
    }

    public Optional<WorldListEntry> getSelectedOpt() {
        Optional<WorldListEntry> optional;
        Entry worldselectionlist$entry = (Entry)this.getSelected();
        if (worldselectionlist$entry instanceof WorldListEntry) {
            WorldListEntry worldselectionlist$worldlistentry = (WorldListEntry)worldselectionlist$entry;
            optional = Optional.of(worldselectionlist$worldlistentry);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public SelectWorldScreen getScreen() {
        return this.screen;
    }

    public void updateWidgetNarration(NarrationElementOutput p_313204_) {
        if (this.children().contains(this.loadingHeader)) {
            this.loadingHeader.updateNarration(p_313204_);
        } else {
            super.updateWidgetNarration(p_313204_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private static final Component LOADING_LABEL = Component.translatable("selectWorld.loading_list");
        private final Minecraft minecraft;

        public LoadingHeader(Minecraft p_233222_) {
            this.minecraft = p_233222_;
        }

        public void render(GuiGraphics p_282319_, int p_283207_, int p_281352_, int p_283332_, int p_282400_, int p_282912_, int p_282760_, int p_281344_, boolean p_283655_, float p_283696_) {
            int i = (this.minecraft.screen.width - this.minecraft.font.width(LOADING_LABEL)) / 2;
            int j = p_281352_ + (p_282912_ - 9) / 2;
            p_282319_.drawString(this.minecraft.font, LOADING_LABEL, i, j, -1);
            String s = LoadingDotsText.get((long)Util.getMillis());
            int k = (this.minecraft.screen.width - this.minecraft.font.width(s)) / 2;
            int l = j + 9;
            p_282319_.drawString(this.minecraft.font, s, k, l, -8355712);
        }

        public Component getNarration() {
            return LOADING_LABEL;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final class WorldListEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private final Minecraft minecraft;
        private final SelectWorldScreen screen;
        final LevelSummary summary;
        private final FaviconTexture icon;
        @Nullable
        private Path iconFile;
        private long lastClickTime;

        public WorldListEntry(WorldSelectionList p_101702_, LevelSummary p_101703_) {
            this.minecraft = p_101702_.minecraft;
            this.screen = p_101702_.getScreen();
            this.summary = p_101703_;
            this.icon = FaviconTexture.forWorld((TextureManager)this.minecraft.getTextureManager(), (String)p_101703_.getLevelId());
            this.iconFile = p_101703_.getIcon();
            this.validateIconFile();
            this.loadIcon();
        }

        private void validateIconFile() {
            if (this.iconFile != null) {
                try {
                    BasicFileAttributes basicfileattributes = Files.readAttributes(this.iconFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (basicfileattributes.isSymbolicLink()) {
                        List<ForbiddenSymlinkInfo> list = this.minecraft.directoryValidator().validateSymlink(this.iconFile);
                        if (!list.isEmpty()) {
                            LOGGER.warn("{}", (Object)ContentValidationException.getMessage(this.iconFile, list));
                            this.iconFile = null;
                        } else {
                            basicfileattributes = Files.readAttributes(this.iconFile, BasicFileAttributes.class, new LinkOption[0]);
                        }
                    }
                    if (!basicfileattributes.isRegularFile()) {
                        this.iconFile = null;
                    }
                }
                catch (NoSuchFileException nosuchfileexception) {
                    this.iconFile = null;
                }
                catch (IOException ioexception) {
                    LOGGER.error("could not validate symlink", (Throwable)ioexception);
                    this.iconFile = null;
                }
            }
        }

        public Component getNarration() {
            MutableComponent component = Component.translatable("narrator.select.world_info", this.summary.getLevelName(), Component.translationArg(new Date(this.summary.getLastPlayed())), this.summary.getInfo());
            if (this.summary.isLocked()) {
                component = CommonComponents.joinForNarration(component, WORLD_LOCKED_TOOLTIP);
            }
            if (this.summary.isExperimental()) {
                component = CommonComponents.joinForNarration(component, WORLD_EXPERIMENTAL);
            }
            return Component.translatable("narrator.select", component);
        }

        public void render(GuiGraphics p_281612_, int p_281353_, int p_283181_, int p_282820_, int p_282420_, int p_281855_, int p_283204_, int p_283025_, boolean p_283396_, float p_282938_) {
            Object s = this.summary.getLevelName();
            Object s1 = this.summary.getLevelId();
            long i = this.summary.getLastPlayed();
            if (i != -1L) {
                s1 = (String)s1 + " (" + DATE_FORMAT.format(Instant.ofEpochMilli(i)) + ")";
            }
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = I18n.get("selectWorld.world", new Object[0]) + " " + (p_281353_ + 1);
            }
            Component component = this.summary.getInfo();
            p_281612_.drawString(this.minecraft.font, (String)s, p_282820_ + 32 + 3, p_283181_ + 1, -1);
            p_281612_.drawString(this.minecraft.font, (String)s1, p_282820_ + 32 + 3, p_283181_ + 9 + 3, -8355712);
            p_281612_.drawString(this.minecraft.font, component, p_282820_ + 32 + 3, p_283181_ + 9 + 9 + 3, -8355712);
            p_281612_.blit(RenderPipelines.GUI_TEXTURED, this.icon.textureLocation(), p_282820_, p_283181_, 0.0f, 0.0f, 32, 32, 32, 32);
            this.renderExperimentalWarning(p_281612_, p_283204_, p_283025_, p_283181_, p_282820_);
            if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() || p_283396_) {
                ResourceLocation resourcelocation3;
                p_281612_.fill(p_282820_, p_283181_, p_282820_ + 32, p_283181_ + 32, -1601138544);
                int j = p_283204_ - p_282820_;
                boolean flag = j < 32;
                ResourceLocation resourcelocation = flag ? JOIN_HIGHLIGHTED_SPRITE : JOIN_SPRITE;
                ResourceLocation resourcelocation1 = flag ? WARNING_HIGHLIGHTED_SPRITE : WARNING_SPRITE;
                ResourceLocation resourcelocation2 = flag ? ERROR_HIGHLIGHTED_SPRITE : ERROR_SPRITE;
                ResourceLocation resourceLocation = resourcelocation3 = flag ? MARKED_JOIN_HIGHLIGHTED_SPRITE : MARKED_JOIN_SPRITE;
                if (this.summary instanceof LevelSummary.SymlinkLevelSummary || this.summary instanceof LevelSummary.CorruptedLevelSummary) {
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, p_282820_, p_283181_, 32, 32);
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation3, p_282820_, p_283181_, 32, 32);
                    return;
                }
                if (this.summary.isLocked()) {
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, p_282820_, p_283181_, 32, 32);
                    if (flag) {
                        p_281612_.setTooltipForNextFrame(this.minecraft.font.split(WORLD_LOCKED_TOOLTIP, 175), p_283204_, p_283025_);
                    }
                } else if (this.summary.requiresManualConversion()) {
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, p_282820_, p_283181_, 32, 32);
                    if (flag) {
                        p_281612_.setTooltipForNextFrame(this.minecraft.font.split(WORLD_REQUIRES_CONVERSION, 175), p_283204_, p_283025_);
                    }
                } else if (!this.summary.isCompatible()) {
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, p_282820_, p_283181_, 32, 32);
                    if (flag) {
                        p_281612_.setTooltipForNextFrame(this.minecraft.font.split(INCOMPATIBLE_VERSION_TOOLTIP, 175), p_283204_, p_283025_);
                    }
                } else if (this.summary.shouldBackup()) {
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation3, p_282820_, p_283181_, 32, 32);
                    if (this.summary.isDowngrade()) {
                        p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, p_282820_, p_283181_, 32, 32);
                        if (flag) {
                            p_281612_.setTooltipForNextFrame((List<FormattedCharSequence>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.getVisualOrderText(), (Object)FROM_NEWER_TOOLTIP_2.getVisualOrderText()), p_283204_, p_283025_);
                        }
                    } else if (!SharedConstants.getCurrentVersion().stable()) {
                        p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation1, p_282820_, p_283181_, 32, 32);
                        if (flag) {
                            p_281612_.setTooltipForNextFrame((List<FormattedCharSequence>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.getVisualOrderText(), (Object)SNAPSHOT_TOOLTIP_2.getVisualOrderText()), p_283204_, p_283025_);
                        }
                    }
                } else {
                    p_281612_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation, p_282820_, p_283181_, 32, 32);
                }
            }
        }

        private void renderExperimentalWarning(GuiGraphics guiGraphics, int mouseX, int mouseY, int top, int left) {
            if (this.summary.isLifecycleExperimental()) {
                int leftStart = left + WorldSelectionList.this.getRowWidth();
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, FORGE_EXPERIMENTAL_WARNING_ICON, leftStart - 36, top, 0.0f, 0.0f, 32, 32, 32, 32);
                if (WorldSelectionList.this.getEntryAtPosition(mouseX, mouseY) == this && mouseX > leftStart - 36 && mouseX < leftStart) {
                    Font font = Minecraft.getInstance().font;
                    List<FormattedCharSequence> tooltip = font.split(Component.translatable("forge.experimentalsettings.tooltip"), 200);
                    guiGraphics.setTooltipForNextFrame(font, tooltip, mouseX, mouseY);
                }
            }
        }

        public boolean mouseClicked(double p_101706_, double p_101707_, int p_101708_) {
            if (!this.summary.primaryActionActive()) {
                return true;
            }
            WorldSelectionList.this.setSelected(this);
            if (!(p_101706_ - (double)WorldSelectionList.this.getRowLeft() <= 32.0) && Util.getMillis() - this.lastClickTime >= 250L) {
                this.lastClickTime = Util.getMillis();
                return super.mouseClicked(p_101706_, p_101707_, p_101708_);
            }
            if (this.canJoin()) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.joinWorld();
            }
            return true;
        }

        public boolean canJoin() {
            return this.summary.primaryActionActive();
        }

        public void joinWorld() {
            if (this.summary.primaryActionActive()) {
                if (this.summary instanceof LevelSummary.SymlinkLevelSummary) {
                    this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen((Screen)this.screen)));
                } else {
                    this.minecraft.createWorldOpenFlows().openWorld(this.summary.getLevelId(), () -> {
                        WorldSelectionList.this.reloadWorldList();
                        this.minecraft.setScreen((Screen)this.screen);
                    });
                }
            }
        }

        public void deleteWorld() {
            this.minecraft.setScreen((Screen)new ConfirmScreen(p_170322_ -> {
                if (p_170322_) {
                    this.minecraft.setScreen((Screen)new ProgressScreen(true));
                    this.doDeleteWorld();
                }
                this.minecraft.setScreen((Screen)this.screen);
            }, (Component)Component.translatable("selectWorld.deleteQuestion"), (Component)Component.translatable("selectWorld.deleteWarning", this.summary.getLevelName()), (Component)Component.translatable("selectWorld.deleteButton"), CommonComponents.GUI_CANCEL));
        }

        public void doDeleteWorld() {
            LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
            String s = this.summary.getLevelId();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.createAccess(s);){
                levelstoragesource$levelstorageaccess.deleteLevel();
            }
            catch (IOException ioexception) {
                SystemToast.onWorldDeleteFailure((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to delete world {}", (Object)s, (Object)ioexception);
            }
            WorldSelectionList.this.reloadWorldList();
        }

        public void editWorld() {
            EditWorldScreen editworldscreen;
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess;
            this.queueLoadScreen();
            String s = this.summary.getLevelId();
            try {
                levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().validateAndCreateAccess(s);
            }
            catch (IOException ioexception1) {
                SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to access level {}", (Object)s, (Object)ioexception1);
                WorldSelectionList.this.reloadWorldList();
                return;
            }
            catch (ContentValidationException contentvalidationexception) {
                LOGGER.warn("{}", (Object)contentvalidationexception.getMessage());
                this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen((Screen)this.screen)));
                return;
            }
            try {
                editworldscreen = EditWorldScreen.create((Minecraft)this.minecraft, (LevelStorageSource.LevelStorageAccess)levelstoragesource$levelstorageaccess, p_308276_ -> {
                    levelstoragesource$levelstorageaccess.safeClose();
                    if (p_308276_) {
                        WorldSelectionList.this.reloadWorldList();
                    }
                    this.minecraft.setScreen((Screen)this.screen);
                });
            }
            catch (IOException | NbtException | ReportedNbtException ioexception) {
                levelstoragesource$levelstorageaccess.safeClose();
                SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to load world data {}", (Object)s, (Object)ioexception);
                WorldSelectionList.this.reloadWorldList();
                return;
            }
            this.minecraft.setScreen((Screen)editworldscreen);
        }

        public void recreateWorld() {
            this.queueLoadScreen();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().validateAndCreateAccess(this.summary.getLevelId());){
                Pair<LevelSettings, WorldCreationContext> pair = this.minecraft.createWorldOpenFlows().recreateWorldData(levelstoragesource$levelstorageaccess);
                LevelSettings levelsettings = (LevelSettings)pair.getFirst();
                WorldCreationContext worldcreationcontext = (WorldCreationContext)pair.getSecond();
                Path path = CreateWorldScreen.createTempDataPackDirFromExistingWorld(levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.DATAPACK_DIR), this.minecraft);
                worldcreationcontext.validate();
                if (worldcreationcontext.options().isOldCustomizedWorld()) {
                    this.minecraft.setScreen((Screen)new ConfirmScreen(p_275882_ -> this.minecraft.setScreen(p_275882_ ? CreateWorldScreen.createFromExisting(this.minecraft, (Screen)this.screen, levelsettings, worldcreationcontext, path) : this.screen), (Component)Component.translatable("selectWorld.recreate.customized.title"), (Component)Component.translatable("selectWorld.recreate.customized.text"), CommonComponents.GUI_PROCEED, CommonComponents.GUI_CANCEL));
                } else {
                    this.minecraft.setScreen(CreateWorldScreen.createFromExisting(this.minecraft, (Screen)this.screen, levelsettings, worldcreationcontext, path));
                }
            }
            catch (ContentValidationException contentvalidationexception) {
                LOGGER.warn("{}", (Object)contentvalidationexception.getMessage());
                this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen((Screen)this.screen)));
            }
            catch (Exception exception) {
                LOGGER.error("Unable to recreate world", (Throwable)exception);
                this.minecraft.setScreen((Screen)new AlertScreen(() -> this.minecraft.setScreen((Screen)this.screen), (Component)Component.translatable("selectWorld.recreate.error.title"), (Component)Component.translatable("selectWorld.recreate.error.text")));
            }
        }

        private void queueLoadScreen() {
            this.minecraft.forceSetScreen((Screen)new GenericMessageScreen((Component)Component.translatable("selectWorld.data_read")));
        }

        private void loadIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && Files.isRegularFile(this.iconFile, new LinkOption[0]);
            if (flag) {
                try (InputStream inputstream = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                    this.icon.upload(NativeImage.read((InputStream)inputstream));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for world {}", (Object)this.summary.getLevelId(), (Object)throwable);
                    this.iconFile = null;
                }
            } else {
                this.icon.clear();
            }
        }

        @Override
        public void close() {
            this.icon.close();
        }

        public String getLevelName() {
            return this.summary.getLevelName();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }
}

