/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.RenderSectionRegion;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class SectionCompiler {
    private final BlockRenderDispatcher blockRenderer;
    private final BlockEntityRenderDispatcher blockEntityRenderer;

    public SectionCompiler(BlockRenderDispatcher p_344503_, BlockEntityRenderDispatcher p_345164_) {
        this.blockRenderer = p_344503_;
        this.blockEntityRenderer = p_345164_;
    }

    public Results compile(SectionPos p_344383_, RenderSectionRegion p_409909_, VertexSorting p_342522_, SectionBufferBuilderPack p_343546_) {
        Map modelDataMap = Minecraft.getInstance().level.getModelDataManager().getAt(p_344383_);
        Results sectioncompiler$results = new Results();
        BlockPos blockpos = p_344383_.origin();
        BlockPos blockpos1 = blockpos.offset(15, 15, 15);
        VisGraph visgraph = new VisGraph();
        PoseStack posestack = new PoseStack();
        ModelBlockRenderer.enableCaching();
        EnumMap<ChunkSectionLayer, BufferBuilder> map = new EnumMap<ChunkSectionLayer, BufferBuilder>(ChunkSectionLayer.class);
        RandomSource randomsource = RandomSource.create();
        ObjectArrayList list = new ObjectArrayList();
        for (BlockPos blockPos : BlockPos.betweenClosed(blockpos, blockpos1)) {
            FluidState fluidstate;
            BlockEntity blockentity;
            BlockState blockstate = p_409909_.getBlockState(blockPos);
            if (blockstate.isSolidRender()) {
                visgraph.setOpaque(blockPos);
            }
            if (blockstate.hasBlockEntity() && (blockentity = p_409909_.getBlockEntity(blockPos)) != null) {
                this.handleBlockEntity(sectioncompiler$results, blockentity);
            }
            if (!(fluidstate = blockstate.getFluidState()).isEmpty()) {
                ChunkSectionLayer chunksectionlayer = ItemBlockRenderTypes.getRenderLayer(fluidstate);
                BufferBuilder bufferbuilder = this.getOrBeginLayer(map, p_343546_, chunksectionlayer);
                this.blockRenderer.renderLiquid(blockPos, p_409909_, (VertexConsumer)bufferbuilder, blockstate, fluidstate);
            }
            if (blockstate.getRenderShape() != RenderShape.MODEL) continue;
            BlockStateModel model = this.blockRenderer.getBlockModel(blockstate);
            ModelData data = modelDataMap.getOrDefault(blockPos, ModelData.EMPTY);
            data = model.getModelData(p_409909_, blockPos, blockstate, data);
            randomsource.setSeed(blockstate.getSeed(blockPos));
            for (ChunkSectionLayer chunksectionlayer2 : model.getRenderTypes(blockstate, randomsource, data)) {
                BufferBuilder bufferbuilder1 = this.getOrBeginLayer(map, p_343546_, chunksectionlayer2);
                randomsource.setSeed(blockstate.getSeed(blockPos));
                model.collectParts(randomsource, (List)list, data, chunksectionlayer2);
                posestack.pushPose();
                posestack.translate(SectionPos.sectionRelative(blockPos.getX()), SectionPos.sectionRelative(blockPos.getY()), SectionPos.sectionRelative(blockPos.getZ()));
                this.blockRenderer.renderBatched(blockstate, blockPos, p_409909_, posestack, (VertexConsumer)bufferbuilder1, true, (List<BlockModelPart>)list);
                posestack.popPose();
                list.clear();
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ChunkSectionLayer chunksectionlayer1 = (ChunkSectionLayer)entry.getKey();
            MeshData meshdata = ((BufferBuilder)entry.getValue()).build();
            if (meshdata == null) continue;
            if (chunksectionlayer1 == ChunkSectionLayer.TRANSLUCENT) {
                sectioncompiler$results.transparencyState = meshdata.sortQuads(p_343546_.buffer(chunksectionlayer1), p_342522_);
            }
            sectioncompiler$results.renderedLayers.put(chunksectionlayer1, meshdata);
        }
        ModelBlockRenderer.clearCache();
        sectioncompiler$results.visibilitySet = visgraph.resolve();
        return sectioncompiler$results;
    }

    private BufferBuilder getOrBeginLayer(Map<ChunkSectionLayer, BufferBuilder> p_344204_, SectionBufferBuilderPack p_344936_, ChunkSectionLayer p_408915_) {
        BufferBuilder bufferbuilder = p_344204_.get(p_408915_);
        if (bufferbuilder == null) {
            ByteBufferBuilder bytebufferbuilder = p_344936_.buffer(p_408915_);
            bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            p_344204_.put(p_408915_, bufferbuilder);
        }
        return bufferbuilder;
    }

    private <E extends BlockEntity> void handleBlockEntity(Results p_343713_, E p_343478_) {
        BlockEntityRenderer blockentityrenderer = this.blockEntityRenderer.getRenderer(p_343478_);
        if (blockentityrenderer != null && !blockentityrenderer.shouldRenderOffScreen()) {
            p_343713_.blockEntities.add(p_343478_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Results {
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Map<ChunkSectionLayer, MeshData> renderedLayers = new EnumMap<ChunkSectionLayer, MeshData>(ChunkSectionLayer.class);
        public VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        public MeshData.SortState transparencyState;

        public void release() {
            this.renderedLayers.values().forEach(MeshData::close);
        }
    }
}

