/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.util.HasResult;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ScreenEvent
extends MutableEvent {
    public static final EventBus<ScreenEvent> BUS = EventBus.create(ScreenEvent.class);
    private final Screen screen;

    @ApiStatus.Internal
    protected ScreenEvent(Screen screen) {
        this.screen = Objects.requireNonNull(screen);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public static final class Closing
    extends ScreenEvent {
        public static final EventBus<Closing> BUS = EventBus.create(Closing.class);

        @ApiStatus.Internal
        public Closing(Screen screen) {
            super(screen);
        }
    }

    public static final class Opening
    extends ScreenEvent
    implements Cancellable {
        public static final CancellableEventBus<Opening> BUS = CancellableEventBus.create(Opening.class);
        @Nullable
        private final Screen currentScreen;
        private Screen newScreen;

        @ApiStatus.Internal
        public Opening(@Nullable Screen currentScreen, Screen screen) {
            super(screen);
            this.currentScreen = currentScreen;
            this.newScreen = screen;
        }

        @Nullable
        public Screen getCurrentScreen() {
            return this.currentScreen;
        }

        @Nullable
        public Screen getNewScreen() {
            return this.newScreen;
        }

        public void setNewScreen(Screen newScreen) {
            this.newScreen = newScreen;
        }
    }

    public static sealed class CharacterTyped
    extends ScreenEvent {
        private final char codePoint;
        private final int modifiers;

        @ApiStatus.Internal
        public CharacterTyped(Screen screen, char codePoint, int modifiers) {
            super(screen);
            this.codePoint = codePoint;
            this.modifiers = modifiers;
        }

        public char getCodePoint() {
            return this.codePoint;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public static final class Post
        extends CharacterTyped {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, char codePoint, int modifiers) {
                super(screen, codePoint, modifiers);
            }
        }

        public static final class Pre
        extends CharacterTyped
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, char codePoint, int modifiers) {
                super(screen, codePoint, modifiers);
            }
        }
    }

    public static abstract sealed class KeyReleased
    extends KeyInput {
        @ApiStatus.Internal
        public KeyReleased(Screen screen, int keyCode, int scanCode, int modifiers) {
            super(screen, keyCode, scanCode, modifiers);
        }

        public static final class Post
        extends KeyReleased
        implements Cancellable {
            public static final CancellableEventBus<Post> BUS = CancellableEventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }

        public static final class Pre
        extends KeyReleased
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }
    }

    public static abstract sealed class KeyPressed
    extends KeyInput {
        @ApiStatus.Internal
        public KeyPressed(Screen screen, int keyCode, int scanCode, int modifiers) {
            super(screen, keyCode, scanCode, modifiers);
        }

        public static final class Post
        extends KeyPressed
        implements Cancellable {
            public static final CancellableEventBus<Post> BUS = CancellableEventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }

        public static final class Pre
        extends KeyPressed
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }
    }

    private static abstract sealed class KeyInput
    extends ScreenEvent
    permits KeyPressed, KeyReleased {
        private final int keyCode;
        private final int scanCode;
        private final int modifiers;

        @ApiStatus.Internal
        protected KeyInput(Screen screen, int keyCode, int scanCode, int modifiers) {
            super(screen);
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.modifiers = modifiers;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getScanCode() {
            return this.scanCode;
        }

        public int getModifiers() {
            return this.modifiers;
        }
    }

    public static abstract sealed class MouseScrolled
    extends MouseInput {
        private final double deltaX;
        private final double deltaY;

        @ApiStatus.Internal
        public MouseScrolled(Screen screen, double mouseX, double mouseY, double deltaX, double deltaY) {
            super(screen, mouseX, mouseY);
            this.deltaX = deltaX;
            this.deltaY = deltaY;
        }

        public double getDeltaX() {
            return this.deltaX;
        }

        public double getDeltaY() {
            return this.deltaY;
        }

        public static final class Post
        extends MouseScrolled {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, double mouseX, double mouseY, double deltaX, double deltaY) {
                super(screen, mouseX, mouseY, deltaX, deltaY);
            }
        }

        public static final class Pre
        extends MouseScrolled
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, double mouseX, double mouseY, double deltaX, double deltaY) {
                super(screen, mouseX, mouseY, deltaX, deltaY);
            }
        }
    }

    public static abstract sealed class MouseDragged
    extends MouseInput {
        private final int mouseButton;
        private final double dragX;
        private final double dragY;

        @ApiStatus.Internal
        public MouseDragged(Screen screen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
            super(screen, mouseX, mouseY);
            this.mouseButton = mouseButton;
            this.dragX = dragX;
            this.dragY = dragY;
        }

        public int getMouseButton() {
            return this.mouseButton;
        }

        public double getDragX() {
            return this.dragX;
        }

        public double getDragY() {
            return this.dragY;
        }

        public static final class Post
        extends MouseDragged {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
                super(screen, mouseX, mouseY, mouseButton, dragX, dragY);
            }
        }

        public static final class Pre
        extends MouseDragged
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
                super(screen, mouseX, mouseY, mouseButton, dragX, dragY);
            }
        }
    }

    public static abstract sealed class MouseButtonReleased
    extends MouseInput {
        private final int button;

        @ApiStatus.Internal
        public MouseButtonReleased(Screen screen, double mouseX, double mouseY, int button) {
            super(screen, mouseX, mouseY);
            this.button = button;
        }

        public int getButton() {
            return this.button;
        }

        public static final class Post
        extends MouseButtonReleased
        implements HasResult {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
            private final boolean handled;
            private Result result = Result.DEFAULT;

            @ApiStatus.Internal
            public Post(Screen screen, double mouseX, double mouseY, int button, boolean handled) {
                super(screen, mouseX, mouseY, button);
                this.handled = handled;
            }

            public boolean wasHandled() {
                return this.handled;
            }

            @Override
            public Result getResult() {
                return this.result;
            }

            @Override
            public void setResult(Result result) {
                this.result = result;
            }
        }

        public static final class Pre
        extends MouseButtonReleased
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, double mouseX, double mouseY, int button) {
                super(screen, mouseX, mouseY, button);
            }
        }
    }

    public static abstract sealed class MouseButtonPressed
    extends MouseInput {
        private final int button;

        @ApiStatus.Internal
        public MouseButtonPressed(Screen screen, double mouseX, double mouseY, int button) {
            super(screen, mouseX, mouseY);
            this.button = button;
        }

        public int getButton() {
            return this.button;
        }

        public static final class Post
        extends MouseButtonPressed
        implements HasResult {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);
            private final boolean handled;
            private Result result = Result.DEFAULT;

            @ApiStatus.Internal
            public Post(Screen screen, double mouseX, double mouseY, int button, boolean handled) {
                super(screen, mouseX, mouseY, button);
                this.handled = handled;
            }

            public boolean wasHandled() {
                return this.handled;
            }

            @Override
            public Result getResult() {
                return this.result;
            }

            @Override
            public void setResult(Result result) {
                this.result = result;
            }
        }

        public static final class Pre
        extends MouseButtonPressed
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, double mouseX, double mouseY, int button) {
                super(screen, mouseX, mouseY, button);
            }
        }
    }

    private static abstract sealed class MouseInput
    extends ScreenEvent
    permits MouseButtonPressed, MouseButtonReleased, MouseDragged, MouseScrolled {
        private final double mouseX;
        private final double mouseY;

        @ApiStatus.Internal
        protected MouseInput(Screen screen, double mouseX, double mouseY) {
            super(screen);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public double getMouseX() {
            return this.mouseX;
        }

        public double getMouseY() {
            return this.mouseY;
        }
    }

    public static final class RenderInventoryMobEffects
    extends ScreenEvent
    implements Cancellable {
        public static final CancellableEventBus<RenderInventoryMobEffects> BUS = CancellableEventBus.create(RenderInventoryMobEffects.class);
        private final int availableSpace;
        private boolean compact;
        private int horizontalOffset;

        @ApiStatus.Internal
        public RenderInventoryMobEffects(Screen screen, int availableSpace, boolean compact, int horizontalOffset) {
            super(screen);
            this.availableSpace = availableSpace;
            this.compact = compact;
            this.horizontalOffset = horizontalOffset;
        }

        public int getAvailableSpace() {
            return this.availableSpace;
        }

        public boolean isCompact() {
            return this.compact;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public void setHorizontalOffset(int offset) {
            this.horizontalOffset = offset;
        }

        public void addHorizontalOffset(int offset) {
            this.horizontalOffset += offset;
        }

        public void setCompact(boolean compact) {
            this.compact = compact;
        }
    }

    public static final class BackgroundRendered
    extends ScreenEvent {
        public static final EventBus<BackgroundRendered> BUS = EventBus.create(BackgroundRendered.class);
        private final GuiGraphics guiGraphics;

        @ApiStatus.Internal
        public BackgroundRendered(Screen screen, GuiGraphics guiGraphics) {
            super(screen);
            this.guiGraphics = guiGraphics;
        }

        public GuiGraphics getGuiGraphics() {
            return this.guiGraphics;
        }
    }

    public static abstract sealed class Render
    extends ScreenEvent {
        private final GuiGraphics guiGraphics;
        private final int mouseX;
        private final int mouseY;
        private final float partialTick;

        @ApiStatus.Internal
        protected Render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super(screen);
            this.guiGraphics = guiGraphics;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.partialTick = partialTick;
        }

        public GuiGraphics getGuiGraphics() {
            return this.guiGraphics;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getPartialTick() {
            return this.partialTick;
        }

        public static final class Post
        extends Render {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super(screen, guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public static final class Pre
        extends Render
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super(screen, guiGraphics, mouseX, mouseY, partialTick);
            }
        }
    }

    public static abstract sealed class Init
    extends ScreenEvent {
        private final Consumer<GuiEventListener> add;
        private final Consumer<GuiEventListener> remove;
        private final List<GuiEventListener> listenerList;

        @ApiStatus.Internal
        protected Init(Screen screen, List<GuiEventListener> listenerList, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
            super(screen);
            this.listenerList = Collections.unmodifiableList(listenerList);
            this.add = add;
            this.remove = remove;
        }

        public List<GuiEventListener> getListenersList() {
            return this.listenerList;
        }

        public void addListener(GuiEventListener listener) {
            this.add.accept(listener);
        }

        public void removeListener(GuiEventListener listener) {
            this.remove.accept(listener);
        }

        public static final class Post
        extends Init {
            public static final EventBus<Post> BUS = EventBus.create(Post.class);

            @ApiStatus.Internal
            public Post(Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
                super(screen, list, add, remove);
            }
        }

        public static final class Pre
        extends Init
        implements Cancellable {
            public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);

            @ApiStatus.Internal
            public Pre(Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
                super(screen, list, add, remove);
            }
        }
    }
}

