/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector4f;

public abstract sealed class ViewportEvent
extends MutableEvent
implements InheritableEvent {
    public static final EventBus<ViewportEvent> BUS = EventBus.create(ViewportEvent.class);
    private final GameRenderer renderer;
    private final Camera camera;
    private final double partialTick;

    @ApiStatus.Internal
    public ViewportEvent(GameRenderer renderer, Camera camera, double partialTick) {
        this.renderer = renderer;
        this.camera = camera;
        this.partialTick = partialTick;
    }

    public GameRenderer getRenderer() {
        return this.renderer;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public double getPartialTick() {
        return this.partialTick;
    }

    public static final class ComputeFov
    extends ViewportEvent {
        public static final EventBus<ComputeFov> BUS = EventBus.create(ComputeFov.class);
        private final boolean usedConfiguredFov;
        private float fov;

        @ApiStatus.Internal
        public ComputeFov(GameRenderer renderer, Camera camera, double renderPartialTicks, float fov, boolean usedConfiguredFov) {
            super(renderer, camera, renderPartialTicks);
            this.usedConfiguredFov = usedConfiguredFov;
            this.setFOV(fov);
        }

        public float getFOV() {
            return this.fov;
        }

        public void setFOV(float fov) {
            this.fov = fov;
        }

        public boolean usedConfiguredFov() {
            return this.usedConfiguredFov;
        }
    }

    public static final class ComputeCameraAngles
    extends ViewportEvent {
        public static final EventBus<ComputeCameraAngles> BUS = EventBus.create(ComputeCameraAngles.class);
        private float yaw;
        private float pitch;
        private float roll;

        @ApiStatus.Internal
        public ComputeCameraAngles(GameRenderer renderer, Camera camera, double renderPartialTicks, float yaw, float pitch, float roll) {
            super(renderer, camera, renderPartialTicks);
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setRoll(roll);
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }

    public static final class ComputeFogColor
    extends ViewportEvent {
        public static final EventBus<ComputeFogColor> BUS = EventBus.create(ComputeFogColor.class);
        private float red;
        private float green;
        private float blue;

        @ApiStatus.Internal
        public ComputeFogColor(Camera camera, float partialTicks, float red, float green, float blue) {
            super(Minecraft.getInstance().gameRenderer, camera, partialTicks);
            this.setRed(red);
            this.setGreen(green);
            this.setBlue(blue);
        }

        public float getRed() {
            return this.red;
        }

        public void setRed(float red) {
            this.red = red;
        }

        public float getGreen() {
            return this.green;
        }

        public void setGreen(float green) {
            this.green = green;
        }

        public float getBlue() {
            return this.blue;
        }

        public void setBlue(float blue) {
            this.blue = blue;
        }
    }

    public static final class RenderFog
    extends ViewportEvent
    implements Cancellable {
        public static final CancellableEventBus<RenderFog> BUS = CancellableEventBus.create(RenderFog.class);
        private final FogType type;
        private final FogData data;
        private final Vector4f color;

        @ApiStatus.Internal
        public RenderFog(FogType type, Camera camera, float partialTicks, FogData data, Vector4f color) {
            super(Minecraft.getInstance().gameRenderer, camera, partialTicks);
            this.type = type;
            this.data = data;
            this.color = color;
        }

        public FogData getData() {
            return this.data;
        }

        public Vector4f getColor() {
            return this.color;
        }

        public FogType getType() {
            return this.type;
        }

        public float getFarPlaneDistance() {
            return this.getData().renderDistanceEnd;
        }

        public float getNearPlaneDistance() {
            return this.getData().renderDistanceStart;
        }

        public void setFarPlaneDistance(float distance) {
            this.getData().renderDistanceEnd = distance;
        }

        public void setNearPlaneDistance(float distance) {
            this.getData().renderDistanceStart = distance;
        }

        public void scaleFarPlaneDistance(float factor) {
            this.getData().renderDistanceEnd *= factor;
        }

        public void scaleNearPlaneDistance(float factor) {
            this.getData().renderDistanceStart *= factor;
        }
    }
}

