/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicFluidContainerModel
implements UnbakedGeometry {
    private static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    private DynamicFluidContainerModel(Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(ChunkSectionLayer.TRANSLUCENT, unlit ? ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    private static Material getMaterial(ResourceLocation texture) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, texture);
    }

    public DynamicFluidContainerModel withFluid(Fluid newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity);
    }

    public QuadCollection bake(TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName name) {
        return this.bake(slots, baker, state, name, StandaloneGeometryBakingContext.INSTANCE);
    }

    public QuadCollection bake(TextureSlots textures, ModelBaker baker, ModelState state, ModelDebugName name, IGeometryBakingContext context) {
        List<BlockElement> unbaked;
        SimpleModelState transformedState;
        TextureAtlasSprite templateSprite;
        Material fluidMaskLocation = textures.getMaterial("fluid");
        Material stillMaterial = null;
        if (this.fluid != Fluids.EMPTY) {
            ResourceLocation stillTexture = IClientFluidTypeExtensions.of(this.fluid).getStillTexture();
            stillMaterial = DynamicFluidContainerModel.getMaterial(stillTexture);
        }
        SpriteGetter sprites = baker.sprites();
        TextureAtlasSprite baseSprite = sprites.resolveSlot(textures, "base", name);
        TextureAtlasSprite fluidSprite = stillMaterial == null ? null : sprites.get(stillMaterial, name);
        TextureAtlasSprite coverSprite = sprites.resolveSlot(textures, "cover", name);
        Transformation transformation = state.transformation();
        if (this.flipGas && this.fluid != Fluids.EMPTY && this.fluid.getFluidType().isLighterThanAir()) {
            transformation = transformation.compose(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null));
        }
        QuadCollection.Builder buf = new QuadCollection.Builder();
        if (baseSprite != null) {
            List<BlockElement> unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements(0, baseSprite.contents());
            UnbakedGeometryHelper.bakeElements(unbaked2, $ -> baseSprite, state, buf);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = sprites.get(fluidMaskLocation, name)) != null) {
            transformedState = new SimpleModelState(transformation.compose(FLUID_TRANSFORM));
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(1, templateSprite.contents());
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            IQuadTransformer transformer = emissive ? QuadTransformers.settingMaxEmissivity() : QuadTransformers.empty();
            UnbakedGeometryHelper.bakeElements(unbaked, $ -> fluidSprite, transformedState, transformer, buf);
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(transformation.compose(COVER_TRANSFORM));
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(2, coverSprite.contents());
                UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, (ModelState)transformedState, buf);
            }
        }
        return buf.build();
    }

    public static final class Loader
    implements IGeometryLoader {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public UnbakedGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ResourceLocation fluidName = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"fluid"));
            Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
            boolean flip = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new DynamicFluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity);
        }
    }
}

