/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraftforge.common.util.HasResult;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class MobSpawnEvent
extends EntityEvent {
    public static final EventBus<MobSpawnEvent> BUS = EventBus.create(MobSpawnEvent.class);
    private final ServerLevelAccessor level;
    private final double x;
    private final double y;
    private final double z;

    @ApiStatus.Internal
    protected MobSpawnEvent(Mob mob, ServerLevelAccessor level, double x, double y, double z) {
        super((Entity)mob);
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Mob getEntity() {
        return (Mob)super.getEntity();
    }

    public ServerLevelAccessor getLevel() {
        return this.level;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public static final class AllowDespawn
    extends MobSpawnEvent
    implements HasResult {
        public static final EventBus<AllowDespawn> BUS = EventBus.create(AllowDespawn.class);
        private Result result = Result.DEFAULT;

        public AllowDespawn(Mob mob, ServerLevelAccessor level) {
            super(mob, level, mob.getX(), mob.getY(), mob.getZ());
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        @Override
        public void setResult(Result result) {
            this.result = result;
        }
    }

    public static final class FinalizeSpawn
    extends MobSpawnEvent
    implements Cancellable {
        public static final CancellableEventBus<FinalizeSpawn> BUS = CancellableEventBus.create(FinalizeSpawn.class);
        private final EntitySpawnReason spawnReason;
        @Nullable
        private final BaseSpawner spawner;
        private DifficultyInstance difficulty;
        @Nullable
        private SpawnGroupData spawnData;
        @Nullable
        private ValueInput spawnTag;

        @ApiStatus.Internal
        public FinalizeSpawn(Mob entity, ServerLevelAccessor level, double x, double y, double z, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnData, @Nullable ValueInput spawnTag, @Nullable BaseSpawner spawner) {
            super(entity, level, x, y, z);
            this.difficulty = difficulty;
            this.spawnReason = spawnReason;
            this.spawnData = spawnData;
            this.spawnTag = spawnTag;
            this.spawner = spawner;
        }

        public DifficultyInstance getDifficulty() {
            return this.difficulty;
        }

        public void setDifficulty(DifficultyInstance inst) {
            this.difficulty = inst;
        }

        public EntitySpawnReason getSpawnReason() {
            return this.spawnReason;
        }

        @Nullable
        public SpawnGroupData getSpawnData() {
            return this.spawnData;
        }

        public void setSpawnData(@Nullable SpawnGroupData data) {
            this.spawnData = data;
        }

        @Nullable
        public ValueInput getSpawnTag() {
            return this.spawnTag;
        }

        public void setSpawnTag(@Nullable ValueInput tag) {
            this.spawnTag = tag;
        }

        @Nullable
        public BaseSpawner getSpawner() {
            return this.spawner;
        }

        public void setSpawnCancelled(boolean cancel) {
            this.getEntity().setSpawnCancelled(cancel);
        }

        public boolean isSpawnCancelled() {
            return this.getEntity().isSpawnCancelled();
        }
    }

    public static final class PositionCheck
    extends MobSpawnEvent
    implements HasResult {
        public static final EventBus<PositionCheck> BUS = EventBus.create(PositionCheck.class);
        @Nullable
        private final BaseSpawner spawner;
        private final EntitySpawnReason spawnReason;
        private Result result = Result.DEFAULT;

        public PositionCheck(Mob mob, ServerLevelAccessor level, EntitySpawnReason spawnReason, @Nullable BaseSpawner spawner) {
            super(mob, level, mob.getX(), mob.getY(), mob.getZ());
            this.spawnReason = spawnReason;
            this.spawner = spawner;
        }

        @Nullable
        public BaseSpawner getSpawner() {
            return this.spawner;
        }

        public EntitySpawnReason getSpawnReason() {
            return this.spawnReason;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        @Override
        public void setResult(Result result) {
            this.result = result;
        }
    }

    public static final class SpawnPlacementCheck
    extends MutableEvent
    implements HasResult {
        public static final EventBus<SpawnPlacementCheck> BUS = EventBus.create(SpawnPlacementCheck.class);
        private final EntityType<?> entityType;
        private final ServerLevelAccessor level;
        private final EntitySpawnReason spawnReason;
        private final BlockPos pos;
        private final RandomSource random;
        private final boolean defaultResult;
        private Result result = Result.DEFAULT;

        @ApiStatus.Internal
        public SpawnPlacementCheck(EntityType<?> entityType, ServerLevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random, boolean defaultResult) {
            this.entityType = entityType;
            this.level = level;
            this.spawnReason = spawnReason;
            this.pos = pos;
            this.random = random;
            this.defaultResult = defaultResult;
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }

        public ServerLevelAccessor getLevel() {
            return this.level;
        }

        public EntitySpawnReason getSpawnReason() {
            return this.spawnReason;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public RandomSource getRandom() {
            return this.random;
        }

        public boolean getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        @Override
        public void setResult(Result result) {
            this.result = result;
        }
    }
}

