/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldSelectionList
extends ObjectSelectionList<Entry> {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
    static final ResourceLocation ERROR_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/error_highlighted");
    static final ResourceLocation ERROR_SPRITE = ResourceLocation.withDefaultNamespace("world_list/error");
    static final ResourceLocation MARKED_JOIN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/marked_join_highlighted");
    static final ResourceLocation MARKED_JOIN_SPRITE = ResourceLocation.withDefaultNamespace("world_list/marked_join");
    static final ResourceLocation WARNING_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/warning_highlighted");
    static final ResourceLocation WARNING_SPRITE = ResourceLocation.withDefaultNamespace("world_list/warning");
    static final ResourceLocation JOIN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("world_list/join_highlighted");
    static final ResourceLocation JOIN_SPRITE = ResourceLocation.withDefaultNamespace("world_list/join");
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation FORGE_EXPERIMENTAL_WARNING_ICON = ResourceLocation.fromNamespaceAndPath("forge", "textures/gui/experimental_warning.png");
    static final Component FROM_NEWER_TOOLTIP_1 = Component.translatable("selectWorld.tooltip.fromNewerVersion1").withStyle(ChatFormatting.RED);
    static final Component FROM_NEWER_TOOLTIP_2 = Component.translatable("selectWorld.tooltip.fromNewerVersion2").withStyle(ChatFormatting.RED);
    static final Component SNAPSHOT_TOOLTIP_1 = Component.translatable("selectWorld.tooltip.snapshot1").withStyle(ChatFormatting.GOLD);
    static final Component SNAPSHOT_TOOLTIP_2 = Component.translatable("selectWorld.tooltip.snapshot2").withStyle(ChatFormatting.GOLD);
    static final Component WORLD_LOCKED_TOOLTIP = Component.translatable("selectWorld.locked").withStyle(ChatFormatting.RED);
    static final Component WORLD_REQUIRES_CONVERSION = Component.translatable("selectWorld.conversion.tooltip").withStyle(ChatFormatting.RED);
    static final Component INCOMPATIBLE_VERSION_TOOLTIP = Component.translatable("selectWorld.incompatible.tooltip").withStyle(ChatFormatting.RED);
    static final Component WORLD_EXPERIMENTAL = Component.translatable("selectWorld.experimental");
    private final Screen screen;
    private CompletableFuture<List<LevelSummary>> pendingLevels;
    @Nullable
    private List<LevelSummary> currentlyDisplayedLevels;
    private final LoadingHeader loadingHeader;
    final EntryType entryType;
    private String filter;
    private boolean hasPolled;
    @Nullable
    private final Consumer<LevelSummary> onEntrySelect;
    @Nullable
    final Consumer<WorldListEntry> onEntryInteract;

    WorldSelectionList(Screen p_422996_, Minecraft p_239541_, int p_239542_, int p_239543_, String p_239547_, @Nullable WorldSelectionList p_239548_, @Nullable Consumer<LevelSummary> p_431625_, @Nullable Consumer<WorldListEntry> p_430990_, EntryType p_424584_) {
        super(p_239541_, p_239542_, p_239543_, 0, 36);
        this.screen = p_422996_;
        this.loadingHeader = new LoadingHeader(p_239541_);
        this.filter = p_239547_;
        this.onEntrySelect = p_431625_;
        this.onEntryInteract = p_430990_;
        this.entryType = p_424584_;
        this.pendingLevels = p_239548_ != null ? p_239548_.pendingLevels : this.loadLevels();
        this.addEntry((AbstractSelectionList.Entry)this.loadingHeader);
        this.handleNewLevels(this.pollLevelsIgnoreErrors());
    }

    protected void clearEntries() {
        this.children().forEach(Entry::close);
        super.clearEntries();
    }

    @Nullable
    private List<LevelSummary> pollLevelsIgnoreErrors() {
        try {
            List<LevelSummary> list = this.pendingLevels.getNow(null);
            if (this.entryType == EntryType.UPLOAD_WORLD) {
                if (list == null || this.hasPolled) {
                    return null;
                }
                this.hasPolled = true;
                list = list.stream().filter(LevelSummary::canUpload).toList();
            }
            return list;
        }
        catch (CancellationException | CompletionException completionexception) {
            return null;
        }
    }

    public void reloadWorldList() {
        this.pendingLevels = this.loadLevels();
    }

    public void renderWidget(GuiGraphics p_310403_, int p_312182_, int p_312151_, float p_311062_) {
        List<LevelSummary> list = this.pollLevelsIgnoreErrors();
        if (list != this.currentlyDisplayedLevels) {
            this.handleNewLevels(list);
        }
        super.renderWidget(p_310403_, p_312182_, p_312151_, p_311062_);
    }

    private void handleNewLevels(@Nullable List<LevelSummary> p_239665_) {
        if (p_239665_ != null) {
            if (p_239665_.isEmpty()) {
                switch (this.entryType.ordinal()) {
                    case 0: {
                        CreateWorldScreen.openFresh(this.minecraft, () -> this.minecraft.setScreen(null));
                        break;
                    }
                    case 1: {
                        this.clearEntries();
                        this.addEntry((AbstractSelectionList.Entry)new NoWorldsEntry(Component.translatable("mco.upload.select.world.none"), this.screen.getFont()));
                    }
                }
            } else {
                this.fillLevels(this.filter, p_239665_);
                this.currentlyDisplayedLevels = p_239665_;
            }
        }
    }

    public void updateFilter(String p_239901_) {
        if (this.currentlyDisplayedLevels != null && !p_239901_.equals(this.filter)) {
            this.fillLevels(p_239901_, this.currentlyDisplayedLevels);
        }
        this.filter = p_239901_;
    }

    private CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates levelstoragesource$levelcandidates;
        try {
            levelstoragesource$levelcandidates = this.minecraft.getLevelSource().findLevelCandidates();
        }
        catch (LevelStorageException levelstorageexception) {
            LOGGER.error("Couldn't load level list", (Throwable)levelstorageexception);
            this.handleLevelLoadFailure(levelstorageexception.getMessageComponent());
            return CompletableFuture.completedFuture(List.of());
        }
        return this.minecraft.getLevelSource().loadLevelSummaries(levelstoragesource$levelcandidates).exceptionally(p_233202_ -> {
            this.minecraft.delayCrash(CrashReport.forThrowable(p_233202_, "Couldn't load level list"));
            return List.of();
        });
    }

    private void fillLevels(String p_233199_, List<LevelSummary> p_233200_) {
        ArrayList<WorldListEntry> list = new ArrayList<WorldListEntry>();
        Optional<WorldListEntry> optional = this.getSelectedOpt();
        WorldListEntry worldselectionlist$worldlistentry = null;
        for (LevelSummary levelsummary : p_233200_.stream().filter(p_420802_ -> this.filterAccepts(p_233199_.toLowerCase(Locale.ROOT), (LevelSummary)p_420802_)).toList()) {
            WorldListEntry worldselectionlist$worldlistentry1 = new WorldListEntry(this, levelsummary);
            if (optional.isPresent() && optional.get().getLevelSummary().getLevelId().equals(worldselectionlist$worldlistentry1.getLevelSummary().getLevelId())) {
                worldselectionlist$worldlistentry = worldselectionlist$worldlistentry1;
            }
            list.add(worldselectionlist$worldlistentry1);
        }
        this.removeEntries(this.children().stream().filter(p_420805_ -> !list.contains(p_420805_)).toList());
        list.forEach(p_420803_ -> {
            if (!this.children().contains(p_420803_)) {
                this.addEntry((AbstractSelectionList.Entry)p_420803_);
            }
        });
        this.setSelected(worldselectionlist$worldlistentry);
        this.notifyListUpdated();
    }

    private boolean filterAccepts(String p_233196_, LevelSummary p_233197_) {
        return p_233197_.getLevelName().toLowerCase(Locale.ROOT).contains(p_233196_) || p_233197_.getLevelId().toLowerCase(Locale.ROOT).contains(p_233196_);
    }

    private void notifyListUpdated() {
        this.refreshScrollAmount();
        this.screen.triggerImmediateNarration(true);
    }

    private void handleLevelLoadFailure(Component p_233212_) {
        this.minecraft.setScreen((Screen)new ErrorScreen((Component)Component.translatable("selectWorld.unable_to_load"), p_233212_));
    }

    public int getRowWidth() {
        return 270;
    }

    public void setSelected(@Nullable Entry p_233190_) {
        super.setSelected((AbstractSelectionList.Entry)p_233190_);
        if (this.onEntrySelect != null) {
            LevelSummary levelSummary;
            if (p_233190_ instanceof WorldListEntry) {
                WorldListEntry worldselectionlist$worldlistentry = (WorldListEntry)p_233190_;
                levelSummary = worldselectionlist$worldlistentry.summary;
            } else {
                levelSummary = null;
            }
            this.onEntrySelect.accept(levelSummary);
        }
    }

    public Optional<WorldListEntry> getSelectedOpt() {
        Optional<WorldListEntry> optional;
        Entry worldselectionlist$entry = (Entry)this.getSelected();
        if (worldselectionlist$entry instanceof WorldListEntry) {
            WorldListEntry worldselectionlist$worldlistentry = (WorldListEntry)worldselectionlist$entry;
            optional = Optional.of(worldselectionlist$worldlistentry);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void returnToScreen() {
        this.reloadWorldList();
        this.minecraft.setScreen(this.screen);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void updateWidgetNarration(NarrationElementOutput p_313204_) {
        if (this.children().contains(this.loadingHeader)) {
            this.loadingHeader.updateNarration(p_313204_);
        } else {
            super.updateWidgetNarration(p_313204_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private static final Component LOADING_LABEL = Component.translatable("selectWorld.loading_list");
        private final Minecraft minecraft;

        public LoadingHeader(Minecraft p_233222_) {
            this.minecraft = p_233222_;
        }

        public void renderContent(GuiGraphics p_423994_, int p_426960_, int p_429558_, boolean p_428179_, float p_431514_) {
            int i = (this.minecraft.screen.width - this.minecraft.font.width(LOADING_LABEL)) / 2;
            int j = this.getContentY() + (this.getContentHeight() - 9) / 2;
            p_423994_.drawString(this.minecraft.font, LOADING_LABEL, i, j, -1);
            String s = LoadingDotsText.get((long)Util.getMillis());
            int k = (this.minecraft.screen.width - this.minecraft.font.width(s)) / 2;
            int l = j + 9;
            p_423994_.drawString(this.minecraft.font, s, k, l, -8355712);
        }

        public Component getNarration() {
            return LOADING_LABEL;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EntryType {
        SINGLEPLAYER,
        UPLOAD_WORLD;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class NoWorldsEntry
    extends Entry {
        private final StringWidget stringWidget;

        public NoWorldsEntry(Component p_423669_, Font p_429287_) {
            this.stringWidget = new StringWidget(p_423669_, p_429287_);
        }

        public Component getNarration() {
            return this.stringWidget.getMessage();
        }

        public void renderContent(GuiGraphics p_430175_, int p_428503_, int p_424551_, boolean p_425538_, float p_429078_) {
            this.stringWidget.setPosition(this.getContentXMiddle() - this.stringWidget.getWidth() / 2, this.getContentYMiddle() - this.stringWidget.getHeight() / 2);
            this.stringWidget.render(p_430175_, p_428503_, p_424551_, p_429078_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class WorldListEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private final WorldSelectionList list;
        private final Minecraft minecraft;
        private final Screen screen;
        final LevelSummary summary;
        private final FaviconTexture icon;
        private final StringWidget worldNameText;
        private final StringWidget idAndLastPlayedText;
        private final StringWidget infoText;
        @Nullable
        private Path iconFile;

        public WorldListEntry(WorldSelectionList p_101701_, LevelSummary p_101703_) {
            this.list = p_101701_;
            this.minecraft = p_101701_.minecraft;
            this.screen = p_101701_.getScreen();
            this.summary = p_101703_;
            this.icon = FaviconTexture.forWorld((TextureManager)this.minecraft.getTextureManager(), (String)p_101703_.getLevelId());
            this.iconFile = p_101703_.getIcon();
            int i = p_101701_.getRowWidth() - this.getTextX() - 2;
            MutableComponent component = Component.literal(p_101703_.getLevelName());
            this.worldNameText = new StringWidget((Component)component, this.minecraft.font);
            this.worldNameText.setMaxWidth(i);
            if (this.minecraft.font.width(component) > i) {
                this.worldNameText.setTooltip(Tooltip.create((Component)component));
            }
            Object s = p_101703_.getLevelId();
            long j = p_101703_.getLastPlayed();
            if (j != -1L) {
                s = (String)s + " (" + DATE_FORMAT.format(Instant.ofEpochMilli(j)) + ")";
            }
            MutableComponent component1 = Component.literal((String)s);
            this.idAndLastPlayedText = new StringWidget((Component)component1, this.minecraft.font).setColor(-8355712);
            this.idAndLastPlayedText.setMaxWidth(i);
            if (this.minecraft.font.width((String)s) > i) {
                this.idAndLastPlayedText.setTooltip(Tooltip.create((Component)component1));
            }
            Component component2 = p_101703_.getInfo();
            this.infoText = new StringWidget(component2, this.minecraft.font).setColor(-8355712);
            this.infoText.setMaxWidth(i);
            if (this.minecraft.font.width(component2) > i) {
                this.infoText.setTooltip(Tooltip.create((Component)component2));
            }
            this.validateIconFile();
            this.loadIcon();
        }

        private void validateIconFile() {
            if (this.iconFile != null) {
                try {
                    BasicFileAttributes basicfileattributes = Files.readAttributes(this.iconFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (basicfileattributes.isSymbolicLink()) {
                        List<ForbiddenSymlinkInfo> list = this.minecraft.directoryValidator().validateSymlink(this.iconFile);
                        if (!list.isEmpty()) {
                            LOGGER.warn("{}", (Object)ContentValidationException.getMessage(this.iconFile, list));
                            this.iconFile = null;
                        } else {
                            basicfileattributes = Files.readAttributes(this.iconFile, BasicFileAttributes.class, new LinkOption[0]);
                        }
                    }
                    if (!basicfileattributes.isRegularFile()) {
                        this.iconFile = null;
                    }
                }
                catch (NoSuchFileException nosuchfileexception) {
                    this.iconFile = null;
                }
                catch (IOException ioexception) {
                    LOGGER.error("could not validate symlink", (Throwable)ioexception);
                    this.iconFile = null;
                }
            }
        }

        private void renderExperimentalWarning(GuiGraphics guiGraphics, int mouseX, int mouseY, int top, int left) {
            if (this.summary.isLifecycleExperimental()) {
                int leftStart = left + this.list.getRowWidth();
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, FORGE_EXPERIMENTAL_WARNING_ICON, leftStart - 36, top, 0.0f, 0.0f, 32, 32, 32, 32);
                if (this.list.getEntryAtPosition(mouseX, mouseY) == this && mouseX > leftStart - 36 && mouseX < leftStart) {
                    Font font = Minecraft.getInstance().font;
                    List<FormattedCharSequence> tooltip = font.split(Component.translatable("forge.experimentalsettings.tooltip"), 200);
                    guiGraphics.setTooltipForNextFrame(font, tooltip, mouseX, mouseY);
                }
            }
        }

        public Component getNarration() {
            MutableComponent component = Component.translatable("narrator.select.world_info", this.summary.getLevelName(), Component.translationArg(new Date(this.summary.getLastPlayed())), this.summary.getInfo());
            if (this.summary.isLocked()) {
                component = CommonComponents.joinForNarration(component, WORLD_LOCKED_TOOLTIP);
            }
            if (this.summary.isExperimental()) {
                component = CommonComponents.joinForNarration(component, WORLD_EXPERIMENTAL);
            }
            return Component.translatable("narrator.select", component);
        }

        public void renderContent(GuiGraphics p_424437_, int p_425443_, int p_425024_, boolean p_430261_, float p_424775_) {
            int i = this.getTextX();
            this.worldNameText.setPosition(i, this.getContentY() + 1);
            this.worldNameText.render(p_424437_, p_425443_, p_425024_, p_424775_);
            this.idAndLastPlayedText.setPosition(i, this.getContentY() + 9 + 3);
            this.idAndLastPlayedText.render(p_424437_, p_425443_, p_425024_, p_424775_);
            this.infoText.setPosition(i, this.getContentY() + 9 + 9 + 3);
            this.infoText.render(p_424437_, p_425443_, p_425024_, p_424775_);
            p_424437_.blit(RenderPipelines.GUI_TEXTURED, this.icon.textureLocation(), this.getContentX(), this.getContentY(), 0.0f, 0.0f, 32, 32, 32, 32);
            this.renderExperimentalWarning(p_424437_, p_425443_, p_425024_, this.getContentY(), this.getContentX());
            if (this.list.entryType == EntryType.SINGLEPLAYER && (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() || p_430261_)) {
                ResourceLocation resourcelocation3;
                p_424437_.fill(this.getContentX(), this.getContentY(), this.getContentX() + 32, this.getContentY() + 32, -1601138544);
                int j = p_425443_ - this.getContentX();
                boolean flag = j < 32;
                ResourceLocation resourcelocation = flag ? JOIN_HIGHLIGHTED_SPRITE : JOIN_SPRITE;
                ResourceLocation resourcelocation1 = flag ? WARNING_HIGHLIGHTED_SPRITE : WARNING_SPRITE;
                ResourceLocation resourcelocation2 = flag ? ERROR_HIGHLIGHTED_SPRITE : ERROR_SPRITE;
                ResourceLocation resourceLocation = resourcelocation3 = flag ? MARKED_JOIN_HIGHLIGHTED_SPRITE : MARKED_JOIN_SPRITE;
                if (this.summary instanceof LevelSummary.SymlinkLevelSummary || this.summary instanceof LevelSummary.CorruptedLevelSummary) {
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, this.getContentX(), this.getContentY(), 32, 32);
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation3, this.getContentX(), this.getContentY(), 32, 32);
                    return;
                }
                if (this.summary.isLocked()) {
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, this.getContentX(), this.getContentY(), 32, 32);
                    if (flag) {
                        p_424437_.setTooltipForNextFrame(this.minecraft.font.split(WORLD_LOCKED_TOOLTIP, 175), p_425443_, p_425024_);
                    }
                } else if (this.summary.requiresManualConversion()) {
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, this.getContentX(), this.getContentY(), 32, 32);
                    if (flag) {
                        p_424437_.setTooltipForNextFrame(this.minecraft.font.split(WORLD_REQUIRES_CONVERSION, 175), p_425443_, p_425024_);
                    }
                } else if (!this.summary.isCompatible()) {
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, this.getContentX(), this.getContentY(), 32, 32);
                    if (flag) {
                        p_424437_.setTooltipForNextFrame(this.minecraft.font.split(INCOMPATIBLE_VERSION_TOOLTIP, 175), p_425443_, p_425024_);
                    }
                } else if (this.summary.shouldBackup()) {
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation3, this.getContentX(), this.getContentY(), 32, 32);
                    if (this.summary.isDowngrade()) {
                        p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation2, this.getContentX(), this.getContentY(), 32, 32);
                        if (flag) {
                            p_424437_.setTooltipForNextFrame((List<FormattedCharSequence>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.getVisualOrderText(), (Object)FROM_NEWER_TOOLTIP_2.getVisualOrderText()), p_425443_, p_425024_);
                        }
                    } else if (!SharedConstants.getCurrentVersion().stable()) {
                        p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation1, this.getContentX(), this.getContentY(), 32, 32);
                        if (flag) {
                            p_424437_.setTooltipForNextFrame((List<FormattedCharSequence>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.getVisualOrderText(), (Object)SNAPSHOT_TOOLTIP_2.getVisualOrderText()), p_425443_, p_425024_);
                        }
                    }
                } else {
                    p_424437_.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation, this.getContentX(), this.getContentY(), 32, 32);
                }
            }
        }

        private int getTextX() {
            return this.getContentX() + 32 + 3;
        }

        public boolean mouseClicked(MouseButtonEvent p_423032_, boolean p_423860_) {
            if (this.canInteract() && (p_423860_ || p_423032_.x() - (double)this.list.getRowLeft() <= 32.0 && this.list.entryType == EntryType.SINGLEPLAYER)) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                Consumer<WorldListEntry> consumer = this.list.onEntryInteract;
                if (consumer != null) {
                    consumer.accept(this);
                    return true;
                }
            }
            return super.mouseClicked(p_423032_, p_423860_);
        }

        public boolean keyPressed(KeyEvent p_428804_) {
            if (p_428804_.isSelection() && this.canInteract()) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                Consumer<WorldListEntry> consumer = this.list.onEntryInteract;
                if (consumer != null) {
                    consumer.accept(this);
                    return true;
                }
            }
            return super.keyPressed(p_428804_);
        }

        public boolean canInteract() {
            return this.summary.primaryActionActive() || this.list.entryType == EntryType.UPLOAD_WORLD;
        }

        public void joinWorld() {
            if (this.summary.primaryActionActive()) {
                if (this.summary instanceof LevelSummary.SymlinkLevelSummary) {
                    this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen(this.screen)));
                } else {
                    this.minecraft.createWorldOpenFlows().openWorld(this.summary.getLevelId(), this.list::returnToScreen);
                }
            }
        }

        public void deleteWorld() {
            this.minecraft.setScreen((Screen)new ConfirmScreen(p_420806_ -> {
                if (p_420806_) {
                    this.minecraft.setScreen((Screen)new ProgressScreen(true));
                    this.doDeleteWorld();
                }
                this.list.returnToScreen();
            }, (Component)Component.translatable("selectWorld.deleteQuestion"), (Component)Component.translatable("selectWorld.deleteWarning", this.summary.getLevelName()), (Component)Component.translatable("selectWorld.deleteButton"), CommonComponents.GUI_CANCEL));
        }

        public void doDeleteWorld() {
            LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
            String s = this.summary.getLevelId();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.createAccess(s);){
                levelstoragesource$levelstorageaccess.deleteLevel();
            }
            catch (IOException ioexception) {
                SystemToast.onWorldDeleteFailure((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to delete world {}", (Object)s, (Object)ioexception);
            }
        }

        public void editWorld() {
            EditWorldScreen editworldscreen;
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess;
            this.queueLoadScreen();
            String s = this.summary.getLevelId();
            try {
                levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().validateAndCreateAccess(s);
            }
            catch (IOException ioexception1) {
                SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to access level {}", (Object)s, (Object)ioexception1);
                this.list.reloadWorldList();
                return;
            }
            catch (ContentValidationException contentvalidationexception) {
                LOGGER.warn("{}", (Object)contentvalidationexception.getMessage());
                this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen(this.screen)));
                return;
            }
            try {
                editworldscreen = EditWorldScreen.create((Minecraft)this.minecraft, (LevelStorageSource.LevelStorageAccess)levelstoragesource$levelstorageaccess, p_420812_ -> {
                    levelstoragesource$levelstorageaccess.safeClose();
                    this.list.returnToScreen();
                });
            }
            catch (IOException | NbtException | ReportedNbtException ioexception) {
                levelstoragesource$levelstorageaccess.safeClose();
                SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)s);
                LOGGER.error("Failed to load world data {}", (Object)s, (Object)ioexception);
                this.list.reloadWorldList();
                return;
            }
            this.minecraft.setScreen((Screen)editworldscreen);
        }

        public void recreateWorld() {
            this.queueLoadScreen();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().validateAndCreateAccess(this.summary.getLevelId());){
                Pair<LevelSettings, WorldCreationContext> pair = this.minecraft.createWorldOpenFlows().recreateWorldData(levelstoragesource$levelstorageaccess);
                LevelSettings levelsettings = (LevelSettings)pair.getFirst();
                WorldCreationContext worldcreationcontext = (WorldCreationContext)pair.getSecond();
                Path path = CreateWorldScreen.createTempDataPackDirFromExistingWorld(levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.DATAPACK_DIR), this.minecraft);
                worldcreationcontext.validate();
                if (worldcreationcontext.options().isOldCustomizedWorld()) {
                    this.minecraft.setScreen((Screen)new ConfirmScreen(p_420810_ -> this.minecraft.setScreen(p_420810_ ? CreateWorldScreen.createFromExisting(this.minecraft, this.list::returnToScreen, levelsettings, worldcreationcontext, path) : this.screen), (Component)Component.translatable("selectWorld.recreate.customized.title"), (Component)Component.translatable("selectWorld.recreate.customized.text"), CommonComponents.GUI_PROCEED, CommonComponents.GUI_CANCEL));
                } else {
                    this.minecraft.setScreen(CreateWorldScreen.createFromExisting(this.minecraft, this.list::returnToScreen, levelsettings, worldcreationcontext, path));
                }
            }
            catch (ContentValidationException contentvalidationexception) {
                LOGGER.warn("{}", (Object)contentvalidationexception.getMessage());
                this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen(this.screen)));
            }
            catch (Exception exception) {
                LOGGER.error("Unable to recreate world", (Throwable)exception);
                this.minecraft.setScreen((Screen)new AlertScreen(() -> this.minecraft.setScreen(this.screen), (Component)Component.translatable("selectWorld.recreate.error.title"), (Component)Component.translatable("selectWorld.recreate.error.text")));
            }
        }

        private void queueLoadScreen() {
            this.minecraft.setScreenAndShow((Screen)new GenericMessageScreen((Component)Component.translatable("selectWorld.data_read")));
        }

        private void loadIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && Files.isRegularFile(this.iconFile, new LinkOption[0]);
            if (flag) {
                try (InputStream inputstream = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                    this.icon.upload(NativeImage.read((InputStream)inputstream));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for world {}", (Object)this.summary.getLevelId(), (Object)throwable);
                    this.iconFile = null;
                }
            } else {
                this.icon.clear();
            }
        }

        @Override
        public void close() {
            if (!this.icon.isClosed()) {
                this.icon.close();
            }
        }

        public String getLevelName() {
            return this.summary.getLevelName();
        }

        @Override
        public LevelSummary getLevelSummary() {
            return this.summary;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }

        @Nullable
        public LevelSummary getLevelSummary() {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Minecraft minecraft;
        private final Screen screen;
        private int width;
        private int height;
        private String filter = "";
        private EntryType type = EntryType.SINGLEPLAYER;
        @Nullable
        private WorldSelectionList oldList = null;
        @Nullable
        private Consumer<LevelSummary> onEntrySelect = null;
        @Nullable
        private Consumer<WorldListEntry> onEntryInteract = null;

        public Builder(Minecraft p_430056_, Screen p_431029_) {
            this.minecraft = p_430056_;
            this.screen = p_431029_;
        }

        public Builder width(int p_431275_) {
            this.width = p_431275_;
            return this;
        }

        public Builder height(int p_423630_) {
            this.height = p_423630_;
            return this;
        }

        public Builder filter(String p_426893_) {
            this.filter = p_426893_;
            return this;
        }

        public Builder oldList(@Nullable WorldSelectionList p_429975_) {
            this.oldList = p_429975_;
            return this;
        }

        public Builder onEntrySelect(Consumer<LevelSummary> p_422872_) {
            this.onEntrySelect = p_422872_;
            return this;
        }

        public Builder onEntryInteract(Consumer<WorldListEntry> p_431314_) {
            this.onEntryInteract = p_431314_;
            return this;
        }

        public Builder uploadWorld() {
            this.type = EntryType.UPLOAD_WORLD;
            return this;
        }

        public WorldSelectionList build() {
            return new WorldSelectionList(this.screen, this.minecraft, this.width, this.height, this.filter, this.oldList, this.onEntrySelect, this.onEntryInteract, this.type);
        }
    }
}

