// Package faro provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.0 DO NOT EDIT.
package faro

import (
	"encoding/json"
	"time"

	"github.com/oapi-codegen/runtime"
	ptrace "go.opentelemetry.io/collector/pdata/ptrace"
)

// Defines values for Kind.
const (
	KindEvent       Kind = "event"
	KindException   Kind = "exception"
	KindLog         Kind = "log"
	KindMeasurement Kind = "measurement"
	KindUnknown     Kind = "unknown"
)

// Defines values for LogLevel.
const (
	LogLevelDebug   LogLevel = "debug"
	LogLevelError   LogLevel = "error"
	LogLevelInfo    LogLevel = "info"
	LogLevelTrace   LogLevel = "trace"
	LogLevelWarning LogLevel = "warning"
)

// Defines values for TimeFormat.
const (
	TimeFormatRFC3339Milli TimeFormat = "2006-01-02T15:04:05.999Z"
)

// Action holds data about user action events. These are events that are directly related to user interactions as well as the parent action itself
type Action struct {
	ID       string `json:"id,omitempty"`
	Name     string `json:"name,omitempty"`
	ParentID string `json:"parentId,omitempty"`
}

// App holds metadata about the application event originates from.
type App struct {
	BundleID    string `json:"bundleId,omitempty"`
	Environment string `json:"environment,omitempty"`
	Name        string `json:"name,omitempty"`
	Namespace   string `json:"namespace,omitempty"`
	Release     string `json:"release,omitempty"`
	Version     string `json:"version,omitempty"`
}

// Brand represents a single browser brand.
type Brand struct {
	Brand   string `json:"brand,omitempty"`
	Version string `json:"version,omitempty"`
}

// BrandsArray defines model for BrandsArray.
type BrandsArray = []Brand

// BrandsString represents brands as a string.
type BrandsString = string

// Browser holds metadata about a client's browser.
type Browser struct {
	Brands         Browser_Brands `json:"brands,omitempty"`
	Language       string         `json:"language,omitempty"`
	Mobile         bool           `json:"mobile,omitempty"`
	Name           string         `json:"name,omitempty"`
	OS             string         `json:"os,omitempty"`
	UserAgent      string         `json:"userAgent,omitempty"`
	Version        string         `json:"version,omitempty"`
	ViewportHeight string         `json:"viewportHeight,omitempty"`
	ViewportWidth  string         `json:"viewportWidth,omitempty"`
}

// Browser_Brands defines model for Browser.Brands.
type Browser_Brands struct {
	union json.RawMessage
}

// Event holds RUM event data.
type Event struct {
	// Action holds data about user action events. These are events that are directly related to user interactions as well as the parent action itself
	Action     Action            `json:"action,omitempty"`
	Attributes map[string]string `json:"attributes,omitempty"`
	Domain     string            `json:"domain,omitempty"`
	Name       string            `json:"name"`
	Timestamp  time.Time         `json:"timestamp,omitempty"`

	// Trace holds trace id and span id associated to an entity (log, exception, measurement...).
	Trace TraceContext `json:"trace,omitempty"`
}

// Exception holds all the data regarding an exception.
type Exception struct {
	// Action holds data about user action events. These are events that are directly related to user interactions as well as the parent action itself
	Action  Action           `json:"action,omitempty"`
	Context ExceptionContext `json:"context,omitempty"`

	// Stacktrace is a collection of Frames.
	Stacktrace *Stacktrace `json:"stacktrace,omitempty"`
	Timestamp  time.Time   `json:"timestamp"`

	// Trace holds trace id and span id associated to an entity (log, exception, measurement...).
	Trace TraceContext `json:"trace,omitempty"`
	Type  string       `json:"type,omitempty"`
	Value string       `json:"value,omitempty"`
}

// ExceptionContext defines model for ExceptionContext.
type ExceptionContext map[string]string

// Frame represents a single stacktrace frame.
type Frame struct {
	Colno    int    `json:"colno,omitempty"`
	Filename string `json:"filename,omitempty"`
	Function string `json:"function,omitempty"`
	Lineno   int    `json:"lineno,omitempty"`
	Module   string `json:"module,omitempty"`
}

// Geo holds metadata about a client's geo.
type Geo struct {
	ASNID            string `json:"asn_id,omitempty"`
	ASNOrg           string `json:"asn_org,omitempty"`
	City             string `json:"city,omitempty"`
	ContinentISOCode string `json:"continent_iso,omitempty"`
	CountryISOCode   string `json:"country_iso,omitempty"`
	SubdivisionISO   string `json:"subdivision_iso,omitempty"`
}

// K6 holds metadata about whether or not the run happened in a K6 browser.
type K6 struct {
	IsK6Browser bool `json:"isK6Browser,omitempty"`
}

// Kind defines model for Kind.
type Kind string

// Log controls the data that come into a Log message.
type Log struct {
	// Action holds data about user action events. These are events that are directly related to user interactions as well as the parent action itself
	Action Action `json:"action,omitempty"`

	// Context is a string to string map structure that represents the context of a log message.
	Context LogContext `json:"context,omitempty"`

	// LogLevel log level enum for incoming app logs.
	LogLevel  LogLevel  `json:"level,omitempty"`
	Message   string    `json:"message,omitempty"`
	Timestamp time.Time `json:"timestamp"`

	// Trace holds trace id and span id associated to an entity (log, exception, measurement...).
	Trace TraceContext `json:"trace,omitempty"`
}

// LogContext is a string to string map structure that represents the context of a log message.
type LogContext map[string]string

// LogLevel log level enum for incoming app logs.
type LogLevel string

// Measurement holds the data for user provided measurements.
type Measurement struct {
	// Action holds data about user action events. These are events that are directly related to user interactions as well as the parent action itself
	Action    Action             `json:"action,omitempty"`
	Context   MeasurementContext `json:"context,omitempty"`
	Timestamp time.Time          `json:"timestamp,omitempty"`

	// Trace holds trace id and span id associated to an entity (log, exception, measurement...).
	Trace  TraceContext       `json:"trace,omitempty"`
	Type   string             `json:"type,omitempty"`
	Values map[string]float64 `json:"values,omitempty"`
}

// MeasurementContext defines model for MeasurementContext.
type MeasurementContext map[string]string

// Meta holds metadata about an app event.
type Meta struct {
	// App holds metadata about the application event originates from.
	App App `json:"app,omitempty"`

	// Browser holds metadata about a client's browser.
	Browser Browser `json:"browser,omitempty"`

	// Geo holds metadata about a client's geo.
	Geo Geo `json:"geo,omitempty"`

	// K6 holds metadata about whether or not the run happened in a K6 browser.
	K6 K6 `json:"k6,omitempty"`

	// Page holds metadata about the web page event originates from.
	Page Page `json:"page,omitempty"`

	// SDK holds metadata about the app agent that produced the event.
	SDK SDK `json:"sdk,omitempty"`

	// Session holds metadata about the browser session the event originates from.
	Session Session `json:"session,omitempty"`

	// User holds metadata about the user related to an app event.
	User User `json:"user,omitempty"`

	// View holds metadata about a view.
	View View `json:"view,omitempty"`
}

// Overrides represents session override metadata.
type Overrides struct {
	GeoLocationTrackingEnabled bool   `json:"geoLocationTrackingEnabled,omitempty"`
	ServiceName                string `json:"serviceName,omitempty"`
}

// Page holds metadata about the web page event originates from.
type Page struct {
	Attributes map[string]string `json:"attributes,omitempty"`
	ID         string            `json:"id,omitempty"`
	URL        string            `json:"url,omitempty"`
}

// Payload is the body of the receiver request.
type Payload struct {
	Events       []Event       `json:"events,omitempty"`
	Exceptions   []Exception   `json:"exceptions,omitempty"`
	Logs         []Log         `json:"logs,omitempty"`
	Measurements []Measurement `json:"measurements,omitempty"`

	// Meta holds metadata about an app event.
	Meta Meta `json:"meta,omitempty"`

	// Traces otel traces model.
	Traces *Traces `json:"traces,omitempty"`
}

// SDK holds metadata about the app agent that produced the event.
type SDK struct {
	Integrations []SDKIntegration `json:"integrations,omitempty"`
	Name         string           `json:"name,omitempty"`
	Version      string           `json:"version,omitempty"`
}

// SDKIntegration holds metadata about a plugin/integration on the app agent that collected and sent the event.
type SDKIntegration struct {
	Name    string `json:"name,omitempty"`
	Version string `json:"version,omitempty"`
}

// Session holds metadata about the browser session the event originates from.
type Session struct {
	Attributes map[string]string `json:"attributes,omitempty"`
	ID         string            `json:"id,omitempty"`

	// Overrides represents session override metadata.
	Overrides Overrides `json:"overrides,omitempty"`
}

// SpanEvent defines model for SpanEvent.
type SpanEvent struct {
	Attributes             *[]interface{} `json:"attributes,omitempty"`
	DroppedAttributesCount *int           `json:"droppedAttributesCount,omitempty"`
	Name                   string         `json:"name"`
	TimeUnixNano           *string        `json:"timeUnixNano,omitempty"`
}

// Stacktrace is a collection of Frames.
type Stacktrace struct {
	Frames []Frame `json:"frames,omitempty"`
}

// TimeFormat defines model for TimeFormat.
type TimeFormat string

// TraceContext holds trace id and span id associated to an entity (log, exception, measurement...).
type TraceContext struct {
	SpanID  string `json:"span_id"`
	TraceID string `json:"trace_id"`
}

// Traces otel traces model.
type Traces struct {
	ptrace.Traces
}

// User holds metadata about the user related to an app event.
type User struct {
	Attributes map[string]string `json:"attributes,omitempty"`
	Email      string            `json:"email,omitempty"`
	ID         string            `json:"id,omitempty"`
	Username   string            `json:"username,omitempty"`
}

// View holds metadata about a view.
type View struct {
	Name string `json:"name,omitempty"`
}

// SubmitPayloadJSONRequestBody defines body for SubmitPayload for application/json ContentType.
type SubmitPayloadJSONRequestBody = Payload

// AsBrandsString returns the union data inside the Browser_Brands as a BrandsString
func (t Browser_Brands) AsBrandsString() (BrandsString, error) {
	var body BrandsString
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromBrandsString overwrites any union data inside the Browser_Brands as the provided BrandsString
func (t *Browser_Brands) FromBrandsString(v BrandsString) error {
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeBrandsString performs a merge with any union data inside the Browser_Brands, using the provided BrandsString
func (t *Browser_Brands) MergeBrandsString(v BrandsString) error {
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

// AsBrandsArray returns the union data inside the Browser_Brands as a BrandsArray
func (t Browser_Brands) AsBrandsArray() (BrandsArray, error) {
	var body BrandsArray
	err := json.Unmarshal(t.union, &body)
	return body, err
}

// FromBrandsArray overwrites any union data inside the Browser_Brands as the provided BrandsArray
func (t *Browser_Brands) FromBrandsArray(v BrandsArray) error {
	b, err := json.Marshal(v)
	t.union = b
	return err
}

// MergeBrandsArray performs a merge with any union data inside the Browser_Brands, using the provided BrandsArray
func (t *Browser_Brands) MergeBrandsArray(v BrandsArray) error {
	b, err := json.Marshal(v)
	if err != nil {
		return err
	}

	merged, err := runtime.JSONMerge(t.union, b)
	t.union = merged
	return err
}

func (t Browser_Brands) MarshalJSON() ([]byte, error) {
	b, err := t.union.MarshalJSON()
	return b, err
}

func (t *Browser_Brands) UnmarshalJSON(b []byte) error {
	err := t.union.UnmarshalJSON(b)
	return err
}
