/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011J\u0013\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/RecentSpeakersList;", "T", "", "numRecentSpeakers", "", "<init>", "(I)V", "list", "", "getList", "()Ljava/util/List;", "promote", "", "endpoint", "(Ljava/lang/Object;)Z", "removeAllExcept", "retain", "", "recentSpeakers", "getRecentSpeakers", "isRecentSpeaker", "jitsi-videobridge"})
public final class RecentSpeakersList<T> {
    private final int numRecentSpeakers;
    @NotNull
    private final List<T> list;

    public RecentSpeakersList(int numRecentSpeakers) {
        this.numRecentSpeakers = numRecentSpeakers;
        this.list = new LinkedList();
    }

    @NotNull
    public final List<T> getList() {
        return this.list;
    }

    public final boolean promote(T endpoint) {
        int index = this.list.indexOf(endpoint);
        if (index >= 0) {
            this.list.remove(index);
        }
        this.list.add(0, endpoint);
        return index != 0;
    }

    public final boolean removeAllExcept(@NotNull List<? extends T> retain) {
        Intrinsics.checkNotNullParameter(retain, (String)"retain");
        List<T> prevRecentSpeakers = this.getRecentSpeakers();
        this.list.removeIf(arg_0 -> RecentSpeakersList.removeAllExcept$lambda$1(arg_0 -> RecentSpeakersList.removeAllExcept$lambda$0(retain, arg_0), arg_0));
        return !Intrinsics.areEqual(this.getRecentSpeakers(), prevRecentSpeakers);
    }

    @NotNull
    public final List<T> getRecentSpeakers() {
        return CollectionsKt.take((Iterable)this.list, (int)this.numRecentSpeakers);
    }

    public final boolean isRecentSpeaker(T endpoint) {
        return this.getRecentSpeakers().contains(endpoint);
    }

    private static final boolean removeAllExcept$lambda$0(List $retain, Object it) {
        return !$retain.contains(it);
    }

    private static final boolean removeAllExcept$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

