/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\bJ*\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u001c\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\"\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%8G\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "mostRecentKeyframeGroupArrivalTime", "Ljava/time/Instant;", "value", "", "needsKeyframe", "getNeedsKeyframe", "()Z", "internalTargetEncoding", "", "internalTargetSpatialId", "currentIndex", "layers", "", "acceptFrame", "Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter$AcceptResult;", "frame", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "incomingEncoding", "externalTargetIndex", "receivedTime", "doAcceptFrame", "isOutOfSwitchingPhase", "isPossibleToSwitch", "acceptKeyframe", "addDiagnosticContext", "", "pt", "Lorg/jitsi/utils/logging/DiagnosticContext$TimeSeriesPoint;", "addDiagnosticContext$jitsi_videobridge", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "AcceptResult", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVp9QualityFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp9QualityFilter.kt\norg/jitsi/videobridge/cc/vp9/Vp9QualityFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,482:1\n11631#2:483\n11966#2,3:484\n*S KotlinDebug\n*F\n+ 1 Vp9QualityFilter.kt\norg/jitsi/videobridge/cc/vp9/Vp9QualityFilter\n*L\n459#1:483\n459#1:484,3\n*E\n"})
public final class Vp9QualityFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @Nullable
    private Instant mostRecentKeyframeGroupArrivalTime;
    private boolean needsKeyframe;
    private int internalTargetEncoding;
    private int internalTargetSpatialId;
    private int currentIndex;
    @NotNull
    private final boolean[] layers;
    private static final Duration MIN_KEY_FRAME_WAIT = Duration.ofMillis(300L);
    private static final int MAX_VP9_LAYERS = 8;

    public Vp9QualityFilter(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.internalTargetEncoding = -1;
        this.internalTargetSpatialId = -1;
        this.currentIndex = -1;
        this.layers = new boolean[8];
    }

    public final boolean getNeedsKeyframe() {
        return this.needsKeyframe;
    }

    @NotNull
    public final synchronized AcceptResult acceptFrame(@NotNull Vp9Frame frame, int incomingEncoding, int externalTargetIndex, @Nullable Instant receivedTime) {
        boolean isResumption;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int prevIndex = this.currentIndex;
        boolean accept = this.doAcceptFrame(frame, incomingEncoding, externalTargetIndex, receivedTime);
        boolean mark = frame.isInterPicturePredicted() ? RangesKt.coerceAtLeast((int)frame.getSpatialLayer(), (int)0) == RtpLayerDesc.Companion.getSidFromIndex(this.currentIndex) : RangesKt.coerceAtLeast((int)frame.getSpatialLayer(), (int)0) == RtpLayerDesc.Companion.getSidFromIndex(externalTargetIndex);
        boolean bl = isResumption = prevIndex == -1 && this.currentIndex != -1;
        if (isResumption && _Assertions.ENABLED && !accept) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new AcceptResult(accept, isResumption, mark);
    }

    private final boolean doAcceptFrame(Vp9Frame frame, int incomingEncoding, int externalTargetIndex, Instant receivedTime) {
        boolean bl;
        int externalTargetEncoding = RtpLayerDesc.Companion.getEidFromIndex(externalTargetIndex);
        int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
        if (externalTargetEncoding != this.internalTargetEncoding) {
            this.internalTargetEncoding = externalTargetEncoding;
            if (externalTargetEncoding != -1 && externalTargetEncoding != currentEncoding) {
                this.needsKeyframe = true;
            }
        }
        if (externalTargetEncoding == -1) {
            this.currentIndex = -1;
            return false;
        }
        int temporalLayerIdOfFrame = RangesKt.coerceAtLeast((int)frame.getTemporalLayer(), (int)0);
        if (frame.isKeyframe()) {
            this.logger.debug(() -> Vp9QualityFilter.doAcceptFrame$lambda$0(frame));
            boolean accept = this.acceptKeyframe(frame, incomingEncoding, receivedTime);
            if (accept) {
                int n = this.layers.length;
                for (int i = 0; i < n; ++i) {
                    this.layers[i] = i == 0;
                }
            }
            bl = accept;
        } else if (currentEncoding != -1) {
            boolean accept;
            boolean wantToForwardLayer;
            boolean wantToSwitch;
            if (this.isOutOfSwitchingPhase(receivedTime) && this.isPossibleToSwitch(incomingEncoding)) {
                this.needsKeyframe = true;
            }
            if (incomingEncoding != currentEncoding) {
                return false;
            }
            int spatialLayerOfFrame = RangesKt.coerceAtLeast((int)frame.getSpatialLayer(), (int)0);
            Ref.IntRef externalTargetSpatialId = new Ref.IntRef();
            externalTargetSpatialId.element = RtpLayerDesc.Companion.getSidFromIndex(externalTargetIndex);
            Ref.IntRef currentSpatialLayer = new Ref.IntRef();
            currentSpatialLayer.element = RtpLayerDesc.Companion.getSidFromIndex(this.currentIndex);
            if (frame.getNumSpatialLayers() != -1 && externalTargetSpatialId.element >= frame.getNumSpatialLayers()) {
                externalTargetSpatialId.element = frame.getNumSpatialLayers() - 1;
            }
            boolean canForwardLayer = !(frame.isInterPicturePredicted() && !this.layers[spatialLayerOfFrame] || frame.getUsesInterLayerDependency() && !this.layers[spatialLayerOfFrame - 1]);
            boolean bl2 = wantToSwitch = spatialLayerOfFrame > currentSpatialLayer.element && spatialLayerOfFrame <= externalTargetSpatialId.element || spatialLayerOfFrame < currentSpatialLayer.element && spatialLayerOfFrame >= externalTargetSpatialId.element || frame.getNumSpatialLayers() != -1 && currentSpatialLayer.element >= frame.getNumSpatialLayers();
            if (wantToSwitch) {
                if (canForwardLayer) {
                    this.logger.debug(() -> Vp9QualityFilter.doAcceptFrame$lambda$1(externalTargetSpatialId, currentSpatialLayer));
                    this.currentIndex = RtpLayerDesc.Companion.getIndex(incomingEncoding, frame.getSpatialLayer(), frame.getTemporalLayer());
                    currentSpatialLayer.element = spatialLayerOfFrame;
                } else {
                    if (this.internalTargetSpatialId != externalTargetSpatialId.element) {
                        this.logger.debug(() -> Vp9QualityFilter.doAcceptFrame$lambda$2(externalTargetSpatialId, currentSpatialLayer));
                    }
                    this.needsKeyframe = true;
                }
                this.internalTargetSpatialId = externalTargetSpatialId.element;
            }
            boolean bl3 = wantToForwardLayer = spatialLayerOfFrame == currentSpatialLayer.element || spatialLayerOfFrame < currentSpatialLayer.element && frame.isUpperLevelReference();
            if (wantToForwardLayer && !canForwardLayer) {
                this.logger.warn((Object)("Want to forward " + RtpLayerDesc.Companion.indexString(this.currentIndex) + " frame, but can't! layers=" + ArraysKt.joinToString$default((boolean[])this.layers, null, null, null, (int)0, null, null, (int)63, null) + ", currentIndex=" + RtpLayerDesc.Companion.indexString(this.currentIndex) + ", isInterPicturePredicted=" + frame.isInterPicturePredicted() + ", usesInterLayerDependency=" + frame.getUsesInterLayerDependency() + "."));
            }
            boolean bl4 = accept = wantToForwardLayer && canForwardLayer;
            if (temporalLayerIdOfFrame == 0) {
                this.layers[spatialLayerOfFrame] = accept;
            }
            if (!accept) {
                return false;
            }
            if (currentEncoding > externalTargetEncoding || currentSpatialLayer.element > externalTargetSpatialId.element) {
                bl = temporalLayerIdOfFrame < 1;
            } else if (currentEncoding < externalTargetEncoding || currentSpatialLayer.element < externalTargetSpatialId.element) {
                bl = true;
            } else {
                boolean acceptTemporal;
                int externalTargetTemporalId = RtpLayerDesc.Companion.getTidFromIndex(externalTargetIndex);
                int currentTemporalLayer = RtpLayerDesc.Companion.getTidFromIndex(this.currentIndex);
                boolean bl5 = acceptTemporal = temporalLayerIdOfFrame <= externalTargetTemporalId;
                if (acceptTemporal && temporalLayerIdOfFrame > currentTemporalLayer) {
                    this.currentIndex = RtpLayerDesc.Companion.getIndex(currentEncoding, currentSpatialLayer.element, temporalLayerIdOfFrame);
                }
                bl = acceptTemporal;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final synchronized boolean isOutOfSwitchingPhase(Instant receivedTime) {
        if (receivedTime == null) {
            return false;
        }
        if (this.mostRecentKeyframeGroupArrivalTime == null) {
            return true;
        }
        Duration delta = Duration.between(this.mostRecentKeyframeGroupArrivalTime, receivedTime);
        return delta.compareTo(MIN_KEY_FRAME_WAIT) > 0;
    }

    private final synchronized boolean isPossibleToSwitch(int incomingEncoding) {
        int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
        if (incomingEncoding == -1) {
            return false;
        }
        return incomingEncoding > currentEncoding && currentEncoding < this.internalTargetEncoding ? true : incomingEncoding < currentEncoding && currentEncoding > this.internalTargetEncoding;
    }

    private final synchronized boolean acceptKeyframe(Vp9Frame frame, int incomingEncoding, Instant receivedTime) {
        boolean bl;
        if (incomingEncoding < 0) {
            this.logger.error((Object)"invalid encoding id for keyframe");
            return false;
        }
        if (frame.getSpatialLayer() > 0 || frame.getTemporalLayer() > 0) {
            this.logger.warn((Object)("Surprising layers S" + frame.getSpatialLayer() + "T" + frame.getTemporalLayer() + " on keyframe"));
        }
        this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda$0(incomingEncoding));
        int incomingIndex = RtpLayerDesc.Companion.getIndex(incomingEncoding, frame.getSpatialLayer(), frame.getTemporalLayer());
        this.needsKeyframe = false;
        if (this.isOutOfSwitchingPhase(receivedTime)) {
            this.mostRecentKeyframeGroupArrivalTime = receivedTime;
            this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda$1(incomingEncoding, this));
            if (incomingEncoding <= this.internalTargetEncoding) {
                int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
                if (currentEncoding != incomingEncoding) {
                    this.currentIndex = incomingIndex;
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
            if (currentEncoding <= incomingEncoding && incomingEncoding <= this.internalTargetEncoding) {
                if (currentEncoding != incomingEncoding) {
                    this.currentIndex = incomingIndex;
                }
                this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda$2(incomingEncoding, this));
                bl = true;
            } else if (incomingEncoding <= this.internalTargetEncoding && this.internalTargetEncoding < currentEncoding) {
                this.currentIndex = incomingIndex;
                this.logger.debug(() -> Vp9QualityFilter.acceptKeyframe$lambda$3(incomingEncoding, this));
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    public final void addDiagnosticContext$jitsi_videobridge(@NotNull DiagnosticContext.TimeSeriesPoint pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Instant instant = this.mostRecentKeyframeGroupArrivalTime;
        pt.addField("qf.currentIndex", (Object)RtpLayerDesc.Companion.indexString(this.currentIndex)).addField("qf.internalTargetEncoding", (Object)this.internalTargetEncoding).addField("qf.internalTargetSpatialId", (Object)this.internalTargetSpatialId).addField("qf.needsKeyframe", (Object)this.needsKeyframe).addField("qf.mostRecentKeyframeGroupArrivalTimeMs", (Object)(instant != null ? instant.toEpochMilli() : -1L));
        int n = this.layers.length;
        for (int i = 0; i < n; ++i) {
            pt.addField("qf.layer." + i, (Object)this.layers[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    @NotNull
    public final JSONObject getDebugState() {
        void $this$mapTo$iv$iv;
        JSONObject debugState = new JSONObject();
        Map map = (Map)debugState;
        String string = "mostRecentKeyframeGroupArrivalTimeMs";
        Instant instant = this.mostRecentKeyframeGroupArrivalTime;
        Object object = instant != null ? instant.toEpochMilli() : -1L;
        map.put(string, object);
        ((Map)debugState).put("needsKeyframe", this.needsKeyframe);
        ((Map)debugState).put("internalTargetEncoding", this.internalTargetEncoding);
        ((Map)debugState).put("internalTargetSpatialId", this.internalTargetSpatialId);
        ((Map)debugState).put("currentIndex", RtpLayerDesc.Companion.indexString(this.currentIndex));
        map = (Map)debugState;
        string = "layersForwarded";
        boolean[] $this$map$iv = this.layers;
        boolean $i$f$map = false;
        boolean[] blArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void item$iv$iv;
            void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(StringsKt.first((CharSequence)this.toString())));
        }
        object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        map.put(string, object);
        return debugState;
    }

    private static final String doAcceptFrame$lambda$0(Vp9Frame $frame) {
        return "Quality filter got keyframe for stream " + $frame.getSsrc();
    }

    private static final String doAcceptFrame$lambda$1(Ref.IntRef $externalTargetSpatialId, Ref.IntRef $currentSpatialLayer) {
        return "Switching to spatial layer " + $externalTargetSpatialId.element + " from " + $currentSpatialLayer.element;
    }

    private static final String doAcceptFrame$lambda$2(Ref.IntRef $externalTargetSpatialId, Ref.IntRef $currentSpatialLayer) {
        return "Want to switch to spatial layer " + $externalTargetSpatialId.element + " from " + $currentSpatialLayer.element + ", requesting keyframe";
    }

    private static final String acceptKeyframe$lambda$0(int $incomingEncoding) {
        return "Received a keyframe of encoding: " + $incomingEncoding;
    }

    private static final String acceptKeyframe$lambda$1(int $incomingEncoding, Vp9QualityFilter this$0) {
        return "First keyframe in this kf group currentEncodingId: " + $incomingEncoding + ". Target is " + this$0.internalTargetEncoding;
    }

    private static final String acceptKeyframe$lambda$2(int $incomingEncoding, Vp9QualityFilter this$0) {
        return "Upscaling to encoding " + $incomingEncoding + ". The target is " + this$0.internalTargetEncoding;
    }

    private static final String acceptKeyframe$lambda$3(int $incomingEncoding, Vp9QualityFilter this$0) {
        return "Downscaling to encoding " + $incomingEncoding + ". The target is " + this$0.internalTargetEncoding;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter$AcceptResult;", "", "accept", "", "isResumption", "mark", "<init>", "(ZZZ)V", "getAccept", "()Z", "getMark", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "jitsi-videobridge"})
    public static final class AcceptResult {
        private final boolean accept;
        private final boolean isResumption;
        private final boolean mark;

        public AcceptResult(boolean accept, boolean isResumption, boolean mark) {
            this.accept = accept;
            this.isResumption = isResumption;
            this.mark = mark;
        }

        public final boolean getAccept() {
            return this.accept;
        }

        public final boolean isResumption() {
            return this.isResumption;
        }

        public final boolean getMark() {
            return this.mark;
        }

        public final boolean component1() {
            return this.accept;
        }

        public final boolean component2() {
            return this.isResumption;
        }

        public final boolean component3() {
            return this.mark;
        }

        @NotNull
        public final AcceptResult copy(boolean accept, boolean isResumption, boolean mark) {
            return new AcceptResult(accept, isResumption, mark);
        }

        public static /* synthetic */ AcceptResult copy$default(AcceptResult acceptResult, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = acceptResult.accept;
            }
            if ((n & 2) != 0) {
                bl2 = acceptResult.isResumption;
            }
            if ((n & 4) != 0) {
                bl3 = acceptResult.mark;
            }
            return acceptResult.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "AcceptResult(accept=" + this.accept + ", isResumption=" + this.isResumption + ", mark=" + this.mark + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.accept);
            result = result * 31 + Boolean.hashCode(this.isResumption);
            result = result * 31 + Boolean.hashCode(this.mark);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AcceptResult)) {
                return false;
            }
            AcceptResult acceptResult = (AcceptResult)other;
            if (this.accept != acceptResult.accept) {
                return false;
            }
            if (this.isResumption != acceptResult.isResumption) {
                return false;
            }
            return this.mark == acceptResult.mark;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter$Companion;", "", "<init>", "()V", "MIN_KEY_FRAME_WAIT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "MAX_VP9_LAYERS", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

