/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ice4j.util.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.dcsctp4j.DcSctpMessage;
import org.jitsi.dcsctp4j.ErrorKind;
import org.jitsi.dcsctp4j.SendPacketStatus;
import org.jitsi.dcsctp4j.SendStatus;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.PacketOrigin;
import org.jitsi.nlj.Transceiver;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.RemoteSsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.UnparsedPacket;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.rtp.rtcp.CompoundRtcpPacket;
import org.jitsi.rtp.rtcp.RtcpByePacket;
import org.jitsi.rtp.rtcp.RtcpHeader;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSdesPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.SdesChunk;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.ErrorHandler;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.CryptexConfig;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.TransportConfig;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelPacket;
import org.jitsi.videobridge.dcsctp.DcSctpBaseCallbacks;
import org.jitsi.videobridge.dcsctp.DcSctpHandler;
import org.jitsi.videobridge.dcsctp.DcSctpTransport;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.SourceVideoTypeMessage;
import org.jitsi.videobridge.metrics.QueueMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.RelayEndpointSender;
import org.jitsi.videobridge.relay.RelayMessageTransport;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.relay.RelayedPacketInfo;
import org.jitsi.videobridge.rest.root.debug.EndpointDebugFeatures;
import org.jitsi.videobridge.sctp.DataChannelHandler;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.PacketUtils;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 \u00b6\u00012\u00020\u00012\u00020\u0002:\n\u00b6\u0001\u00b7\u0001\u00b8\u0001\u00b9\u0001\u00ba\u0001BE\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010O\u001a\u00020NJ\u000e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VJ\b\u0010W\u001a\u00020XH\u0002J\b\u0010Y\u001a\u00020XH\u0002J \u0010\\\u001a\u00020X2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0002J\u000e\u0010c\u001a\u00020X2\u0006\u0010d\u001a\u00020eJ\u0010\u0010f\u001a\u00020X2\u0006\u0010d\u001a\u00020eH\u0002J\u000e\u0010g\u001a\u00020X2\u0006\u0010h\u001a\u00020iJ\u0006\u0010j\u001a\u00020iJ\u0016\u0010k\u001a\u00020X2\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\u000bJ\u000e\u0010o\u001a\u00020\u000b2\u0006\u0010l\u001a\u00020mJ\u0010\u0010p\u001a\u00020X2\u0006\u0010q\u001a\u00020rH\u0002J\u000e\u0010s\u001a\u00020X2\u0006\u0010q\u001a\u00020tJ(\u0010u\u001a\u00020X2\u0006\u0010v\u001a\u00020\u00042\u0006\u0010w\u001a\u00020=2\u0006\u0010x\u001a\u00020=2\u0006\u0010y\u001a\u00020zH\u0016J\u000e\u0010{\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020tJ\u000e\u0010|\u001a\u00020X2\u0006\u0010}\u001a\u00020~J\u0006\u0010\u007f\u001a\u00020XJ\"\u0010\u0080\u0001\u001a\u00020X2\u0007\u0010\u0081\u0001\u001a\u00020b2\u0007\u0010\u0082\u0001\u001a\u00020^2\u0007\u0010\u0083\u0001\u001a\u00020^J>\u0010\u0084\u0001\u001a\u0004\u0018\u00010:2\u0006\u0010\u0003\u001a\u00020\u00042\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u0086\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u0087\u00012\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u008a\u00010\u0087\u0001J1\u0010\u008b\u0001\u001a\u00020X2\u0006\u0010\u0003\u001a\u00020\u00042\u000f\u0010\u0086\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u0087\u00012\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u008a\u00010\u0087\u0001J\u000f\u0010\u008c\u0001\u001a\u00020X2\u0006\u0010\u0003\u001a\u00020\u0004J\u0011\u0010\u008d\u0001\u001a\u00020B2\u0006\u0010v\u001a\u00020\u0004H\u0002J\u0010\u0010\u008e\u0001\u001a\u00020X2\u0007\u0010\u008f\u0001\u001a\u00020\u0019J\u0010\u0010\u0090\u0001\u001a\u00020X2\u0007\u0010\u0091\u0001\u001a\u00020\u001bJ\u0010\u0010\u0092\u0001\u001a\u00020X2\u0007\u0010\u0093\u0001\u001a\u00020\u000bJ4\u0010\u0094\u0001\u001a\u00020X2\u0007\u0010\u0095\u0001\u001a\u00020:2\u000f\u0010\u0086\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u0087\u00012\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u008a\u00010\u0087\u0001H\u0002J\u0011\u0010\u0096\u0001\u001a\u0004\u0018\u00010:2\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0097\u0001\u001a\u0004\u0018\u00010:2\u0007\u0010\u0098\u0001\u001a\u00020=J\u0007\u0010\u0099\u0001\u001a\u00020XJ\u0010\u0010\u009a\u0001\u001a\u00020\u000b2\u0007\u0010\u009b\u0001\u001a\u00020\u0004J\u001a\u0010\u009c\u0001\u001a\t\u0012\u0004\u0012\u00020=0\u0087\u00012\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0002J4\u0010\u009f\u0001\u001a\u00020X2\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\b\u0010v\u001a\u0004\u0018\u00010\u00042\u0015\u0010\u00a0\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00a2\u0001\u0012\u0004\u0012\u00020X0\u00a1\u0001H\u0002J'\u0010\u00a3\u0001\u001a\u00020X2\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\n\u0010\u00a4\u0001\u001a\u0005\u0018\u00010\u00a5\u00012\b\u0010v\u001a\u0004\u0018\u00010\u0004J\u001b\u0010\u00a6\u0001\u001a\u00020X2\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\b\u0010v\u001a\u0004\u0018\u00010\u0004J\t\u0010\u00a7\u0001\u001a\u00020\u000bH\u0002J\u0012\u0010\u00a8\u0001\u001a\u00020\u000b2\u0007\u0010\u009d\u0001\u001a\u00020tH\u0016J\u0012\u0010\u00a9\u0001\u001a\u00020X2\u0007\u0010\u009d\u0001\u001a\u00020tH\u0016J\u000f\u0010\u00aa\u0001\u001a\u00020X2\u0006\u0010\u0003\u001a\u00020\u0004J\t\u0010\u00b4\u0001\u001a\u00020XH\u0002J\u0007\u0010\u00b5\u0001\u001a\u00020XR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00060+R\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00060+R\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\n 6*\u0004\u0018\u00010505X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\n 6*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00108\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020:09j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020:`;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010<\u001a\u001e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020:09j\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020:`;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020B0AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Z\u001a\u0004\u0018\u00010[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u00ab\u0001\u001a\u00020=8F\u00a2\u0006\b\u001a\u0006\b\u00ac\u0001\u0010\u00ad\u0001R\u0014\u0010\u00ae\u0001\u001a\u00020=8F\u00a2\u0006\b\u001a\u0006\b\u00af\u0001\u0010\u00ad\u0001R\u0014\u0010\u00b0\u0001\u001a\u00020=8F\u00a2\u0006\b\u001a\u0006\b\u00b1\u0001\u0010\u00ad\u0001R\u0014\u0010\u00b2\u0001\u001a\u00020=8F\u00a2\u0006\b\u001a\u0006\b\u00b3\u0001\u0010\u00ad\u0001\u00a8\u0006\u00bb\u0001"}, d2={"Lorg/jitsi/videobridge/relay/Relay;", "Lorg/jitsi/videobridge/EncodingsManager$EncodingsUpdateListener;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "id", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "meshId", "iceControlling", "", "useUniquePort", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;ZZLjava/time/Clock;)V", "getId", "()Ljava/lang/String;", "getConference", "()Lorg/jitsi/videobridge/Conference;", "getMeshId", "logger", "payloadTypes", "", "Lorg/jitsi/nlj/format/PayloadType;", "rtpExtensions", "Lorg/jitsi/nlj/rtp/RtpExtension;", "extmapAllowMixed", "expired", "sctpHandler", "Lorg/jitsi/videobridge/dcsctp/DcSctpHandler;", "sctpTransport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "sctpRole", "Lorg/jitsi/xmpp/extensions/colibri2/Sctp$Role;", "dataChannelHandler", "Lorg/jitsi/videobridge/sctp/DataChannelHandler;", "dataChannelStack", "Lorg/jitsi/videobridge/datachannel/DataChannelStack;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "sctpRecvPcap", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter$PcapWriterNode;", "sctpSendPcap", "sctpPipeline", "Lorg/jitsi/nlj/transform/node/Node;", "iceTransport", "Lorg/jitsi/videobridge/transport/ice/IceTransport;", "dtlsTransport", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "cryptex", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "kotlin.jvm.PlatformType", "timelineLogger", "relayedEndpoints", "Ljava/util/HashMap;", "Lorg/jitsi/videobridge/relay/RelayedEndpoint;", "Lkotlin/collections/HashMap;", "endpointsBySsrc", "", "endpointsLock", "", "senders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jitsi/videobridge/relay/RelayEndpointSender;", "statistics", "Lorg/jitsi/videobridge/relay/Relay$Statistics;", "getStatistics", "()Lorg/jitsi/videobridge/relay/Relay$Statistics;", "rttListener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "transceiver", "Lorg/jitsi/nlj/Transceiver;", "getTransceiver", "()Lorg/jitsi/nlj/Transceiver;", "messageTransport", "Lorg/jitsi/videobridge/relay/RelayMessageTransport;", "getMessageTransport", "outgoingSrtpPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "incomingDataChannelMessagesQueue", "debugState", "Lorg/json/simple/JSONObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "setupIceTransport", "", "setupDtlsTransport", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "setSrtpInformation", "chosenSrtpProtectionProfile", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "createSctpConnection", "sctpDesc", "Lorg/jitsi/xmpp/extensions/colibri2/Sctp;", "createDcSctpConnection", "setTransportInfo", "transportInfo", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "describeTransport", "setFeature", "feature", "Lorg/jitsi/videobridge/rest/root/debug/EndpointDebugFeatures;", "enabled", "isFeatureEnabled", "handleMediaPacket", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "handleIncomingPacket", "Lorg/jitsi/nlj/PacketInfo;", "onNewSsrcAssociation", "endpointId", "primarySsrc", "secondarySsrc", "type", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "doSendSrtp", "sendMessage", "msg", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "relayMessageTransportConnected", "dtlsAppPacketReceived", "data", "off", "len", "addRemoteEndpoint", "statsId", "audioSources", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "videoSources", "Lorg/jitsi/nlj/MediaSourceDesc;", "updateRemoteEndpoint", "removeRemoteEndpoint", "getOrCreateRelaySender", "addPayloadType", "payloadType", "addRtpExtension", "rtpExtension", "setExtmapAllowMixed", "allow", "setEndpointMediaSources", "ep", "getEndpoint", "getEndpointBySsrc", "ssrc", "scheduleRelayMessageTransportTimeout", "acceptWebSocket", "password", "getRtcpSsrcs", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "doRtcpCallbacks", "callback", "Lkotlin/Function1;", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "rtcpPacketReceived", "receivedTime", "Ljava/time/Instant;", "rtcpPacketSent", "isTransportConnected", "wants", "send", "endpointExpired", "incomingBitrateBps", "getIncomingBitrateBps", "()J", "incomingPacketRate", "getIncomingPacketRate", "outgoingBitrateBps", "getOutgoingBitrateBps", "outgoingPacketRate", "getOutgoingPacketRate", "updateStatsOnExpire", "expire", "Companion", "Statistics", "SctpCallbacks", "TransceiverEventHandlerImpl", "IncomingRelayPacketHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1205:1\n1#2:1206\n63#3,4:1207\n63#3,4:1215\n63#3,4:1230\n63#3,4:1293\n63#3,4:1297\n63#3,4:1301\n1869#4,2:1211\n1869#4,2:1213\n1869#4:1219\n1870#4:1227\n1869#4,2:1228\n1869#4,2:1234\n1869#4,2:1236\n1869#4,2:1238\n1869#4:1240\n1870#4:1243\n1869#4,2:1246\n1869#4,2:1248\n1869#4,2:1250\n1869#4,2:1254\n1869#4,2:1256\n1869#4,2:1258\n1869#4,2:1260\n1869#4,2:1262\n1869#4,2:1264\n1869#4,2:1266\n1869#4,2:1268\n1869#4,2:1270\n1869#4,2:1274\n1869#4,2:1276\n1869#4,2:1278\n1869#4,2:1280\n1869#4,2:1282\n1869#4,2:1284\n774#4:1286\n865#4,2:1287\n1869#4,2:1289\n1869#4,2:1291\n382#5,7:1220\n13805#6,2:1241\n37#7,2:1244\n37#7,2:1252\n37#7,2:1272\n*S KotlinDebug\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay\n*L\n425#1:1207,4\n463#1:1215,4\n539#1:1230,4\n1026#1:1293,4\n1027#1:1297,4\n1028#1:1301,4\n441#1:1211,2\n444#1:1213,2\n482#1:1219\n482#1:1227\n528#1:1228,2\n549#1:1234,2\n551#1:1236,2\n646#1:1238,2\n647#1:1240\n647#1:1243\n705#1:1246,2\n709#1:1248,2\n710#1:1250,2\n740#1:1254,2\n771#1:1256,2\n772#1:1258,2\n786#1:1260,2\n788#1:1262,2\n801#1:1264,2\n803#1:1266,2\n811#1:1268,2\n813#1:1270,2\n872#1:1274,2\n875#1:1276,2\n876#1:1278,2\n877#1:1280,2\n892#1:1282,2\n895#1:1284,2\n1007#1:1286\n1007#1:1287,2\n1017#1:1289,2\n1019#1:1291,2\n484#1:1220,7\n649#1:1241,2\n701#1:1244,2\n733#1:1252,2\n822#1:1272,2\n*E\n"})
public final class Relay
implements EncodingsManager.EncodingsUpdateListener,
PotentialPacketHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Conference conference;
    @Nullable
    private final String meshId;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<PayloadType> payloadTypes;
    @NotNull
    private final List<RtpExtension> rtpExtensions;
    private boolean extmapAllowMixed;
    private boolean expired;
    @Nullable
    private final DcSctpHandler sctpHandler;
    @Nullable
    private DcSctpTransport sctpTransport;
    @Nullable
    private Sctp.Role sctpRole;
    @NotNull
    private final DataChannelHandler dataChannelHandler;
    @Nullable
    private DataChannelStack dataChannelStack;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final ToggleablePcapWriter.PcapWriterNode sctpRecvPcap;
    @NotNull
    private final ToggleablePcapWriter.PcapWriterNode sctpSendPcap;
    @NotNull
    private final Node sctpPipeline;
    @NotNull
    private final IceTransport iceTransport;
    @NotNull
    private final DtlsTransport dtlsTransport;
    private boolean cryptex;
    private final DiagnosticContext diagnosticContext;
    private final Logger timelineLogger;
    @NotNull
    private final HashMap<String, RelayedEndpoint> relayedEndpoints;
    @NotNull
    private final HashMap<Long, RelayedEndpoint> endpointsBySsrc;
    @NotNull
    private final Object endpointsLock;
    @NotNull
    private final ConcurrentHashMap<String, RelayEndpointSender> senders;
    @NotNull
    private final Statistics statistics;
    @NotNull
    private final EndpointConnectionStats.EndpointConnectionStatsListener rttListener;
    @NotNull
    private final Transceiver transceiver;
    @NotNull
    private final RelayMessageTransport messageTransport;
    @NotNull
    private final PacketInfoQueue outgoingSrtpPacketQueue;
    @NotNull
    private final PacketInfoQueue incomingDataChannelMessagesQueue;
    @Nullable
    private SrtpTransformers srtpTransformers;
    @NotNull
    private static final CounterMetric droppedPacketsMetric = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"relay_srtp_send_queue_dropped_packets", (String)"Number of packets dropped out of the Relay SRTP send queue.", (long)0L, null, (int)12, null);
    @NotNull
    private static final CounterMetric exceptionsMetric = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"relay_srtp_send_queue_exceptions", (String)"Number of exceptions from the Relay SRTP send queue.", (long)0L, null, (int)12, null);
    @JvmField
    @NotNull
    public static final CountingErrorHandler queueErrorCounter = new CountingErrorHandler(){

        public void packetDropped() {
            Unit unit;
            super.packetDropped();
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default((CounterMetric)Relay.access$getDroppedPacketsMetric$cp(), null, (int)1, null);
            CounterMetric.inc$default((CounterMetric)QueueMetrics.INSTANCE.getDroppedPackets(), null, (int)1, null);
        }

        public void packetHandlingFailed(Throwable t) {
            Unit unit;
            super.packetHandlingFailed(t);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default((CounterMetric)Relay.access$getExceptionsMetric$cp(), null, (int)1, null);
            CounterMetric.inc$default((CounterMetric)QueueMetrics.INSTANCE.getExceptions(), null, (int)1, null);
        }
    };
    @NotNull
    private static final String SRTP_QUEUE_ENTRY_EVENT = "Entered Relay SRTP sender outgoing queue";
    @NotNull
    private static final String SRTP_QUEUE_EXIT_EVENT = "Exited Relay SRTP sender outgoing queue";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Relay(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, @Nullable String meshId, boolean iceControlling, boolean useUniquePort, @NotNull Clock clock) {
        void $this$outgoingSrtpPacketQueue_u24lambda_u240;
        Object $this$transceiver_u24lambda_u240;
        Object $this$diagnosticContext_u24lambda_u240;
        Object it;
        Object $this$logger_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.id = id;
        this.conference = conference;
        this.meshId = meshId;
        Logger logger = object = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        Relay relay = this;
        boolean bl = false;
        $this$logger_u24lambda_u240.addContext("relayId", this.id);
        relay.logger = object;
        this.payloadTypes = new ArrayList();
        this.rtpExtensions = new ArrayList();
        this.sctpHandler = SctpConfig.config.getEnabled() ? new DcSctpHandler() : null;
        this.dataChannelHandler = new DataChannelHandler();
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.logger, this.id + "-sctp");
        this.sctpRecvPcap = this.toggleablePcapWriter.newObserverNode(false, "rx_sctp");
        this.sctpSendPcap = this.toggleablePcapWriter.newObserverNode(true, "tx_sctp");
        this.sctpPipeline = PipelineDslKt.pipeline(arg_0 -> Relay.sctpPipeline$lambda$0(this, arg_0));
        this.iceTransport = new IceTransport(this.id, iceControlling, useUniquePort, true, this.logger, clock);
        $this$logger_u24lambda_u240 = object = new DtlsTransport(this.logger, this.id);
        relay = this;
        boolean bl2 = false;
        it.setCryptex(CryptexConfig.Companion.getRelay());
        relay.dtlsTransport = object;
        this.cryptex = CryptexConfig.Companion.getRelay();
        it = object = this.conference.newDiagnosticContext();
        relay = this;
        boolean bl3 = false;
        $this$diagnosticContext_u24lambda_u240.put((Object)"relay_id", (Object)this.id);
        relay.diagnosticContext = object;
        this.timelineLogger = this.logger.createChildLogger("timeline." + this.getClass().getName());
        this.relayedEndpoints = new HashMap();
        this.endpointsBySsrc = new HashMap();
        this.endpointsLock = new Object();
        this.senders = new ConcurrentHashMap();
        this.statistics = new Statistics();
        this.rttListener = new EndpointConnectionStats.EndpointConnectionStatsListener(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRttUpdate(double newRttMs) {
                if (newRttMs > 0.0) {
                    this.this$0.getTransceiver().removeEndpointConnectionStatsListener((EndpointConnectionStats.EndpointConnectionStatsListener)this);
                    Relay.access$getIceTransport$p(this.this$0).updateStatsOnInitialRtt(newRttMs);
                }
            }
        };
        ExecutorService executorService = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"CPU_POOL");
        ExecutorService executorService2 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"SCHEDULED_POOL");
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticContext, (String)"diagnosticContext");
        $this$diagnosticContext_u24lambda_u240 = object = new Transceiver(this.id, executorService, executorService2, scheduledExecutorService, diagnosticContext, this.logger, (TransceiverEventHandler)new TransceiverEventHandlerImpl(), clock);
        relay = this;
        boolean bl4 = false;
        $this$transceiver_u24lambda_u240.setIncomingPacketHandler((PacketHandler)new ConsumerNode(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
                super("receiver chain handler");
            }

            protected void consume(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                this.this$0.handleIncomingPacket(packetInfo);
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                f.invoke();
            }
        });
        $this$transceiver_u24lambda_u240.addEndpointConnectionStatsListener(this.rttListener);
        $this$transceiver_u24lambda_u240.setLocalSsrc(MediaType.AUDIO, this.conference.getLocalAudioSsrc());
        $this$transceiver_u24lambda_u240.setLocalSsrc(MediaType.VIDEO, this.conference.getLocalVideoSsrc());
        $this$transceiver_u24lambda_u240.getRtcpEventNotifier().addRtcpEventListener(new RtcpListener(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void rtcpPacketReceived(RtcpPacket packet, Instant receivedTime) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                this.this$0.rtcpPacketReceived(packet, receivedTime, null);
            }

            public void rtcpPacketSent(RtcpPacket packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                this.this$0.rtcpPacketSent(packet, null);
            }
        }, true);
        $this$transceiver_u24lambda_u240.addRtpExtensionToRetain(RtpExtensionType.VLA);
        relay.transceiver = object;
        this.messageTransport = new RelayMessageTransport(this, this.conference, this.logger);
        this.conference.getEncodingsManager().subscribe(this);
        this.setupIceTransport();
        this.setupDtlsTransport();
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.totalRelays, null, (int)1, null);
        String string = this.getClass().getSimpleName() + "-outgoing-packet-queue";
        ExecutorService executorService3 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService3, (String)"IO_POOL");
        $this$transceiver_u24lambda_u240 = object = new PacketInfoQueue(string, executorService3, (Function1)new Function1<PacketInfo, Boolean>((Object)this){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Relay)this.receiver).doSendSrtp(p0);
            }
        }, TransportConfig.Companion.getQueueSize());
        relay = this;
        boolean bl5 = false;
        $this$outgoingSrtpPacketQueue_u24lambda_u240.setErrorHandler((ErrorHandler)queueErrorCounter);
        relay.outgoingSrtpPacketQueue = object;
        String string2 = this.getClass().getSimpleName() + "-incoming-data-channel-queue";
        ExecutorService executorService4 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService4, (String)"IO_POOL");
        this.incomingDataChannelMessagesQueue = new PacketInfoQueue(string2, executorService4, arg_0 -> Relay.incomingDataChannelMessagesQueue$lambda$0(this, arg_0), TransportConfig.Companion.getQueueSize());
    }

    public /* synthetic */ Relay(String string, Conference conference, Logger logger, String string2, boolean bl, boolean bl2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(string, conference, logger, string2, bl, bl2, clock);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Conference getConference() {
        return this.conference;
    }

    @Nullable
    public final String getMeshId() {
        return this.meshId;
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    public final Transceiver getTransceiver() {
        return this.transceiver;
    }

    @NotNull
    public final RelayMessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONObject debugState(@NotNull DebugStateMode mode) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        JSONObject $this$debugState_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$debugState_u24lambda_u240.put((Object)"ice_transport", (Object)this.iceTransport.getDebugState());
        $this$debugState_u24lambda_u240.put((Object)"dtls_transport", (Object)this.dtlsTransport.getDebugState());
        $this$debugState_u24lambda_u240.put((Object)"transceiver", (Object)this.transceiver.debugState(mode));
        $this$debugState_u24lambda_u240.put((Object)"mesh_id", (Object)this.meshId);
        $this$debugState_u24lambda_u240.put((Object)"message_transport", (Object)this.messageTransport.getDebugState());
        DcSctpTransport dcSctpTransport = this.sctpTransport;
        if (dcSctpTransport != null) {
            DcSctpTransport it = dcSctpTransport;
            boolean bl2 = false;
            $this$debugState_u24lambda_u240.put((Object)"sctp", (Object)it.getDebugState());
        }
        if (mode == DebugStateMode.FULL) {
            JSONObject remoteEndpoints = new JSONObject();
            JSONObject endpointsBySsrcMap = new JSONObject();
            Iterator<RelayEndpointSender> iterator = this.endpointsLock;
            synchronized (iterator) {
                boolean $i$a$-synchronized-Relay$debugState$1$332 = false;
                Iterator<Object> iterator2 = this.relayedEndpoints.values().iterator();
                while (iterator2.hasNext()) {
                    RelayedEndpoint entry;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    ((Map)remoteEndpoints).put(entry.getId(), entry.debugState(mode));
                }
                for (Map.Entry entry : ((Map)this.endpointsBySsrc).entrySet()) {
                    long s = ((Number)entry.getKey()).longValue();
                    RelayedEndpoint e = (RelayedEndpoint)entry.getValue();
                    ((Map)endpointsBySsrcMap).put(s, e.getId());
                }
                Unit $i$a$-synchronized-Relay$debugState$1$332 = Unit.INSTANCE;
            }
            $this$debugState_u24lambda_u240.put((Object)"remote_endpoints", (Object)remoteEndpoints);
            $this$debugState_u24lambda_u240.put((Object)"endpoints_by_ssrc", (Object)endpointsBySsrcMap);
            JSONObject endpointSenders = new JSONObject();
            iterator = this.senders.values().iterator();
            while (iterator.hasNext()) {
                RelayEndpointSender s;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                ((Map)endpointSenders).put(s.getId(), s.getDebugState(mode));
            }
            $this$debugState_u24lambda_u240.put((Object)"senders", (Object)endpointSenders);
        }
        return jSONObject;
    }

    private final void setupIceTransport() {
        this.iceTransport.incomingDataHandler = new IceTransport.IncomingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(Buffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                if (PacketUtils.looksLikeDtls(buffer.getBuffer(), buffer.getOffset(), buffer.getLength())) {
                    Relay.access$getDtlsTransport$p(this.this$0).enqueueBuffer(buffer);
                } else {
                    RelayedPacketInfo relayedPacketInfo;
                    RelayedPacketInfo $this$dataReceived_u24lambda_u240 = relayedPacketInfo = new RelayedPacketInfo((Packet)new UnparsedPacket(buffer.getBuffer(), buffer.getOffset(), buffer.getLength()), this.this$0.getMeshId());
                    boolean bl = false;
                    $this$dataReceived_u24lambda_u240.setReceivedTime(buffer.getReceivedTime());
                    RelayedPacketInfo pktInfo = relayedPacketInfo;
                    pktInfo.setPacketOrigin(PacketOrigin.Routed);
                    Relay.access$handleMediaPacket(this.this$0, pktInfo);
                }
            }
        };
        this.iceTransport.eventHandler = new IceTransport.EventHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void writeable() {
                Relay.access$getLogger$p(this.this$0).info((Object)"ICE connected");
                this.this$0.getTransceiver().setOutgoingPacketHandler(new PacketHandler(this.this$0){
                    final /* synthetic */ Relay this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void processPacket(PacketInfo packetInfo) {
                        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                        packetInfo.addEvent("Entered Relay SRTP sender outgoing queue");
                        Relay.access$getOutgoingSrtpPacketQueue$p(this.this$0).add((Object)packetInfo);
                    }
                });
                TaskPools.IO_POOL.execute(Relay.access$getDtlsTransport$p(this.this$0)::startDtlsHandshake);
            }

            public void connected() {
            }

            public void failed() {
            }

            public void consentUpdated(Instant time) {
                Intrinsics.checkNotNullParameter((Object)time, (String)"time");
                this.this$0.getTransceiver().getPacketIOActivity().setLastIceActivityInstant(time);
            }
        };
    }

    private final void setupDtlsTransport() {
        this.dtlsTransport.incomingDataHandler = new DtlsTransport.IncomingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void dtlsAppDataReceived(byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                this.this$0.dtlsAppPacketReceived(buf, off, len);
            }
        };
        this.dtlsTransport.outgoingDataHandler = new DtlsTransport.OutgoingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Relay.access$getIceTransport$p(this.this$0).send(buf, off, len);
            }
        };
        this.dtlsTransport.eventHandler = new DtlsTransport.EventHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
                Intrinsics.checkNotNullParameter((Object)tlsRole, (String)"tlsRole");
                Intrinsics.checkNotNullParameter((Object)keyingMaterial, (String)"keyingMaterial");
                Relay.access$getLogger$p(this.this$0).info((Object)"DTLS handshake complete");
                Relay.access$setSrtpInformation(this.this$0, chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
                this.this$0.scheduleRelayMessageTransportTimeout();
                if (SctpConfig.config.getEnabled() && Relay.access$getSctpRole$p(this.this$0) == Sctp.Role.CLIENT) {
                    DcSctpTransport dcSctpTransport = Relay.access$getSctpTransport$p(this.this$0);
                    Intrinsics.checkNotNull((Object)dcSctpTransport);
                    dcSctpTransport.connect();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setSrtpInformation(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
        SrtpTransformers srtpTransformers;
        SrtpProfileInformation srtpProfileInfo = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(chosenSrtpProtectionProfile);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Transceiver " + this.id + " creating transformers with:\nprofile info:\n" + srtpProfileInfo + "\ntls role: " + tlsRole));
        }
        this.srtpTransformers = srtpTransformers = SrtpUtil.Companion.initializeTransformer(srtpProfileInfo, keyingMaterial, tlsRole, this.cryptex, this.logger);
        this.transceiver.setSrtpInformation(srtpTransformers);
        Object bl = this.endpointsLock;
        synchronized (bl) {
            boolean bl2 = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint it = (RelayedEndpoint)element$iv;
                boolean bl3 = false;
                it.setSrtpInformation(srtpTransformers);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender it = (RelayEndpointSender)element$iv;
            boolean bl4 = false;
            it.setSrtpInformation(srtpTransformers);
        }
    }

    public final void createSctpConnection(@NotNull Sctp sctpDesc) {
        Intrinsics.checkNotNullParameter((Object)sctpDesc, (String)"sctpDesc");
        if (SctpConfig.config.getEnabled()) {
            this.createDcSctpConnection(sctpDesc);
        } else {
            this.logger.error((Object)"Not creating SCTP connection, SCTP is disabled in configuration.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createDcSctpConnection(Sctp sctpDesc) {
        void it;
        DcSctpTransport dcSctpTransport;
        Object object;
        this.sctpRole = sctpDesc.getRole();
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug22 = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            object = $this$cdebug$iv;
            boolean bl = false;
            object.debug((Object)"Creating SCTP transport");
        }
        DcSctpTransport $i$f$cdebug22 = dcSctpTransport = new DcSctpTransport(this.id, this.logger);
        object = this;
        boolean bl = false;
        DcSctpTransport.start$default((DcSctpTransport)it, new SctpCallbacks((DcSctpTransport)it), null, 2, null);
        DcSctpHandler dcSctpHandler = this.sctpHandler;
        Intrinsics.checkNotNull((Object)((Object)dcSctpHandler));
        dcSctpHandler.setSctpTransport((DcSctpTransport)it);
        if (this.dtlsTransport.isConnected() && sctpDesc.getRole() == Sctp.Role.CLIENT) {
            it.connect();
        }
        object.sctpTransport = dcSctpTransport;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransportInfo(@NotNull IceUdpTransportPacketExtension transportInfo) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)transportInfo, (String)"transportInfo");
            Map remoteFingerprints = new LinkedHashMap();
            List fingerprintExtensions = transportInfo.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            Intrinsics.checkNotNull((Object)fingerprintExtensions);
            Iterable $this$forEach$iv = fingerprintExtensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DtlsFingerprintPacketExtension fingerprintExtension = (DtlsFingerprintPacketExtension)element$iv;
                boolean bl = false;
                if (fingerprintExtension.getHash() != null && fingerprintExtension.getFingerprint() != null) {
                    Object object;
                    void key$iv;
                    void $this$getOrPut$iv;
                    Map map = remoteFingerprints;
                    String string = fingerprintExtension.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    List list = (List)object;
                    String string2 = fingerprintExtension.getFingerprint();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFingerprint(...)");
                    list.add(string2);
                } else {
                    this.logger.info((Object)("Ignoring empty DtlsFingerprint extension: " + transportInfo.toXML()));
                }
                if (!CryptexConfig.Companion.getRelay()) continue;
                this.cryptex = this.cryptex && fingerprintExtension.getCryptex();
            }
            this.dtlsTransport.setRemoteFingerprints(remoteFingerprints);
            if (!((Collection)fingerprintExtensions).isEmpty()) {
                String setup = ((DtlsFingerprintPacketExtension)CollectionsKt.first((List)fingerprintExtensions)).getSetup();
                this.dtlsTransport.setSetupAttribute(setup);
            }
            this.iceTransport.startConnectivityEstablishment(transportInfo);
            WebSocketPacketExtension websocketExtension = (WebSocketPacketExtension)transportInfo.getFirstChildOfType(WebSocketPacketExtension.class);
            Object object = websocketExtension;
            if (object == null || (object = object.getUrl()) == null) break block6;
            Object it = object;
            boolean bl = false;
            this.messageTransport.connectToWebsocket((String)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IceUdpTransportPacketExtension describeTransport() {
        Logger logger;
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        this.iceTransport.describe(iceUdpTransportPacketExtension);
        this.dtlsTransport.describe(iceUdpTransportPacketExtension);
        if (this.sctpTransport == null) {
            if (this.messageTransport.isActive()) {
                void $this$describeTransport_u24lambda_u240;
                WebSocketPacketExtension webSocketPacketExtension;
                WebSocketPacketExtension webSocketPacketExtension2 = webSocketPacketExtension = new WebSocketPacketExtension();
                logger = iceUdpTransportPacketExtension;
                boolean bl = false;
                $this$describeTransport_u24lambda_u240.setActive(true);
                logger.addChildExtension((ExtensionElement)webSocketPacketExtension);
            } else {
                ColibriWebSocketService colibriWebSocketService = ColibriWebSocketServiceSupplierKt.getColibriWebSocketServiceSupplier().get();
                if (colibriWebSocketService != null) {
                    ColibriWebSocketService colibriWebsocketService = colibriWebSocketService;
                    boolean bl = false;
                    String string = this.conference.getID();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
                    List<String> urls = colibriWebsocketService.getColibriRelayWebSocketUrls(string, this.id, this.iceTransport.getIcePassword());
                    if (urls.isEmpty()) {
                        this.logger.warn((Object)"No colibri relay URLs configured");
                    }
                    Iterable $this$forEach$iv = urls;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$describeTransport_u24lambda_u241_u240_u240;
                        WebSocketPacketExtension webSocketPacketExtension;
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        WebSocketPacketExtension webSocketPacketExtension3 = webSocketPacketExtension = new WebSocketPacketExtension();
                        IceUdpTransportPacketExtension iceUdpTransportPacketExtension2 = iceUdpTransportPacketExtension;
                        boolean bl3 = false;
                        $this$describeTransport_u24lambda_u241_u240_u240.setUrl(it);
                        iceUdpTransportPacketExtension2.addChildExtension((ExtensionElement)webSocketPacketExtension);
                    }
                }
            }
        }
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Transport description:\n" + iceUdpTransportPacketExtension.toXML()));
        }
        return iceUdpTransportPacketExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFeature(@NotNull EndpointDebugFeatures feature, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                this.transceiver.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled);
                Object object = this.endpointsLock;
                synchronized (object) {
                    boolean bl = false;
                    Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RelayedEndpoint e = (RelayedEndpoint)element$iv;
                        boolean bl2 = false;
                        e.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Collection<RelayEndpointSender> collection = this.senders.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RelayEndpointSender s = (RelayEndpointSender)element$iv;
                    boolean bl = false;
                    s.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled);
                }
                break;
            }
            case 2: {
                if (enabled) {
                    this.toggleablePcapWriter.enable();
                    break;
                }
                this.toggleablePcapWriter.disable();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean isFeatureEnabled(@NotNull EndpointDebugFeatures feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                bl = this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP);
                break;
            }
            case 2: {
                bl = this.toggleablePcapWriter.isEnabled();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final void handleMediaPacket(RelayedPacketInfo packetInfo) {
        if (PacketExtensionsKt.looksLikeRtp((Packet)packetInfo.getPacket())) {
            Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
            long ssrc = RtpHeader.Companion.getSsrc(packetInfo.getPacket().buffer, packetInfo.getPacket().offset);
            RelayedEndpoint ep = this.getEndpointBySsrc(ssrc);
            if (ep != null) {
                ep.handleIncomingPacket(packetInfo);
                return;
            }
            this.logger.warn(() -> Relay.handleMediaPacket$lambda$0(ssrc));
            Function1 function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
            function1.invoke((Object)packetInfo.getPacket().buffer);
        } else if (PacketExtensionsKt.looksLikeRtcp((Packet)packetInfo.getPacket())) {
            Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
            long ssrc = RtcpHeader.Companion.getSenderSsrc(packetInfo.getPacket().buffer, packetInfo.getPacket().offset);
            RelayedEndpoint ep = this.getEndpointBySsrc(ssrc);
            if (ep != null) {
                ep.handleIncomingPacket(packetInfo);
                return;
            }
            this.transceiver.handleIncomingPacket((PacketInfo)packetInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleIncomingPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Packet packet = packetInfo.getPacket();
        if (packet instanceof RtpPacket) {
            RelayedEndpoint relayedEndpoint;
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                relayedEndpoint = this.endpointsBySsrc.get(((RtpPacket)packet).getSsrc());
            }
            RelayedEndpoint ep = relayedEndpoint;
            if (ep != null) {
                packetInfo.setEndpointId(ep.getId());
            }
        }
        this.conference.handleIncomingPacket(packetInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewSsrcAssociation(@NotNull String endpointId, long primarySsrc, long secondarySsrc, @NotNull SsrcAssociationType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this.relayedEndpoints.containsKey(endpointId);
        }
        if (bl) {
            this.transceiver.addSsrcAssociation((SsrcAssociation)new LocalSsrcAssociation(primarySsrc, secondarySsrc, type));
        } else {
            this.transceiver.addSsrcAssociation((SsrcAssociation)new RemoteSsrcAssociation(primarySsrc, secondarySsrc, type));
        }
    }

    public final boolean doSendSrtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        packetInfo.addEvent(SRTP_QUEUE_EXIT_EVENT);
        Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
        this.iceTransport.send(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, packetInfo.getPacket().length);
        PacketTransitStats.packetSent(packetInfo);
        ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
        packetInfo.sent();
        if (this.timelineLogger.isTraceEnabled() && Endpoint.Companion.logTimeline()) {
            this.timelineLogger.trace(() -> Relay.doSendSrtp$lambda$0(packetInfo));
        }
        return true;
    }

    public final void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.messageTransport.sendMessage(msg);
    }

    public final void relayMessageTransportConnected() {
        AbstractEndpoint e;
        Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (RelayedEndpoint)element$iv;
            boolean bl = false;
            ((RelayedEndpoint)e).relayMessageTransportConnected();
        }
        List<AbstractEndpoint> list = this.conference.getEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEndpoints(...)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (AbstractEndpoint)element$iv;
            boolean bl = false;
            if (!(e instanceof Endpoint) && (!(e instanceof RelayedEndpoint) || Intrinsics.areEqual((Object)((RelayedEndpoint)e).getRelay().meshId, (Object)this.meshId))) continue;
            MediaSourceDesc[] $this$forEach$iv2 = e.getMediaSources();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv2;
                MediaSourceDesc msd = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (msd.getVideoType() == VideoType.CAMERA) continue;
                SourceVideoTypeMessage videoTypeMsg = new SourceVideoTypeMessage(msd.getVideoType(), msd.getSourceName(), e.getId());
                this.sendMessage(videoTypeMsg);
            }
        }
    }

    public final void dtlsAppPacketReceived(@NotNull byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.sctpPipeline.processPacket(new PacketInfo((Packet)new UnparsedPacket(data, off, len), 0, null, 6, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final RelayedEndpoint addRemoteEndpoint(@NotNull String id, @Nullable String statsId, @NotNull Collection<AudioSourceDesc> audioSources, @NotNull Collection<MediaSourceDesc> videoSources) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(audioSources, (String)"audioSources");
        Intrinsics.checkNotNullParameter(videoSources, (String)"videoSources");
        RelayedEndpoint ep = null;
        Object object = this.endpointsLock;
        synchronized (object) {
            void $this$addRemoteEndpoint_u24lambda_u240_u240;
            DiagnosticContext diagnosticContext;
            block8: {
                boolean bl = false;
                if (!this.relayedEndpoints.containsKey(id)) break block8;
                this.logger.warn((Object)("Relay already contains remote endpoint with ID " + id));
                this.updateRemoteEndpoint(id, audioSources, videoSources);
                RelayedEndpoint relayedEndpoint = null;
                return relayedEndpoint;
            }
            DiagnosticContext diagnosticContext2 = diagnosticContext = this.conference.newDiagnosticContext();
            Logger logger = this.logger;
            String string = id;
            Relay relay = this;
            Conference conference = this.conference;
            boolean bl = false;
            $this$addRemoteEndpoint_u24lambda_u240_u240.put((Object)"relay_id", (Object)this.id);
            $this$addRemoteEndpoint_u24lambda_u240_u240.put((Object)"endpoint_id", (Object)id);
            Unit unit = Unit.INSTANCE;
            DiagnosticContext diagnosticContext3 = diagnosticContext;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticContext3, (String)"apply(...)");
            DiagnosticContext diagnosticContext4 = diagnosticContext3;
            Logger logger2 = logger;
            String string2 = string;
            Relay relay2 = relay;
            Conference conference2 = conference;
            ep = new RelayedEndpoint(conference2, relay2, string2, logger2, diagnosticContext4);
            ep.setStatsId(statsId);
            ep.setAudioSources(CollectionsKt.toList((Iterable)audioSources));
            Collection<MediaSourceDesc> $this$toTypedArray$iv = videoSources;
            boolean $i$f$toTypedArray = false;
            Collection<MediaSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
            ep.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
            ((Map)this.relayedEndpoints).put(id, ep);
            Iterable $this$forEach$iv = ep.getSsrcs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long ssrc = (Long)element$iv;
                boolean bl2 = false;
                ((Map)this.endpointsBySsrc).put(ssrc, ep);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        SrtpTransformers srtpTransformers = this.srtpTransformers;
        if (srtpTransformers != null) {
            SrtpTransformers it = srtpTransformers;
            boolean bl = false;
            ep.setSrtpInformation(it);
        }
        Iterable $this$forEach$iv = this.payloadTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PayloadType payloadType = (PayloadType)element$iv;
            boolean bl = false;
            ep.addPayloadType(payloadType);
        }
        $this$forEach$iv = this.rtpExtensions;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpExtension rtpExtension = (RtpExtension)element$iv;
            boolean bl = false;
            ep.addRtpExtension(rtpExtension);
        }
        ep.setExtmapAllowMixed(this.extmapAllowMixed);
        this.setEndpointMediaSources(ep, audioSources, videoSources);
        ep.setFeature(Features.TRANSCEIVER_PCAP_DUMP, this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP));
        return ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateRemoteEndpoint(@NotNull String id, @NotNull Collection<AudioSourceDesc> audioSources, @NotNull Collection<MediaSourceDesc> videoSources) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(audioSources, (String)"audioSources");
        Intrinsics.checkNotNullParameter(videoSources, (String)"videoSources");
        RelayedEndpoint ep = null;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            RelayedEndpoint relayedEndpoint = this.relayedEndpoints.get(id);
            if (relayedEndpoint == null) {
                Relay $this$updateRemoteEndpoint_u24lambda_u240_u240 = this;
                boolean bl2 = false;
                $this$updateRemoteEndpoint_u24lambda_u240_u240.logger.warn((Object)("Endpoint with ID " + id + " not found in relay"));
                return;
            }
            ep = relayedEndpoint;
            Set oldSsrcs = ep.getSsrcs();
            ep.setAudioSources(CollectionsKt.toList((Iterable)audioSources));
            Collection<MediaSourceDesc> $this$toTypedArray$iv = videoSources;
            boolean $i$f$toTypedArray = false;
            Collection<MediaSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
            ep.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
            Set newSsrcs = ep.getSsrcs();
            Set removedSsrcs = SetsKt.minus((Set)oldSsrcs, (Iterable)newSsrcs);
            Set addedSsrcs = SetsKt.minus((Set)newSsrcs, (Iterable)oldSsrcs);
            this.endpointsBySsrc.keySet().removeAll(removedSsrcs);
            Iterable $this$forEach$iv = addedSsrcs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long ssrc = (Long)element$iv;
                boolean bl3 = false;
                ((Map)this.endpointsBySsrc).put(ssrc, ep);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.setEndpointMediaSources(ep, audioSources, videoSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRemoteEndpoint(@NotNull String id) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            RelayedEndpoint ep = null;
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                ep = this.relayedEndpoints.remove(id);
                if (ep != null) {
                    this.endpointsBySsrc.keySet().removeAll(ep.getSsrcs());
                }
                Unit unit = Unit.INSTANCE;
            }
            RelayedEndpoint relayedEndpoint = ep;
            if (relayedEndpoint == null) break block4;
            relayedEndpoint.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final RelayEndpointSender getOrCreateRelaySender(String endpointId) {
        ConcurrentHashMap<String, RelayEndpointSender> concurrentHashMap = this.senders;
        synchronized (concurrentHashMap) {
            void $this$getOrCreateRelaySender_u24lambda_u240_u241;
            DiagnosticContext it2;
            block7: {
                boolean bl = false;
                RelayEndpointSender relayEndpointSender = this.senders.get(endpointId);
                if (relayEndpointSender == null) break block7;
                RelayEndpointSender it2 = relayEndpointSender;
                boolean bl2 = false;
                RelayEndpointSender relayEndpointSender2 = it2;
                return relayEndpointSender2;
            }
            DiagnosticContext bl2 = it2 = this.conference.newDiagnosticContext();
            Logger logger = this.logger;
            String string = endpointId;
            Relay relay = this;
            boolean bl = false;
            $this$getOrCreateRelaySender_u24lambda_u240_u241.put((Object)"relay_id", (Object)this.id);
            $this$getOrCreateRelaySender_u24lambda_u240_u241.put((Object)"endpoint_id", (Object)endpointId);
            Unit unit = Unit.INSTANCE;
            DiagnosticContext diagnosticContext = it2;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticContext, (String)"apply(...)");
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            Logger logger2 = logger;
            String string2 = string;
            Relay relay2 = relay;
            RelayEndpointSender s = new RelayEndpointSender(relay2, string2, logger2, diagnosticContext2);
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                SrtpTransformers it3 = srtpTransformers;
                boolean bl3 = false;
                s.setSrtpInformation(it3);
            }
            Iterable $this$forEach$iv = this.payloadTypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadType payloadType = (PayloadType)element$iv;
                boolean bl4 = false;
                s.addPayloadType(payloadType);
            }
            $this$forEach$iv = this.rtpExtensions;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpExtension rtpExtension = (RtpExtension)element$iv;
                boolean bl5 = false;
                s.addRtpExtension(rtpExtension);
            }
            s.setExtmapAllowMixed(this.extmapAllowMixed);
            s.setFeature(Features.TRANSCEIVER_PCAP_DUMP, this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP));
            ((Map)this.senders).put(endpointId, s);
            RelayEndpointSender relayEndpointSender = s;
            return relayEndpointSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter((Object)payloadType, (String)"payloadType");
        this.transceiver.addPayloadType(payloadType);
        this.payloadTypes.add(payloadType);
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.addPayloadType(payloadType);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s.addPayloadType(payloadType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter((Object)rtpExtension, (String)"rtpExtension");
        if (rtpExtension.getType() == RtpExtensionType.TRANSPORT_CC || rtpExtension.getType() == RtpExtensionType.ABS_SEND_TIME) {
            return;
        }
        this.transceiver.addRtpExtension(rtpExtension);
        this.rtpExtensions.add(rtpExtension);
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.addRtpExtension(rtpExtension);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s.addRtpExtension(rtpExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExtmapAllowMixed(boolean allow) {
        this.transceiver.setExtmapAllowMixed(allow);
        this.extmapAllowMixed = allow;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.setExtmapAllowMixed(allow);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s.setExtmapAllowMixed(allow);
        }
    }

    private final void setEndpointMediaSources(RelayedEndpoint ep, Collection<AudioSourceDesc> audioSources, Collection<MediaSourceDesc> videoSources) {
        ep.setAudioSources(CollectionsKt.toList((Iterable)audioSources));
        Collection<MediaSourceDesc> $this$toTypedArray$iv = videoSources;
        boolean $i$f$toTypedArray = false;
        Collection<MediaSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
        ep.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RelayedEndpoint getEndpoint(@NotNull String id) {
        RelayedEndpoint relayedEndpoint;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            relayedEndpoint = this.relayedEndpoints.get(id);
        }
        return relayedEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RelayedEndpoint getEndpointBySsrc(long ssrc) {
        RelayedEndpoint relayedEndpoint;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            relayedEndpoint = this.endpointsBySsrc.get(ssrc);
        }
        return relayedEndpoint;
    }

    public final void scheduleRelayMessageTransportTimeout() {
        TaskPools.SCHEDULED_POOL.schedule(() -> Relay.scheduleRelayMessageTransportTimeout$lambda$0(this), 30L, TimeUnit.SECONDS);
    }

    public final boolean acceptWebSocket(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (!Intrinsics.areEqual((Object)this.iceTransport.getIcePassword(), (Object)password)) {
            this.logger.warn((Object)("Incoming web socket request with an invalid password. Expected: " + this.iceTransport.getIcePassword() + " received " + password));
            return false;
        }
        return true;
    }

    private final Collection<Long> getRtcpSsrcs(RtcpPacket packet) {
        HashSet<Long> ssrcs = new HashSet<Long>();
        ssrcs.add(packet.getSenderSsrc());
        RtcpPacket rtcpPacket = packet;
        if (rtcpPacket instanceof CompoundRtcpPacket) {
            Iterable $this$forEach$iv = ((CompoundRtcpPacket)packet).getPackets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpPacket it = (RtcpPacket)element$iv;
                boolean bl = false;
                ssrcs.addAll(this.getRtcpSsrcs(it));
            }
        } else if (rtcpPacket instanceof RtcpFbFirPacket) {
            ssrcs.add(((RtcpFbFirPacket)packet).getMediaSenderSsrc());
        } else if (rtcpPacket instanceof RtcpFbPacket) {
            ssrcs.add(((RtcpFbPacket)packet).getMediaSourceSsrc());
        } else if (rtcpPacket instanceof RtcpSrPacket) {
            Iterable $this$forEach$iv = ((RtcpSrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock it = (RtcpReportBlock)element$iv;
                boolean bl = false;
                ssrcs.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpRrPacket) {
            Iterable $this$forEach$iv = ((RtcpRrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock it = (RtcpReportBlock)element$iv;
                boolean bl = false;
                ssrcs.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpSdesPacket) {
            Iterable $this$forEach$iv = ((RtcpSdesPacket)packet).getSdesChunks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SdesChunk it = (SdesChunk)element$iv;
                boolean bl = false;
                ssrcs.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpByePacket) {
            ssrcs.addAll(((RtcpByePacket)packet).getSsrcs());
        }
        return ssrcs;
    }

    private final void doRtcpCallbacks(RtcpPacket packet, String endpointId, Function1<? super RtcpEventNotifier, Unit> callback) {
        Collection<Long> ssrcs = this.getRtcpSsrcs(packet);
        HashSet<String> eps = new HashSet<String>();
        Iterable $this$forEach$iv = ssrcs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractEndpoint it;
            long it2 = ((Number)element$iv).longValue();
            boolean bl = false;
            if (this.conference.getEndpointBySsrc(it2) == null) continue;
            boolean bl2 = false;
            eps.add(it.getId());
        }
        String string = endpointId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            eps.remove(it);
        }
        $this$forEach$iv = eps;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            String epId = (String)element$iv;
            boolean bl = false;
            if (this.getEndpoint(epId) != null) {
                boolean bl3 = false;
                callback.invoke((Object)((RelayedEndpoint)it).getRtcpEventNotifier());
            }
            if (this.senders.get(epId) == null) continue;
            boolean bl4 = false;
            callback.invoke((Object)((RelayEndpointSender)it).getRtcpEventNotifier());
        }
        if (endpointId != null) {
            callback.invoke((Object)this.transceiver.getRtcpEventNotifier());
        }
    }

    public final void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime, @Nullable String endpointId) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.doRtcpCallbacks(packet, endpointId, (Function1<? super RtcpEventNotifier, Unit>)((Function1)arg_0 -> Relay.rtcpPacketReceived$lambda$0(packet, receivedTime, arg_0)));
    }

    public final void rtcpPacketSent(@NotNull RtcpPacket packet, @Nullable String endpointId) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.doRtcpCallbacks(packet, endpointId, (Function1<? super RtcpEventNotifier, Unit>)((Function1)arg_0 -> Relay.rtcpPacketSent$lambda$0(packet, arg_0)));
    }

    private final boolean isTransportConnected() {
        return this.iceTransport.isConnected() && this.dtlsTransport.isConnected();
    }

    @Override
    public boolean wants(@NotNull PacketInfo packet) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!this.isTransportConnected()) {
            return false;
        }
        if (packet instanceof RelayedPacketInfo && Intrinsics.areEqual((Object)((RelayedPacketInfo)packet).getMeshId(), (Object)this.meshId)) {
            return false;
        }
        Packet packet2 = packet.getPacket();
        if (packet2 instanceof VideoRtpPacket || packet2 instanceof AudioRtpPacket || packet2 instanceof RtcpSrPacket || packet2 instanceof RtcpFbPliPacket || packet2 instanceof RtcpFbFirPacket) {
            bl = true;
        } else {
            this.logger.warn((Object)("Ignoring an unknown packet type:" + packet.getPacket().getClass().getSimpleName()));
            bl = false;
        }
        return bl;
    }

    @Override
    public void send(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        String string = packet.getEndpointId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.getOrCreateRelaySender(it).sendPacket(packet);
        } else {
            Relay $this$send_u24lambda_u241 = this;
            boolean bl = false;
            $this$send_u24lambda_u241.transceiver.sendPacket(packet);
        }
    }

    public final void endpointExpired(@NotNull String id) {
        block0: {
            RelayEndpointSender s;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            RelayEndpointSender relayEndpointSender = s = this.senders.remove(id);
            if (relayEndpointSender == null) break block0;
            relayEndpointSender.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long getIncomingBitrateBps() {
        long l;
        Object object = this.endpointsLock;
        long l2 = this.transceiver.getTransceiverStats().getRtpReceiverStats().getPacketStreamStats().getBitrateBps();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            long l3 = 0L;
            for (Object t : iterable) {
                void it;
                RelayedEndpoint relayedEndpoint = (RelayedEndpoint)t;
                long l4 = l3;
                boolean bl2 = false;
                long l5 = it.getIncomingStats().getBitrateBps();
                l3 = l4 + l5;
            }
            l = l3;
        }
        long l6 = l;
        return l2 + l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long getIncomingPacketRate() {
        long l;
        Object object = this.endpointsLock;
        long l2 = this.transceiver.getTransceiverStats().getRtpReceiverStats().getPacketStreamStats().getPacketRate();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            long l3 = 0L;
            for (Object t : iterable) {
                void it;
                RelayedEndpoint relayedEndpoint = (RelayedEndpoint)t;
                long l4 = l3;
                boolean bl2 = false;
                long l5 = it.getIncomingStats().getPacketRate();
                l3 = l4 + l5;
            }
            l = l3;
        }
        long l6 = l;
        return l2 + l6;
    }

    /*
     * WARNING - void declaration
     */
    public final long getOutgoingBitrateBps() {
        long l;
        long l2 = this.transceiver.getTransceiverStats().getOutgoingPacketStreamStats().getBitrateBps();
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        long l3 = l2;
        long l4 = 0L;
        for (Object t : iterable) {
            void it;
            RelayEndpointSender relayEndpointSender = (RelayEndpointSender)t;
            l = l4;
            boolean bl = false;
            long l5 = it.getOutgoingStats().getBitrateBps();
            l4 = l + l5;
        }
        l = l4;
        return l3 + l;
    }

    /*
     * WARNING - void declaration
     */
    public final long getOutgoingPacketRate() {
        long l;
        long l2 = this.transceiver.getTransceiverStats().getOutgoingPacketStreamStats().getPacketRate();
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        long l3 = l2;
        long l4 = 0L;
        for (Object t : iterable) {
            void it;
            RelayEndpointSender relayEndpointSender = (RelayEndpointSender)t;
            l = l4;
            boolean bl = false;
            long l5 = it.getOutgoingStats().getPacketRate();
            l4 = l + l5;
        }
        l = l4;
        return l3 + l;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStatsOnExpire() {
        void $this$filterTo$iv$iv;
        TransceiverStats transceiverStats = this.transceiver.getTransceiverStats();
        PacketStreamStats.Snapshot incomingStats = transceiverStats.getRtpReceiverStats().getPacketStreamStats();
        PacketStreamStats.Snapshot outgoingStats = transceiverStats.getOutgoingPacketStreamStats();
        this.statistics.getBytesReceived().getAndAdd(incomingStats.getBytes());
        this.statistics.getPacketsReceived().getAndAdd(incomingStats.getPackets());
        this.statistics.getBytesSent().getAndAdd(outgoingStats.getBytes());
        this.statistics.getPacketsSent().getAndAdd(outgoingStats.getPackets());
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.totalRelayBytesReceived, (long)this.statistics.getBytesReceived().get(), null, (int)2, null);
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.totalRelayBytesSent, (long)this.statistics.getBytesSent().get(), null, (int)2, null);
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.relayPacketsReceived, (long)this.statistics.getPacketsReceived().get(), null, (int)2, null);
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.relayPacketsSent, (long)this.statistics.getPacketsSent().get(), null, (int)2, null);
        CounterMetric.addAndGet$default((CounterMetric)VideobridgeMetrics.keyframesReceived, (long)transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumKeyframes(), null, (int)2, null);
        CounterMetric.addAndGet$default((CounterMetric)VideobridgeMetrics.layeringChangesReceived, (long)transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumLayeringChanges(), null, (int)2, null);
        Iterable $this$filter$iv = transceiverStats.getRtpReceiverStats().getIncomingStats().getSsrcStats().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncomingSsrcStats.Snapshot it = (IncomingSsrcStats.Snapshot)element$iv$iv;
            boolean bl = false;
            if (!(it.getMediaType() == MediaType.VIDEO)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Duration durationActiveVideo = DurationKt.sumOf((Iterable)((List)destination$iv$iv), Relay::updateStatsOnExpire$lambda$1);
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.totalVideoStreamMillisecondsReceived, (long)durationActiveVideo.toMillis(), null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expire() {
        this.expired = true;
        this.logger.info((Object)"Expiring.");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean $i$a$-synchronized-Relay$expire$22 = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint it = (RelayedEndpoint)element$iv;
                boolean bl = false;
                it.expire();
            }
            Unit $i$a$-synchronized-Relay$expire$22 = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender it = (RelayEndpointSender)element$iv;
            boolean bl = false;
            it.expire();
        }
        this.conference.relayExpired(this);
        try {
            Logger logger;
            this.updateStatsOnExpire();
            this.transceiver.stop();
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                srtpTransformers.close();
            }
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)this.transceiver.debugState(DebugStateMode.FULL).toJSONString());
            }
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)this.iceTransport.getDebugState().toJSONString());
            }
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)this.dtlsTransport.getDebugState().toJSONString());
            }
            this.transceiver.teardown();
            this.messageTransport.close();
            DcSctpHandler dcSctpHandler = this.sctpHandler;
            if (dcSctpHandler != null) {
                dcSctpHandler.stop();
            }
            DcSctpTransport dcSctpTransport = this.sctpTransport;
            if (dcSctpTransport != null) {
                dcSctpTransport.stop();
            }
        }
        catch (Throwable t) {
            this.logger.error((Object)"Exception while expiring: ", t);
        }
        this.conference.getEncodingsManager().unsubscribe(this);
        this.dtlsTransport.stop();
        this.iceTransport.stop();
        this.outgoingSrtpPacketQueue.close();
        this.logger.info((Object)"Expired.");
    }

    @JvmOverloads
    public Relay(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, @Nullable String meshId, boolean iceControlling, boolean useUniquePort) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this(id, conference, parentLogger, meshId, iceControlling, useUniquePort, null, 64, null);
    }

    private static final Unit sctpPipeline$lambda$0(Relay this$0, PipelineBuilder $this$pipeline) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$pipeline, (String)"$this$pipeline");
            PipelineBuilder.node$default((PipelineBuilder)$this$pipeline, (Node)((Node)this$0.sctpRecvPcap), null, (int)2, null);
            DcSctpHandler dcSctpHandler = this$0.sctpHandler;
            if (dcSctpHandler == null) break block0;
            DcSctpHandler it = dcSctpHandler;
            boolean bl = false;
            PipelineBuilder.node$default((PipelineBuilder)$this$pipeline, (Node)((Node)it), null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean incomingDataChannelMessagesQueue$lambda$0(Relay this$0, PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        this$0.dataChannelHandler.consume(packetInfo);
        return true;
    }

    private static final String handleMediaPacket$lambda$0(long $ssrc) {
        return "RTP Packet received for unknown endpoint SSRC " + $ssrc;
    }

    private static final String doSendSrtp$lambda$0(PacketInfo $packetInfo) {
        return String.valueOf($packetInfo.getTimeline());
    }

    private static final void scheduleRelayMessageTransportTimeout$lambda$0(Relay this$0) {
        if (!this$0.expired && !this$0.messageTransport.isConnected()) {
            this$0.logger.error((Object)"RelayMessageTransport still not connected.");
            CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.numRelaysNoMessageTransportAfterDelay, null, (int)1, null);
        }
    }

    private static final Unit rtcpPacketReceived$lambda$0(RtcpPacket $packet, Instant $receivedTime, RtcpEventNotifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.notifyRtcpReceived($packet, $receivedTime, true);
        return Unit.INSTANCE;
    }

    private static final Unit rtcpPacketSent$lambda$0(RtcpPacket $packet, RtcpEventNotifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.notifyRtcpSent($packet, true);
        return Unit.INSTANCE;
    }

    private static final Duration updateStatsOnExpire$lambda$1(IncomingSsrcStats.Snapshot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDurationActive();
    }

    public static final /* synthetic */ void access$handleMediaPacket(Relay $this, RelayedPacketInfo packetInfo) {
        $this.handleMediaPacket(packetInfo);
    }

    public static final /* synthetic */ PacketInfoQueue access$getOutgoingSrtpPacketQueue$p(Relay $this) {
        return $this.outgoingSrtpPacketQueue;
    }

    public static final /* synthetic */ IceTransport access$getIceTransport$p(Relay $this) {
        return $this.iceTransport;
    }

    public static final /* synthetic */ void access$setSrtpInformation(Relay $this, int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
        $this.setSrtpInformation(chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
    }

    public static final /* synthetic */ CounterMetric access$getDroppedPacketsMetric$cp() {
        return droppedPacketsMetric;
    }

    public static final /* synthetic */ CounterMetric access$getExceptionsMetric$cp() {
        return exceptionsMetric;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/relay/Relay$Companion;", "", "<init>", "()V", "droppedPacketsMetric", "Lorg/jitsi/metrics/CounterMetric;", "exceptionsMetric", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "SRTP_QUEUE_ENTRY_EVENT", "", "SRTP_QUEUE_EXIT_EVENT", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/jitsi/videobridge/relay/Relay$IncomingRelayPacketHandler;", "", "handleIncomingPacket", "", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "jitsi-videobridge"})
    public static interface IncomingRelayPacketHandler {
        public void handleIncomingPacket(@NotNull RelayedPacketInfo var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/relay/Relay$SctpCallbacks;", "Lorg/jitsi/videobridge/dcsctp/DcSctpBaseCallbacks;", "transport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "<init>", "(Lorg/jitsi/videobridge/relay/Relay;Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;)V", "sendPacketWithStatus", "Lorg/jitsi/dcsctp4j/SendPacketStatus;", "packet", "", "OnMessageReceived", "", "message", "Lorg/jitsi/dcsctp4j/DcSctpMessage;", "OnError", "error", "Lorg/jitsi/dcsctp4j/ErrorKind;", "", "OnAborted", "OnConnected", "OnClosed", "jitsi-videobridge"})
    private final class SctpCallbacks
    extends DcSctpBaseCallbacks {
        public SctpCallbacks(DcSctpTransport transport) {
            Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
            super(transport, null, 2, null);
        }

        @NotNull
        public SendPacketStatus sendPacketWithStatus(@NotNull byte[] packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            try {
                byte[] newBuf = ByteBufferPool.getBuffer(packet.length);
                System.arraycopy(packet, 0, newBuf, 0, packet.length);
                ToggleablePcapWriter.PcapWriterNode pcapWriterNode = Relay.this.sctpSendPcap;
                Intrinsics.checkNotNull((Object)newBuf);
                pcapWriterNode.observe(newBuf, 0, packet.length);
                Relay.this.dtlsTransport.sendDtlsData(newBuf, 0, packet.length);
                return SendPacketStatus.kSuccess;
            }
            catch (Throwable e) {
                Relay.this.logger.warn((Object)"Exception sending SCTP packet", e);
                return SendPacketStatus.kError;
            }
        }

        public void OnMessageReceived(@NotNull DcSctpMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                DataChannelPacket dataChannelPacket = new DataChannelPacket(message);
                Relay.this.incomingDataChannelMessagesQueue.add((Object)new PacketInfo((Packet)dataChannelPacket, 0, null, 6, null));
            }
            catch (Throwable e) {
                Relay.this.logger.warn((Object)"Exception processing SCTP message", e);
            }
        }

        public void OnError(@NotNull ErrorKind error, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Relay.this.logger.warn((Object)("SCTP error " + error + ": " + message));
        }

        public void OnAborted(@NotNull ErrorKind error, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Relay.this.logger.info((Object)("SCTP aborted with error " + error + ": " + message));
        }

        public void OnConnected() {
            try {
                Relay.this.logger.info((Object)"SCTP connection is ready, creating the Data channel stack");
                DataChannelStack dataChannelStack = new DataChannelStack((arg_0, arg_1, arg_2) -> SctpCallbacks.OnConnected$lambda$0(Relay.this, arg_0, arg_1, arg_2), Relay.this.logger);
                Relay.this.dataChannelStack = dataChannelStack;
                dataChannelStack.onDataChannelStackEvents(arg_0 -> SctpCallbacks.OnConnected$lambda$1(Relay.this, arg_0));
                Relay.this.dataChannelHandler.setDataChannelStack(dataChannelStack);
                if (Relay.this.sctpRole == Sctp.Role.CLIENT) {
                    Relay.this.logger.info((Object)"Will open the data channel.");
                    DataChannel dataChannel = dataChannelStack.createDataChannel(0, 0, 0L, 0, "default");
                    RelayMessageTransport relayMessageTransport = Relay.this.messageTransport;
                    Intrinsics.checkNotNull((Object)dataChannel);
                    relayMessageTransport.setDataChannel(dataChannel);
                    dataChannel.open();
                } else {
                    Relay.this.logger.info((Object)"Will wait for the remote side to open the data channel.");
                }
            }
            catch (Throwable e) {
                Relay.this.logger.warn((Object)"Exception processing SCTP connected event", e);
            }
        }

        public void OnClosed() {
            Relay.this.logger.info((Object)"SCTP connection closed");
        }

        private static final int OnConnected$lambda$0(Relay this$0, ByteBuffer data, int sid, int ppid) {
            int n;
            SendStatus status;
            DcSctpMessage message = new DcSctpMessage((short)sid, ppid, data.array());
            DcSctpTransport dcSctpTransport = this$0.sctpTransport;
            SendStatus sendStatus = status = dcSctpTransport != null ? dcSctpTransport.send(message, DcSctpTransport.Companion.getDEFAULT_SEND_OPTIONS()) : null;
            if (status == SendStatus.kSuccess) {
                n = 0;
            } else {
                this$0.logger.error((Object)("Error sending to SCTP: " + status));
                n = -1;
            }
            return n;
        }

        private static final void OnConnected$lambda$1(Relay this$0, DataChannel dataChannel) {
            this$0.logger.info((Object)"Remote side opened a data channel.");
            RelayMessageTransport relayMessageTransport = this$0.messageTransport;
            Intrinsics.checkNotNull((Object)dataChannel);
            relayMessageTransport.setDataChannel(dataChannel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/relay/Relay$Statistics;", "", "<init>", "()V", "bytesReceived", "Ljava/util/concurrent/atomic/AtomicLong;", "getBytesReceived", "()Ljava/util/concurrent/atomic/AtomicLong;", "packetsReceived", "getPacketsReceived", "bytesSent", "getBytesSent", "packetsSent", "getPacketsSent", "getJson", "Lorg/json/simple/JSONObject;", "jitsi-videobridge"})
    public static final class Statistics {
        @NotNull
        private final AtomicLong bytesReceived = new AtomicLong(0L);
        @NotNull
        private final AtomicLong packetsReceived = new AtomicLong(0L);
        @NotNull
        private final AtomicLong bytesSent = new AtomicLong(0L);
        @NotNull
        private final AtomicLong packetsSent = new AtomicLong(0L);

        @NotNull
        public final AtomicLong getBytesReceived() {
            return this.bytesReceived;
        }

        @NotNull
        public final AtomicLong getPacketsReceived() {
            return this.packetsReceived;
        }

        @NotNull
        public final AtomicLong getBytesSent() {
            return this.bytesSent;
        }

        @NotNull
        public final AtomicLong getPacketsSent() {
            return this.packetsSent;
        }

        private final JSONObject getJson() {
            JSONObject jsonObject = new JSONObject();
            ((Map)jsonObject).put("bytes_received", this.bytesReceived.get());
            ((Map)jsonObject).put("bytes_sent", this.bytesSent.get());
            ((Map)jsonObject).put("packets_received", this.packetsReceived.get());
            ((Map)jsonObject).put("packets_sent", this.packetsSent.get());
            return jsonObject;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0017\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl;", "Lorg/jitsi/nlj/TransceiverEventHandler;", "<init>", "(Lorg/jitsi/videobridge/relay/Relay;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(J)V", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,1205:1\n63#2,4:1206\n*S KotlinDebug\n*F\n+ 1 Relay.kt\norg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl\n*L\n1196#1:1206,4\n*E\n"})
    private final class TransceiverEventHandlerImpl
    implements TransceiverEventHandler {
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            Relay.this.logger.warn(() -> TransceiverEventHandlerImpl.audioLevelReceived$lambda$0(sourceSsrc));
            return false;
        }

        public void bandwidthEstimationChanged-_2icLw0(long l) {
            Logger $this$cdebug$iv = Relay.this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)("Estimated bandwidth is now " + Bandwidth.toString-impl((long)l)));
            }
        }

        private static final String audioLevelReceived$lambda$0(long $sourceSsrc) {
            return "Audio level reported by relay transceiver for source " + $sourceSsrc;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EndpointDebugFeatures.values().length];
            try {
                nArray[EndpointDebugFeatures.PCAP_DUMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndpointDebugFeatures.SCTP_PCAP_DUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

