/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpHeader;", "", "<init>", "()V", "Companion", "rtp"})
public final class RtcpHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int SIZE_BYTES = 8;
    public static final int VERSION_OFFSET = 0;
    public static final int PADDING_OFFSET = 0;
    public static final int REPORT_COUNT_OFFSET = 0;
    public static final int PACKET_TYPE_OFFSET = 1;
    public static final int LENGTH_OFFSET = 2;
    public static final int SENDER_SSRC_OFFSET = 4;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpHeader$Companion;", "", "<init>", "()V", "SIZE_BYTES", "", "VERSION_OFFSET", "PADDING_OFFSET", "REPORT_COUNT_OFFSET", "PACKET_TYPE_OFFSET", "LENGTH_OFFSET", "SENDER_SSRC_OFFSET", "getVersion", "buf", "", "headerStartOffset", "setVersion", "", "version", "hasPadding", "", "setPadding", "getReportCount", "setReportCount", "reportCount", "getPacketType", "setPacketType", "packetType", "getLength", "setLength", "length", "getSenderSsrc", "", "setSenderSsrc", "senderSsrc", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getVersion(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getBitsAsInt(buf, headerStartOffset + 0, 0, 2);
        }

        public final void setVersion(@NotNull byte[] buf, int headerStartOffset, int version) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            FieldParsersKt.putNumberAsBits(buf, headerStartOffset + 0, 0, 2, version);
        }

        public final boolean hasPadding(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return ByteArrayExtensionsKt.getBitAsBool(buf, headerStartOffset + 0, 2);
        }

        public final void setPadding(@NotNull byte[] buf, int headerStartOffset, boolean hasPadding) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putBitAsBoolean(buf, headerStartOffset + 0, 2, hasPadding);
        }

        public final int getReportCount(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getBitsAsInt(buf, headerStartOffset + 0, 3, 5);
        }

        public final void setReportCount(@NotNull byte[] buf, int headerStartOffset, int reportCount) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            FieldParsersKt.putNumberAsBits(buf, headerStartOffset + 0, 3, 5, reportCount);
        }

        public final int getPacketType(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getByteAsInt(buf, headerStartOffset + 1);
        }

        public final void setPacketType(@NotNull byte[] buf, int headerStartOffset, int packetType) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            buf[headerStartOffset + 1] = (byte)packetType;
        }

        public final int getLength(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getShortAsInt(buf, headerStartOffset + 2);
        }

        public final void setLength(@NotNull byte[] buf, int headerStartOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putShort(buf, headerStartOffset + 2, (short)length);
        }

        public final long getSenderSsrc(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getIntAsLong(buf, headerStartOffset + 4);
        }

        public final void setSenderSsrc(@NotNull byte[] buf, int headerStartOffset, long senderSsrc) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, headerStartOffset + 4, (int)senderSsrc);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

