/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.dtls.DtlsUtilsKt;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u00072\u0010\u0010\u001f\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010)\u001a\u00020\u0007H\u0016J\u0012\u0010*\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0006H\u0016J,\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0018\u00104\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0013\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0014\u00a2\u0006\u0002\u00108R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00069"}, d2={"Lorg/jitsi/nlj/dtls/TlsServerImpl;", "Lorg/bouncycastle/tls/DefaultTlsServer;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "notifyClientCertificateReceived", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "session", "Lorg/bouncycastle/tls/TlsSession;", "value", "", "srtpKeyingMaterial", "getSrtpKeyingMaterial", "()[B", "chosenSrtpProtectionProfile", "", "getChosenSrtpProtectionProfile", "()I", "setChosenSrtpProtectionProfile", "(I)V", "getSessionToResume", "sessionID", "getServerExtensions", "Ljava/util/Hashtable;", "processClientExtensions", "clientExtensions", "getCipherSuites", "", "getRSAEncryptionCredentials", "Lorg/bouncycastle/tls/TlsCredentialedDecryptor;", "getECDSASignerCredentials", "Lorg/bouncycastle/tls/TlsCredentialedSigner;", "getCertificateRequest", "Lorg/bouncycastle/tls/CertificateRequest;", "getHandshakeTimeoutMillis", "notifyHandshakeComplete", "notifyClientCertificate", "clientCertificate", "notifyAlertRaised", "alertLevel", "", "alertDescription", "message", "", "cause", "", "notifyAlertReceived", "getSupportedVersions", "", "Lorg/bouncycastle/tls/ProtocolVersion;", "()[Lorg/bouncycastle/tls/ProtocolVersion;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nTlsServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsServerImpl.kt\norg/jitsi/nlj/dtls/TlsServerImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtilsKt\n*L\n1#1,173:1\n57#2,4:174\n57#2,4:178\n57#2,4:182\n63#2,4:188\n57#2,2:200\n60#2:204\n57#2,4:208\n75#2:213\n76#2:216\n296#3,2:186\n299#3,8:192\n307#3,2:202\n312#3:205\n316#3,2:206\n318#3:212\n319#3,2:214\n323#3:217\n*S KotlinDebug\n*F\n+ 1 TlsServerImpl.kt\norg/jitsi/nlj/dtls/TlsServerImpl\n*L\n127#1:174,4\n133#1:178,4\n136#1:182,4\n166#1:188,4\n166#1:200,2\n166#1:204\n169#1:208,4\n169#1:213\n169#1:216\n166#1:186,2\n166#1:192,8\n166#1:202,2\n166#1:205\n169#1:206,2\n169#1:212\n169#1:214,2\n169#1:217\n*E\n"})
public final class TlsServerImpl
extends DefaultTlsServer {
    @NotNull
    private final CertificateInfo certificateInfo;
    @NotNull
    private final Function1<Certificate, Unit> notifyClientCertificateReceived;
    @NotNull
    private final Logger logger;
    @Nullable
    private TlsSession session;
    private byte[] srtpKeyingMaterial;
    private int chosenSrtpProtectionProfile;

    public TlsServerImpl(@NotNull CertificateInfo certificateInfo, @NotNull Function1<? super Certificate, Unit> notifyClientCertificateReceived, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)certificateInfo, (String)"certificateInfo");
        Intrinsics.checkNotNullParameter(notifyClientCertificateReceived, (String)"notifyClientCertificateReceived");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super((TlsCrypto)DtlsUtilsKt.getBC_TLS_CRYPTO());
        this.certificateInfo = certificateInfo;
        this.notifyClientCertificateReceived = notifyClientCertificateReceived;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)((Object)this), (Logger)parentLogger, null, (int)2, null);
    }

    @NotNull
    public final byte[] getSrtpKeyingMaterial() {
        if (this.srtpKeyingMaterial != null) {
            return this.srtpKeyingMaterial;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"srtpKeyingMaterial");
        return null;
    }

    public final int getChosenSrtpProtectionProfile() {
        return this.chosenSrtpProtectionProfile;
    }

    public final void setChosenSrtpProtectionProfile(int n) {
        this.chosenSrtpProtectionProfile = n;
    }

    @Nullable
    public TlsSession getSessionToResume(@Nullable byte[] sessionID) {
        return this.session;
    }

    @NotNull
    public Hashtable<?, ?> getServerExtensions() {
        Hashtable extensions;
        Hashtable hashtable;
        Hashtable hashtable2 = super.getServerExtensions();
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        Hashtable it = hashtable = (extensions = hashtable2);
        boolean bl = false;
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)it) == null) {
            int[] nArray = new int[]{this.chosenSrtpProtectionProfile};
            TlsSRTPUtils.addUseSRTPExtension((Hashtable)it, (UseSRTPData)new UseSRTPData(nArray, TlsUtils.EMPTY_BYTES));
        }
        return hashtable;
    }

    public void processClientExtensions(@Nullable Hashtable<?, ?> clientExtensions) {
        super.processClientExtensions(clientExtensions);
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension(clientExtensions);
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        Iterable iterable = SrtpConfig.Companion.getProtectionProfiles();
        Intrinsics.checkNotNull((Object)protectionProfiles);
        this.chosenSrtpProtectionProfile = DtlsUtils.Companion.chooseSrtpProtectionProfile(iterable, ArraysKt.asIterable((int[])protectionProfiles));
    }

    @NotNull
    public int[] getCipherSuites() {
        return CollectionsKt.toIntArray((Collection)DtlsConfig.Companion.getConfig().getCipherSuites());
    }

    @NotNull
    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() {
        TlsCrypto tlsCrypto = this.context.getCrypto();
        Intrinsics.checkNotNull((Object)tlsCrypto, (String)"null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
        return (TlsCredentialedDecryptor)new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)tlsCrypto, this.certificateInfo.getCertificate(), PrivateKeyFactory.createKey((byte[])this.certificateInfo.getKeyPair().getPrivate().getEncoded()));
    }

    @NotNull
    protected TlsCredentialedSigner getECDSASignerCredentials() {
        TlsCryptoParameters tlsCryptoParameters = new TlsCryptoParameters((TlsContext)this.context);
        TlsCrypto tlsCrypto = this.context.getCrypto();
        Intrinsics.checkNotNull((Object)tlsCrypto, (String)"null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
        return (TlsCredentialedSigner)new BcDefaultTlsCredentialedSigner(tlsCryptoParameters, (BcTlsCrypto)tlsCrypto, PrivateKeyFactory.createKey((byte[])this.certificateInfo.getKeyPair().getPrivate().getEncoded()), this.certificateInfo.getCertificate(), new SignatureAndHashAlgorithm(4, 3));
    }

    @NotNull
    public CertificateRequest getCertificateRequest() {
        Vector<SignatureAndHashAlgorithm> signatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(1);
        signatureAlgorithms.add(new SignatureAndHashAlgorithm(4, 3));
        short[] sArray = new short[]{64};
        return new CertificateRequest(sArray, signatureAlgorithms, null);
    }

    public int getHandshakeTimeoutMillis() {
        return (int)DtlsConfig.Companion.getConfig().getHandshakeTimeout().toMillis();
    }

    public void notifyHandshakeComplete() {
        super.notifyHandshakeComplete();
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info((Object)("Negotiated DTLS version " + this.context.getSecurityParameters().getNegotiatedVersion()));
        }
        TlsSession tlsSession = this.context.getResumableSession();
        if (tlsSession != null) {
            TlsSession newSession = tlsSession;
            boolean bl = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            String newSessionIdHex = ByteBufferKt.toHex((ByteBuffer)byteBuffer);
            TlsSession tlsSession2 = this.session;
            if (tlsSession2 != null) {
                TlsSession existingSession = tlsSession2;
                boolean bl2 = false;
                byte[] byArray = existingSession.getSessionID();
                boolean bl3 = byArray != null ? Arrays.equals(byArray, newSession.getSessionID()) : false;
                if (bl3) {
                    Logger $this$cinfo$iv2 = this.logger;
                    boolean $i$f$cinfo2 = false;
                    if ($this$cinfo$iv2.isInfoEnabled()) {
                        Logger logger = $this$cinfo$iv2;
                        boolean bl4 = false;
                        logger.info((Object)("Resumed DTLS session " + newSessionIdHex));
                    }
                }
            } else {
                TlsServerImpl $this$notifyHandshakeComplete_u24lambda_u241_u241 = this;
                boolean bl5 = false;
                Logger $this$cinfo$iv3 = $this$notifyHandshakeComplete_u24lambda_u241_u241.logger;
                boolean $i$f$cinfo3 = false;
                if ($this$cinfo$iv3.isInfoEnabled()) {
                    Logger logger = $this$cinfo$iv3;
                    boolean bl6 = false;
                    logger.info((Object)("Established DTLS session " + newSessionIdHex));
                }
                $this$notifyHandshakeComplete_u24lambda_u241_u241.session = newSession;
            }
        }
        SrtpProfileInformation srtpProfileInformation = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(this.chosenSrtpProtectionProfile);
        if (!this.context.getSecurityParameters().isExtendedMasterSecret()) {
            TlsSession tlsSession3 = this.context.getSession();
            if (tlsSession3 != null && (tlsSession3 = tlsSession3.exportSessionParameters()) != null && (tlsSession3 = tlsSession3.getMasterSecret()) != null) {
                TlsSession it = tlsSession3;
                boolean bl = false;
                TlsServerContext tlsServerContext = this.context;
                Intrinsics.checkNotNullExpressionValue((Object)tlsServerContext, (String)"context");
                this.srtpKeyingMaterial = DtlsUtils.Companion.exportKeyingMaterial((TlsContext)tlsServerContext, "EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()), (TlsSecret)it);
            }
        } else {
            byte[] byArray = this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"exportKeyingMaterial(...)");
            this.srtpKeyingMaterial = byArray;
        }
    }

    public void notifyClientCertificate(@Nullable Certificate clientCertificate) {
        this.notifyClientCertificateReceived.invoke((Object)clientCertificate);
    }

    /*
     * WARNING - void declaration
     */
    public void notifyAlertRaised(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        void $this$notifyAlertRaised$iv;
        void alertDescription$iv;
        Logger logger = this.logger;
        short s = alertLevel;
        short s2 = alertDescription;
        String string = message;
        Throwable cause$iv = cause;
        boolean $i$f$notifyAlertRaised = false;
        if (alertDescription$iv == false) {
            void $this$cdebug$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                void var13_15 = $this$cdebug$iv$iv;
                boolean bl = false;
                var13_15.debug((Object)"close_notify raised, connection closing");
            }
        } else {
            StringBuffer $this$notifyAlertRaised_u24lambda_u241$iv = new StringBuffer();
            boolean bl = false;
            Exception e$iv = new Exception();
            StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            for (StackTraceElement el$iv : stackTraceElementArray) {
                ((Appendable)$this$notifyAlertRaised_u24lambda_u241$iv).append(el$iv.toString()).append('\n');
            }
            String string2 = $this$notifyAlertRaised_u24lambda_u241$iv.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(...)");
            String stack$iv = string2;
            void $this$cinfo$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                void message$iv;
                void alertLevel$iv;
                void var13_16 = $this$cinfo$iv$iv;
                boolean bl2 = false;
                var13_16.info((Object)("Alert raised: level=" + (short)alertLevel$iv + ", description=" + (short)alertDescription$iv + ", message=" + (String)message$iv + " cause=" + cause$iv + " " + stack$iv));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        void $this$notifyAlertReceived$iv;
        Logger logger = this.logger;
        short s = alertLevel;
        short alertDescription$iv = alertDescription;
        boolean $i$f$notifyAlertReceived = false;
        if (alertDescription$iv == 0) {
            void $this$cinfo$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                void var9_11 = $this$cinfo$iv$iv;
                boolean bl = false;
                var9_11.info((Object)"close_notify received, connection closing");
            }
        } else {
            void alertLevel$iv;
            void $this$cerror$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cerror = false;
            void var9_12 = $this$cerror$iv$iv;
            boolean bl = false;
            var9_12.error((Object)("Alert received: level=" + (short)alertLevel$iv + ", description=" + alertDescription$iv + " (" + AlertDescription.getName((short)alertDescription$iv) + ")"));
        }
    }

    @NotNull
    protected ProtocolVersion[] getSupportedVersions() {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[1];
        Intrinsics.checkNotNullExpressionValue((Object)ProtocolVersion.DTLSv12, (String)"DTLSv12");
        return protocolVersionArray;
    }
}

