/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.rtcp.KeyframeRequesterKt;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.PayloadSpecificRtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacketBuilder;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacketBuilder;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.RateLimit;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!H\u0014J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0002J\u0017\u0010(\u001a\u00020)2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020)2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u00020)2\f\u00100\u001a\b\u0012\u0004\u0012\u00020)01H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020)2\u0006\u00107\u001a\u000208R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jitsi/nlj/rtcp/KeyframeRequester;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "logger", "keyframeLimiter", "", "", "Lorg/jitsi/utils/RateLimit;", "keyframeLimiterSyncRoot", "", "firCommandSequenceNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "localSsrc", "Ljava/lang/Long;", "waitInterval", "Ljava/time/Duration;", "numPlisForwarded", "", "numFirsForwarded", "numPlisDropped", "numFirsDropped", "numPlisGenerated", "numFirsGenerated", "numApiRequests", "numApiRequestsDropped", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "canSendKeyframeRequest", "", "mediaSsrc", "now", "Ljava/time/Instant;", "requestKeyframe", "", "(Ljava/lang/Long;)V", "doRequestKeyframe", "handleEvent", "event", "Lorg/jitsi/nlj/Event;", "trace", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "onRttUpdate", "newRtt", "", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nKeyframeRequester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyframeRequester.kt\norg/jitsi/nlj/rtcp/KeyframeRequester\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 4 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,249:1\n1#2:250\n63#3,4:251\n63#3,4:255\n63#3,4:259\n68#4,6:263\n68#4,6:269\n68#4,6:275\n*S KotlinDebug\n*F\n+ 1 KeyframeRequester.kt\norg/jitsi/nlj/rtcp/KeyframeRequester\n*L\n138#1:251,4\n141#1:255,4\n150#1:259,4\n227#1:263,6\n230#1:269,6\n233#1:275,6\n*E\n"})
public final class KeyframeRequester
extends TransformerNode {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Long, RateLimit> keyframeLimiter;
    @NotNull
    private final Object keyframeLimiterSyncRoot;
    @NotNull
    private final AtomicInteger firCommandSequenceNumber;
    @Nullable
    private Long localSsrc;
    @NotNull
    private Duration waitInterval;
    private int numPlisForwarded;
    private int numFirsForwarded;
    private int numPlisDropped;
    private int numFirsDropped;
    private int numPlisGenerated;
    private int numFirsGenerated;
    private int numApiRequests;
    private int numApiRequestsDropped;
    @NotNull
    private static final ConfigDelegate<Duration> minInterval$delegate;
    @NotNull
    private static final ConfigDelegate<Integer> maxRequests$delegate;
    @NotNull
    private static final ConfigDelegate<Duration> maxRequestInterval$delegate;

    @JvmOverloads
    public KeyframeRequester(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super("Keyframe Requester");
        this.streamInformationStore = streamInformationStore;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.keyframeLimiter = new LinkedHashMap();
        this.keyframeLimiterSyncRoot = new Object();
        this.firCommandSequenceNumber = new AtomicInteger(0);
        this.waitInterval = KeyframeRequester.Companion.getMinInterval();
    }

    public /* synthetic */ KeyframeRequester(ReadOnlyStreamInformationStore readOnlyStreamInformationStore, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone(...)");
            clock = clock2;
        }
        this(readOnlyStreamInformationStore, logger, clock);
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        RtcpFbPacket rtcpFbPacket = KeyframeRequesterKt.access$getPliOrFirPacket(packetInfo);
        if (rtcpFbPacket == null) {
            return packetInfo;
        }
        RtcpFbPacket pliOrFirPacket = rtcpFbPacket;
        Instant now = this.clock.instant();
        long sourceSsrc = 0L;
        boolean canSend = false;
        boolean forward = false;
        RtcpFbPacket rtcpFbPacket2 = pliOrFirPacket;
        if (rtcpFbPacket2 instanceof RtcpFbPliPacket) {
            int n;
            sourceSsrc = pliOrFirPacket.getMediaSourceSsrc();
            Intrinsics.checkNotNull((Object)now);
            canSend = this.canSendKeyframeRequest(sourceSsrc, now);
            boolean bl = forward = canSend && this.streamInformationStore.getSupportsPli();
            if (forward) {
                n = this.numPlisForwarded;
                this.numPlisForwarded = n + 1;
            }
            if (!canSend) {
                n = this.numPlisDropped;
                this.numPlisDropped = n + 1;
            }
        } else if (rtcpFbPacket2 instanceof RtcpFbFirPacket) {
            int n;
            sourceSsrc = ((RtcpFbFirPacket)pliOrFirPacket).getMediaSenderSsrc();
            Intrinsics.checkNotNull((Object)now);
            canSend = this.canSendKeyframeRequest(sourceSsrc, now);
            boolean bl = forward = canSend && this.streamInformationStore.getSupportsFir() && !this.streamInformationStore.getSupportsPli();
            if (forward) {
                ((RtcpFbFirPacket)pliOrFirPacket).setSeqNum(this.firCommandSequenceNumber.incrementAndGet());
                Long l = this.localSsrc;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    ((RtcpFbFirPacket)pliOrFirPacket).setMediaSenderSsrc(it);
                }
                n = this.numFirsForwarded;
                this.numFirsForwarded = n + 1;
            }
            if (!canSend) {
                n = this.numFirsDropped;
                this.numFirsDropped = n + 1;
            }
        } else {
            throw new IllegalStateException("Packet is neither PLI nor FIR");
        }
        if (!forward && canSend) {
            this.doRequestKeyframe(sourceSsrc);
        }
        return forward ? packetInfo : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canSendKeyframeRequest(long mediaSsrc, Instant now) {
        if (!this.streamInformationStore.getSupportsPli() && !this.streamInformationStore.getSupportsFir()) {
            return false;
        }
        Object object = this.keyframeLimiterSyncRoot;
        synchronized (object) {
            boolean bl;
            Logger logger;
            boolean $i$f$cdebug;
            Logger $this$cdebug$iv;
            boolean bl2 = false;
            RateLimit rateLimit = this.keyframeLimiter.computeIfAbsent(mediaSsrc, arg_0 -> KeyframeRequester.canSendKeyframeRequest$lambda$0$1(KeyframeRequester::canSendKeyframeRequest$lambda$0$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rateLimit, (String)"computeIfAbsent(...)");
            RateLimit limiter = rateLimit;
            if (!limiter.accept(now, this.waitInterval)) {
                $this$cdebug$iv = this.logger;
                $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    logger = $this$cdebug$iv;
                    boolean bl3 = false;
                    logger.debug((Object)("Ignoring keyframe request for " + mediaSsrc + ", rate limited"));
                }
                bl = false;
            } else {
                $this$cdebug$iv = this.logger;
                $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    logger = $this$cdebug$iv;
                    boolean bl4 = false;
                    logger.debug((Object)("Keyframe requester requesting keyframe for " + mediaSsrc));
                }
                bl = true;
            }
            boolean bl5 = bl;
            return bl5;
        }
    }

    public final void requestKeyframe(@Nullable Long mediaSsrc) {
        long l;
        Long l2 = mediaSsrc;
        if (l2 != null) {
            l = l2;
        } else {
            Long l3 = (Long)CollectionsKt.firstOrNull((Iterable)this.streamInformationStore.getPrimaryMediaSsrcs());
            if (l3 != null) {
                l = l3;
            } else {
                KeyframeRequester $this$requestKeyframe_u24lambda_u240 = this;
                boolean bl = false;
                int n = $this$requestKeyframe_u24lambda_u240.numApiRequestsDropped;
                $this$requestKeyframe_u24lambda_u240.numApiRequestsDropped = n + 1;
                Logger $this$cdebug$iv = $this$requestKeyframe_u24lambda_u240.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl2 = false;
                    logger.debug((Object)"No video SSRC found to request keyframe");
                }
                return;
            }
        }
        long ssrc = l;
        int n = this.numApiRequests;
        this.numApiRequests = n + 1;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        if (!this.canSendKeyframeRequest(ssrc, instant)) {
            n = this.numApiRequestsDropped;
            this.numApiRequestsDropped = n + 1;
            return;
        }
        this.doRequestKeyframe(ssrc);
    }

    public static /* synthetic */ void requestKeyframe$default(KeyframeRequester keyframeRequester, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        keyframeRequester.requestKeyframe(l);
    }

    private final void doRequestKeyframe(long mediaSsrc) {
        PayloadSpecificRtcpFbPacket payloadSpecificRtcpFbPacket;
        int n;
        if (this.streamInformationStore.getSupportsPli()) {
            n = this.numPlisGenerated;
            this.numPlisGenerated = n + 1;
            payloadSpecificRtcpFbPacket = (PayloadSpecificRtcpFbPacket)new RtcpFbPliPacketBuilder(null, mediaSsrc, 1, null).build();
        } else if (this.streamInformationStore.getSupportsFir()) {
            n = this.numFirsGenerated;
            this.numFirsGenerated = n + 1;
            payloadSpecificRtcpFbPacket = (PayloadSpecificRtcpFbPacket)new RtcpFbFirPacketBuilder(null, mediaSsrc, this.firCommandSequenceNumber.incrementAndGet(), 1, null).build();
        } else {
            this.logger.warn((Object)"Can not send neither PLI nor FIR");
            return;
        }
        PayloadSpecificRtcpFbPacket pkt = payloadSpecificRtcpFbPacket;
        this.next(new PacketInfo((Packet)pkt, 0, null, 6, null));
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof SetLocalSsrcEvent && ((SetLocalSsrcEvent)event).getMediaType() == MediaType.VIDEO) {
            this.localSsrc = ((SetLocalSsrcEvent)event).getSsrc();
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("wait_interval_ms", this.waitInterval.toMillis());
        $this$getNodeStats_u24lambda_u240.addNumber("num_api_requests", this.numApiRequests);
        $this$getNodeStats_u24lambda_u240.addNumber("num_api_requests_dropped", this.numApiRequestsDropped);
        $this$getNodeStats_u24lambda_u240.addNumber("num_firs_dropped", this.numFirsDropped);
        $this$getNodeStats_u24lambda_u240.addNumber("num_firs_generated", this.numFirsGenerated);
        $this$getNodeStats_u24lambda_u240.addNumber("num_firs_forwarded", this.numFirsForwarded);
        $this$getNodeStats_u24lambda_u240.addNumber("num_plis_dropped", this.numPlisDropped);
        $this$getNodeStats_u24lambda_u240.addNumber("num_plis_generated", this.numPlisGenerated);
        $this$getNodeStats_u24lambda_u240.addNumber("num_plis_forwarded", this.numPlisForwarded);
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    public OrderedJsonObject statsJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$statsJson_u24lambda_u240 = orderedJsonObject = super.statsJson();
        boolean bl = false;
        ((Map)$this$statsJson_u24lambda_u240).put("num_api_requests", this.numApiRequests);
        ((Map)$this$statsJson_u24lambda_u240).put("num_api_requests_dropped", this.numApiRequestsDropped);
        ((Map)$this$statsJson_u24lambda_u240).put("num_firs_dropped", this.numFirsDropped);
        ((Map)$this$statsJson_u24lambda_u240).put("num_firs_generated", this.numFirsGenerated);
        ((Map)$this$statsJson_u24lambda_u240).put("num_firs_forwarded", this.numFirsForwarded);
        ((Map)$this$statsJson_u24lambda_u240).put("num_plis_dropped", this.numPlisDropped);
        ((Map)$this$statsJson_u24lambda_u240).put("num_plis_generated", this.numPlisGenerated);
        ((Map)$this$statsJson_u24lambda_u240).put("num_plis_forwarded", this.numPlisForwarded);
        return orderedJsonObject;
    }

    public final void onRttUpdate(double newRtt) {
        this.waitInterval = DurationKt.min((Duration)KeyframeRequester.Companion.getMinInterval(), (Duration)DurationKt.durationOfDoubleSeconds((double)((newRtt + (double)10) / 1000.0)));
    }

    @JvmOverloads
    public KeyframeRequester(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this(streamInformationStore, parentLogger, null, 4, null);
    }

    private static final RateLimit canSendKeyframeRequest$lambda$0$0(Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RateLimit(KeyframeRequester.Companion.getMinInterval(), KeyframeRequester.Companion.getMaxRequests(), KeyframeRequester.Companion.getMaxRequestInterval(), null, 8, null);
    }

    private static final RateLimit canSendKeyframeRequest$lambda$0$1(Function1 $tmp0, Object p0) {
        return (RateLimit)$tmp0.invoke(p0);
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$minInterval_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl = false;
        $this$minInterval_delegate_u24lambda_u240.from("jmt.keyframe.min-interval", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        minInterval$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$maxRequests_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Integer.TYPE));
        boolean bl2 = false;
        $this$maxRequests_delegate_u24lambda_u240.from("jmt.keyframe.max-requests", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        maxRequests$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$maxRequestInterval_delegate_u24lambda_u240 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl3 = false;
        $this$maxRequestInterval_delegate_u24lambda_u240.from("jmt.keyframe.max-request-interval", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        maxRequestInterval$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/rtcp/KeyframeRequester$Companion;", "", "<init>", "()V", "minInterval", "Ljava/time/Duration;", "getMinInterval", "()Ljava/time/Duration;", "minInterval$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "maxRequests", "", "getMaxRequests", "()I", "maxRequests$delegate", "maxRequestInterval", "getMaxRequestInterval", "maxRequestInterval$delegate", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Duration getMinInterval() {
            return (Duration)minInterval$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final int getMaxRequests() {
            return ((Number)maxRequests$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
        }

        private final Duration getMaxRequestInterval() {
            return (Duration)maxRequestInterval$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "minInterval", "getMinInterval()Ljava/time/Duration;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "maxRequests", "getMaxRequests()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "maxRequestInterval", "getMaxRequestInterval()Ljava/time/Duration;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

